---
generated_at: 2025-12-26 12:03:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：94-職位詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/JobPositionResource/Pages/ViewJobPosition.php`
- E-02: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/JobPositionResource.php`
- E-03: `plugins/webkul/employees/src/Models/EmployeeJobPosition.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewRecordを継承している | E-01 | ○ |
| C-02 | JobPositionResourceをリソースとして使用 | E-01 | ○ |
| C-03 | EditActionがヘッダーに存在 | E-01 getHeaderActions() | ○ |
| C-04 | サブナビゲーションが表示される | E-01 getSubNavigation() | ○ |
| C-05 | infolist()で表示項目が定義 | E-02 infolist() | ○ |
| C-06 | 3カラムレイアウトを使用 | E-02 Grid::make(['default' => 3]) | ○ |
| C-07 | 職位名表示が存在 | E-02 TextEntry::make('name') | ○ |
| C-08 | 部署名表示が存在 | E-02 TextEntry::make('department.name') | ○ |
| C-09 | 会社名表示が存在 | E-02 TextEntry::make('company.name') | ○ |
| C-10 | 職務内容がHTML形式で表示 | E-02 html() | ○ |
| C-11 | 必要要件がHTML形式で表示 | E-02 html() | ○ |
| C-12 | ステータスがIconEntryで表示 | E-02 IconEntry::make('is_active') | ○ |
| C-13 | プレースホルダ「—」が設定 | E-02 placeholder('—') | ○ |
| C-14 | アイコンが設定されている | E-02 icon('heroicon-*') | ○ |
| C-15 | URLパターン/{record} | E-02 getPages() | ○ |
| C-16 | 画面一覧に登録されている | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] HTML形式の職務内容・必要要件が正しく表示されるか確認
- [ ] リレーションデータ（部署名、会社名、雇用形態）が正しく表示されるか確認
