---
generated_at: 2025-12-26 12:04:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：95-カレンダー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/CalendarResource/Pages/ListCalendars.php`
- E-02: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/CalendarResource.php`
- E-03: `plugins/webkul/employees/src/Models/Calendar.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListRecordsを継承している | E-01 | ○ |
| C-02 | CalendarResourceをリソースとして使用 | E-01 | ○ |
| C-03 | ヘッダーに作成ボタンが存在 | E-01 getHeaderActions() | ○ |
| C-04 | 作成成功時に通知が表示される | E-01 successNotification | ○ |
| C-05 | 全件タブが存在 | E-01 getTabs() | ○ |
| C-06 | アーカイブ済みタブが存在 | E-01 getTabs() | ○ |
| C-07 | タブにバッジ（件数）が表示される | E-01 badge() | ○ |
| C-08 | ID列が存在（デフォルト非表示） | E-02 table() | ○ |
| C-09 | スケジュール名列が存在 | E-02 TextColumn::make('name') | ○ |
| C-10 | タイムゾーン列が存在 | E-02 TextColumn::make('timezone') | ○ |
| C-11 | 会社名列が存在 | E-02 TextColumn::make('company.name') | ○ |
| C-12 | フレックスタイム列が存在 | E-02 IconColumn::make('flexible_hours') | ○ |
| C-13 | ステータス列が存在 | E-02 IconColumn::make('is_active') | ○ |
| C-14 | カラム並び替え機能が存在 | E-02 reorderableColumns() | ○ |
| C-15 | ActionGroupで行アクションがグループ化 | E-02 ActionGroup::make() | ○ |
| C-16 | 削除アクションが存在 | E-02 DeleteAction::make() | ○ |
| C-17 | 復元アクションが存在 | E-02 RestoreAction::make() | ○ |
| C-18 | 強制削除アクションが存在 | E-02 ForceDeleteAction::make() | ○ |
| C-19 | 一括削除アクションが存在 | E-02 DeleteBulkAction::make() | ○ |
| C-20 | 一括復元アクションが存在 | E-02 RestoreBulkAction::make() | ○ |
| C-21 | 一括強制削除アクションが存在 | E-02 ForceDeleteBulkAction::make() | ○ |
| C-22 | SoftDeletesを使用 | E-03 use SoftDeletes | ○ |
| C-23 | employees_calendarsテーブルを使用 | E-03 $table | ○ |
| C-24 | 画面一覧に登録されている | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] タブの件数バッジが正しく表示されるか確認
- [ ] アーカイブ済みタブで削除されたデータのみ表示されるか確認
