---
generated_at: 2025-12-26 12:07:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：98-カレンダー詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/CalendarResource/Pages/ViewCalendar.php`
- E-02: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/CalendarResource.php`
- E-03: `plugins/webkul/employees/src/Models/Calendar.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewRecordを継承している | E-01 | ○ |
| C-02 | CalendarResourceをリソースとして使用 | E-01 | ○ |
| C-03 | EditActionがヘッダーに存在 | E-01 getHeaderActions() | ○ |
| C-04 | DeleteActionがヘッダーに存在 | E-01 getHeaderActions() | ○ |
| C-05 | 削除成功通知が表示される | E-01 DeleteAction successNotification | ○ |
| C-06 | サブナビゲーションが表示される | E-01 getSubNavigation() | ○ |
| C-07 | infolist()で表示項目が定義 | E-02 infolist() | ○ |
| C-08 | 3カラムレイアウトを使用 | E-02 Grid::make(['default' => 3]) | ○ |
| C-09 | スケジュール名表示が存在 | E-02 TextEntry::make('name') | ○ |
| C-10 | タイムゾーン表示が存在 | E-02 TextEntry::make('timezone') | ○ |
| C-11 | 会社名表示が存在 | E-02 TextEntry::make('company.name') | ○ |
| C-12 | ステータスがIconEntryで表示 | E-02 IconEntry::make('is_active') | ○ |
| C-13 | 2週間カレンダーがIconEntryで表示 | E-02 IconEntry::make('two_weeks_calendar') | ○ |
| C-14 | フレックスタイムがIconEntryで表示 | E-02 IconEntry::make('flexible_hours') | ○ |
| C-15 | プレースホルダ「—」が設定 | E-02 placeholder('—') | ○ |
| C-16 | CalendarAttendanceリレーションマネージャーが存在 | E-02 getRelations() | ○ |
| C-17 | URLパターン/{record} | E-02 getPages() | ○ |
| C-18 | 画面一覧に登録されている | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] CalendarAttendanceリレーションマネージャーが正しく表示されるか確認
- [ ] 削除後に一覧画面へ正しく遷移するか確認
