---
generated_at: 2025-12-27 09:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 64
  claims_without_evidence: 6
confidence_derived: 0.91
---

# 根拠レポート：結合テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された結合テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：64 / 70、根拠なし：6
- 優先レビュー（高）
  1. **IT-047 テーブルビュー連携**：table-views プラグインの詳細実装未確認
  2. **IT-048 フルカレンダー連携**：full-calendar プラグインの詳細実装未確認
  3. **IT-055 購買契約連携**：PurchaseAgreement からの注文生成ロジック詳細未確認
  4. **IT-066 分析レコード連携**：analytics プラグインの詳細実装未確認
  5. **IT-065 カスタムフィールド連携**：fields プラグインの詳細実装未確認
  6. **IT-068 プラグイン管理連携**：PluginManager の動的機能追加ロジック詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/Providers/Filament/AdminPanelProvider.php` - Filament管理パネル設定
- E-02: `app/Providers/Filament/CustomerPanelProvider.php` - Filamentカスタマーパネル設定
- E-03: `plugins/webkul/security/src/Models/User.php` - ユーザーモデル、Partner連携boot()
- E-04: `plugins/webkul/employees/src/Models/Employee.php` - 従業員モデル、Partner連携boot()
- E-05: `plugins/webkul/purchases/src/Models/Order.php` - 購買注文モデル、自動採番boot()
- E-06: `plugins/webkul/sales/src/Models/Order.php` - 販売注文モデル、自動採番boot()
- E-07: `plugins/webkul/accounts/src/Models/Move.php` - 会計移動モデル、請求書番号自動採番
- E-08: `plugins/webkul/inventories/src/Models/Operation.php` - 在庫オペレーションモデル
- E-09: `plugins/webkul/partners/src/Models/Partner.php` - パートナーモデル
- E-10: `plugins/webkul/products/src/Models/Product.php` - 商品モデル
- E-11: `plugins/webkul/purchases/routes/web.php` - 購買ポータルルート（署名付きURL）
- E-12: `plugins/webkul/security/routes/web.php` - セキュリティルート（招待承諾）
- E-13: `plugins/webkul/support/src/Services/EmailService.php` - メール送信サービス
- E-14: `plugins/webkul/chatter/src/Traits/HasChatter.php` - チャッター機能trait
- E-15: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Actions/` - 購買注文アクション群
- E-16: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Actions/` - 販売見積アクション群
- E-17: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/` - 請求書アクション群
- E-18: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/` - 在庫オペレーションアクション群
- E-19: `plugins/webkul/products/src/Filament/Resources/ProductResource/Actions/GenerateVariantsAction.php` - バリアント生成
- E-20: `plugins/webkul/time-off/src/Models/` - 休暇関連モデル群
- E-21: `plugins/webkul/projects/src/Models/` - プロジェクト関連モデル群
- E-22: `plugins/webkul/recruitments/src/Models/` - 採用関連モデル群
- E-23: `plugins/webkul/blogs/src/Models/` - ブログ関連モデル群
- E-24: `plugins/webkul/invoices/src/Models/` - 請求書関連モデル群
- E-25: `composer.json` - barryvdh/laravel-dompdf、spatie/eloquent-sortable などの依存関係
- E-26: `plugins/webkul/security/src/Models/Team.php` - チームモデル
- E-27: `plugins/webkul/sales/src/Models/Team.php` - 販売チームモデル
- E-28: `database/migrations/` - データベースマイグレーション群
- E-29: `plugins/webkul/chatter/src/Traits/HasLogActivity.php` - 活動ログtrait（参照）
- E-30: `plugins/webkul/field/src/Traits/HasCustomFields.php` - カスタムフィールドtrait（参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001 ユーザーログイン認証連携 | E-01, E-02 | ○ |
| C-02 | IT-002 パスワードリセットメール送信連携 | E-01, E-13 | ○ |
| C-03 | IT-003 ユーザー作成時Partner自動生成 | E-03 | ○ |
| C-04 | IT-004 従業員作成時Partner自動生成 | E-04 | ○ |
| C-05 | IT-005 購買注文番号自動採番 | E-05 | ○ |
| C-06 | IT-006 販売注文番号自動採番 | E-06 | ○ |
| C-07 | IT-007 請求書番号自動採番 | E-07 | ○ |
| C-08 | IT-008 購買注文-在庫オペレーション連携 | E-05, E-08 | ○ |
| C-09 | IT-009 販売注文-在庫オペレーション連携 | E-06, E-08 | ○ |
| C-10 | IT-010 購買注文-請求書生成連携 | E-05, E-15 | ○ |
| C-11 | IT-011 販売注文-請求書生成連携 | E-06, E-16 | ○ |
| C-12 | IT-012 署名付きURL購買見積回答 | E-11 | ○ |
| C-13 | IT-013 署名付きURL招待承諾 | E-12 | ○ |
| C-14 | IT-014 購買注文メール送信 | E-13, E-15 | ○ |
| C-15 | IT-015 チャッターメッセージ追加 | E-14 | ○ |
| C-16 | IT-016 チャッター添付ファイル追加 | E-14 | ○ |
| C-17 | IT-017 フォロワー追加と通知 | E-14 | ○ |
| C-18 | IT-018 活動ログ記録 | E-29 | ○ |
| C-19 | IT-019 商品バリアント自動生成 | E-10, E-19 | ○ |
| C-20 | IT-020 在庫オペレーション検証 | E-08, E-18 | ○ |
| C-21 | IT-021 在庫オペレーション名前自動更新 | E-08 | ○ |
| C-22 | IT-022 請求書確認ステータス更新 | E-07, E-17 | ○ |
| C-23 | IT-023 請求書支払い登録 | E-17 | ○ |
| C-24 | IT-024 貸方票生成 | E-07, E-17 | ○ |
| C-25 | IT-025 見積から販売注文確認 | E-16 | ○ |
| C-26 | IT-026 販売注文キャンセル | E-16 | ○ |
| C-27 | IT-027 購買注文確認 | E-15 | ○ |
| C-28 | IT-028 購買注文ロック/アンロック | E-15 | ○ |
| C-29 | IT-029 デフォルト会社設定 | E-03 | ○ |
| C-30 | IT-030 許可会社設定 | E-03 | ○ |
| C-31 | IT-031 休暇申請と承認者通知 | E-20 | ○ |
| C-32 | IT-032 休暇割当と発生計画 | E-20 | ○ |
| C-33 | IT-033 プロジェクト-タスク-マイルストーン | E-21 | ○ |
| C-34 | IT-034 タスクステージ変更 | E-21 | ○ |
| C-35 | IT-035 応募者-候補者データ連携 | E-22 | ○ |
| C-36 | IT-036 応募者ステージ変更と通知 | E-22 | ○ |
| C-37 | IT-037 商品カテゴリ階層と価格リスト | E-10 | ○ |
| C-38 | IT-038 商品サプライヤー情報と購買 | E-10 | ○ |
| C-39 | IT-039 仕訳帳と会計移動の整合性 | E-07 | ○ |
| C-40 | IT-040 会計移動明細の自動計算 | E-07 | ○ |
| C-41 | IT-041 税金グループと税計算 | E-07, E-24 | ○ |
| C-42 | IT-042 パートナー-アドレス階層 | E-09 | ○ |
| C-43 | IT-043 パートナー銀行口座 | E-09, E-07 | ○ |
| C-44 | IT-044 在庫ロケーション階層と移動 | E-08 | ○ |
| C-45 | IT-045 在庫オペレーション返品処理 | E-08, E-18 | ○ |
| C-46 | IT-046 ブログ投稿-カテゴリ-タグ | E-23 | ○ |
| C-47 | IT-047 カスタムテーブルビュー | **根拠なし** | △ |
| C-48 | IT-048 フルカレンダーイベント操作 | **根拠なし** | △ |
| C-49 | IT-049 ロールと権限のFilament Shield | E-01, E-25 | ○ |
| C-50 | IT-050 チーム所属とデータアクセス | E-03, E-26 | ○ |
| C-51 | IT-051 購買注文RFQ印刷 | E-15, E-25 | ○ |
| C-52 | IT-052 請求書プレビューと印刷 | E-17, E-25 | ○ |
| C-53 | IT-053 在庫オペレーション可用性チェック | E-18 | ○ |
| C-54 | IT-054 タイムシート-プロジェクト-タスク | E-21 | ○ |
| C-55 | IT-055 購買契約と注文 | **根拠なし** | △ |
| C-56 | IT-056 販売チームとメンバー | E-27 | ○ |
| C-57 | IT-057 見積テンプレートと注文 | E-06 | ○ |
| C-58 | IT-058 財務ポジションと税マッピング | E-07 | ○ |
| C-59 | IT-059 支払条件と期日計算 | E-07 | ○ |
| C-60 | IT-060 インコタームズと配送条件 | E-07 | ○ |
| C-61 | IT-061 UTMソース/メディアと売上分析 | E-06 | ○ |
| C-62 | IT-062 商品パッケージングと在庫 | E-10 | ○ |
| C-63 | IT-063 従業員-部門-階層 | E-04 | ○ |
| C-64 | IT-064 従業員スキルと評価 | E-04 | ○ |
| C-65 | IT-065 カスタムフィールド追加 | **根拠なし** | △ |
| C-66 | IT-066 分析レコードとプロジェクト | **根拠なし** | △ |
| C-67 | IT-067 管理者/カスタマーパネル切替 | E-01, E-02 | ○ |
| C-68 | IT-068 プラグイン有効化と機能 | **根拠なし** | △ |
| C-69 | IT-069 購買注文受領日確認 | E-15 | ○ |
| C-70 | IT-070 ソート順保存 | E-07, E-10, E-25 | ○ |

## 4) 不足情報（Unknown / Missing）
- **table-views プラグイン (IT-047)**：プラグインは存在するが、詳細なビュー保存/復元ロジックの実装コード未確認
  - 候補：`plugins/webkul/table-views/src/` 配下の詳細実装
- **full-calendar プラグイン (IT-048)**：アクションファイルは存在するが、カレンダーとエンティティの連携詳細未確認
  - 候補：`plugins/webkul/full-calendar/src/` 配下の詳細実装
- **PurchaseAgreement 連携 (IT-055)**：PurchaseAgreementResourceは存在するが、注文生成ロジック詳細未確認
  - 候補：PurchaseAgreementResource内のアクション実装
- **カスタムフィールド連携 (IT-065)**：HasCustomFields traitは参照されているが、fields プラグインの詳細実装未確認
  - 候補：`plugins/webkul/fields/src/` 配下の詳細実装
- **分析レコード連携 (IT-066)**：analyticsプラグインは存在するが、プロジェクトとの連携詳細未確認
  - 候補：`plugins/webkul/analytics/src/` 配下の詳細実装
- **プラグイン管理連携 (IT-068)**：PluginManagerはパネル設定で使用されているが、動的機能追加の詳細ロジック未確認
  - 候補：`plugins/webkul/plugin-manager/src/PluginManager.php`

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - 上記6件の根拠不足項目について、実装が存在するかどうかの確認が必要
- **0: 低リスク** - その他64件は、ソースコード上の根拠が確認できており、テストケースの妥当性は高い
- **重要な連携ポイント**：
  - 購買-販売-在庫-会計の基幹業務フロー連携（IT-008〜IT-011）は優先度高でテスト必須
  - ユーザー/従業員-パートナー自動生成（IT-003, IT-004）はデータ整合性の観点で重要
  - 認証/認可（IT-001, IT-049, IT-067）はセキュリティ観点で重要

## 6) レビュアーチェックリスト（最小）
- [ ] 根拠なし（△）の6件について、実装の有無を確認
- [ ] 購買-販売-在庫-会計連携フローの整合性を確認（IT-008〜IT-011）
- [ ] 認証/認可関連テストケースのセキュリティ観点レビュー
- [ ] boot()メソッドによる自動処理の副作用確認（IT-003〜IT-007）
- [ ] 外部サービス連携（メール、PDF）のモック化方針確認
- [ ] データベースマイグレーションとモデルリレーションの整合性確認
