---
generated_at: 2025-12-26 14:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された通知一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **アプリ内通知（一般）**：Filament Notificationの使用箇所は多数存在するが、全ての利用シーンを網羅的に特定することは困難
  2. **メール認証通知**：Filament標準機能を使用しており、カスタマイズ有無の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/security/src/Mail/UserInvitationMail.php`
- E-02: `plugins/webkul/purchases/src/Mail/VendorPurchaseOrderMail.php`
- E-03: `plugins/webkul/sales/src/Mail/SaleOrderQuotation.php`
- E-04: `plugins/webkul/sales/src/Mail/SaleOrderCancelQuotation.php`
- E-05: `plugins/webkul/accounts/src/Mail/Invoice/Actions/InvoiceEmail.php`
- E-06: `plugins/webkul/chatter/src/Mail/FollowerMail.php`
- E-07: `plugins/webkul/chatter/src/Mail/MessageMail.php`
- E-08: `plugins/webkul/recruitments/src/Mail/ApplicationConfirmMail.php`
- E-09: `plugins/webkul/recruitments/src/Mail/ApplicantRefuseMail.php`
- E-10: `plugins/webkul/recruitments/src/Mail/InterviewerAssignedMail.php`
- E-11: `plugins/webkul/website/src/Filament/Customer/Auth/Register.php`
- E-12: `plugins/webkul/security/src/Filament/Resources/UserResource/Pages/ListUsers.php`
- E-13: `plugins/webkul/purchases/src/PurchaseOrder.php`
- E-14: `plugins/webkul/sales/src/SaleManager.php`
- E-15: `plugins/webkul/accounts/src/AccountManager.php`
- E-16: `plugins/webkul/chatter/src/Filament/Actions/Chatter/MessageAction.php`
- E-17: `plugins/webkul/chatter/src/Filament/Actions/Chatter/FollowerAction.php`
- E-18: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/ApplicantResource/Pages/EditApplicant.php`
- E-19: `plugins/webkul/support/src/Services/EmailService.php`
- E-20: `plugins/webkul/support/src/Services/EmailTemplateService.php`
- E-21: `config/mail.php`
- E-22: `plugins/webkul/time-off/src/Filament/Widgets/OverviewCalendarWidget.php`
- E-23: `plugins/webkul/timesheets/src/Filament/Resources/TimesheetResource.php`
- E-24: `plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource.php`
- E-25: `plugins/webkul/products/src/Filament/Resources/ProductResource/Actions/GenerateVariantsAction.php`
- E-26: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/ValidateAction.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ユーザー招待メール | E-01, E-12 | ○ |
| C-02 | 購買発注メール | E-02, E-13 | ○ |
| C-03 | 販売見積メール | E-03, E-14 | ○ |
| C-04 | 販売見積キャンセルメール | E-04, E-14 | ○ |
| C-05 | 請求書送信メール | E-05, E-15 | ○ |
| C-06 | フォロワー追加メール | E-06, E-17 | ○ |
| C-07 | メッセージ通知メール | E-07, E-16 | ○ |
| C-08 | 応募確認メール | E-08, E-18 | ○ |
| C-09 | 応募者不採用メール | E-09, E-18 | ○ |
| C-10 | 面接官アサインメール | E-10, E-18 | ○ |
| C-11 | メール認証通知 | E-11 | △ |
| C-12 | 操作成功通知 | Filament Notification使用箇所多数 | ○ |
| C-13 | 操作失敗通知 | Filament Notification使用箇所多数 | ○ |
| C-14 | 警告通知 | Filament Notification使用箇所多数 | △ |
| C-15 | 休暇申請関連通知 | E-22 | ○ |
| C-16 | 休暇割当関連通知 | time-offプラグイン内で確認 | ○ |
| C-17 | 勤怠記録通知 | E-23 | ○ |
| C-18 | プラグイン操作通知 | E-24 | ○ |
| C-19 | 商品バリアント生成通知 | E-25 | ○ |
| C-20 | 在庫操作通知 | E-26 | ○ |

## 4) 不足情報（Unknown / Missing）
- **Filament Notification（アプリ内通知）の網羅性**
  - Filament Notificationは379ファイルで使用されており、全ての通知シーンを個別に特定・文書化することは現実的でないため、代表的なカテゴリとして集約して記載
  - 候補：各プラグインの詳細な通知シーン分析 / 通知テンプレートの言語ファイル調査

- **メール認証通知のカスタマイズ状況**
  - Filament標準の`VerifyEmail`通知を使用しているが、カスタマイズの有無は未確認
  - 候補：Filament設定ファイル / カスタム通知クラスの有無確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: メール通知（C-01〜C-10）- Mailableクラスとして明確に実装されており、確認容易
- **1（中リスク）**: アプリ内通知（C-12〜C-20）- 使用箇所が多く、全シーンの網羅性に不確実性あり
- **1（中リスク）**: メール認証通知（C-11）- 標準機能使用のため、カスタマイズ有無の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] メール通知のMailableクラス（E-01〜E-10）が正しくリストされているか確認
- [ ] 各メール通知の送信トリガー（ユースケース）が適切に記述されているか確認
- [ ] Filament Notificationの主要な使用シーンが漏れなく含まれているか確認
- [ ] メール認証通知のカスタマイズ状況を確認（必要に応じて）
- [ ] 他に未発見の通知機能がないか、プラグイン一覧と照合して確認
