# 通知設計書 1-ユーザー招待メール

## 概要

本ドキュメントは、AureusERPシステムにおけるユーザー招待メール通知機能の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、システム管理者が新しいユーザーをAureusERPシステムに招待する際に送信されるメール通知である。

**業務上の目的・背景**：企業のERPシステムにおいて、新規ユーザーの追加は頻繁に発生する業務である。従来の手動でのアカウント作成プロセスでは、管理者がパスワードを設定し、それを新規ユーザーに伝達する必要があった。本通知機能により、招待メールを通じて新規ユーザー自身がアカウントを作成できるようになり、セキュリティの向上と管理者の負担軽減を実現する。

**通知の送信タイミング**：ユーザー管理画面において、管理者が「ユーザーを招待」アクションを実行し、招待対象のメールアドレスを入力して送信ボタンをクリックした時点で即座に送信される。

**通知の受信者**：招待フォームで指定されたメールアドレスの所有者。既存ユーザーかどうかの事前チェックは行われない。

**通知内容の概要**：システムへの招待メッセージ、アカウント作成用の署名付きURLリンク（ボタン）、および招待を受けた覚えがない場合の対処法が含まれる。

**期待されるアクション**：受信者はメール内の「アカウント作成」ボタンをクリックし、アカウント登録フォームに必要情報を入力してアカウントを作成することが期待される。

## 通知種別

メール通知（HTML形式、Laravel Mailableコンポーネント使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Queueable trait使用） |
| 優先度 | 中 |
| リトライ | Laravelキューのデフォルト設定に依存 |

### 送信先決定ロジック

管理者が招待フォームに入力したメールアドレスに直接送信される。送信先の決定に特別なロジックはなく、入力されたメールアドレスがそのまま使用される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | システムのデフォルトメールアドレス（config('mail.from.address')） |
| 送信元名称 | システムのデフォルト名称（config('mail.from.name')） |
| 件名 | "You're Invited to Join Our {app_name}" |
| 形式 | HTML（Markdown） |

### 本文テンプレート

```
You have been invited to join {app_name}

To accept the invitation - click on the button below and create an account:

[Create Account] (署名付きURL)

If you did not expect to receive an invitation to this team, you may discard this email.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| app | アプリケーション名 | config('app.name') | Yes |
| acceptUrl | 招待承認用の署名付きURL | URL::signedRoute() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ユーザー管理画面の「ユーザー招待」アクション実行 | enable_user_invitation設定がtrue | 管理者がメールアドレスを入力して招待を送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| UserSettings.enable_user_invitationがfalse | ユーザー招待機能が無効化されている場合 |
| UserSettings.default_company_idが未設定 | デフォルト会社が設定されていない場合、招待は送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理者がユーザー招待アクション実行] --> B{デフォルト会社設定確認}
    B -->|未設定| C[エラー通知表示]
    B -->|設定済み| D[招待レコード作成]
    D --> E[UserInvitationMail送信]
    E --> F{送信結果}
    F -->|成功| G[成功通知表示]
    F -->|失敗| H[エラーログ記録]
    H --> I[失敗通知表示]
    G --> J[終了]
    I --> J
    C --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| user_invitations | 招待情報の管理 | 招待レコードを作成後、IDを署名付きURLに使用 |

### テーブル別参照項目詳細

#### user_invitations

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | 招待識別子（URLパラメータ） | 新規作成時に自動生成 |
| email | 招待先メールアドレス | ユーザー入力値 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| user_invitations | INSERT | 招待レコードの新規作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | email | 招待先メールアドレス | 招待フォームからの入力値 |
| INSERT | created_at | 招待作成日時 | 自動設定 |
| INSERT | updated_at | 招待更新日時 | 自動設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー等 | 例外をキャッチしてログに記録、ユーザーにエラー通知を表示 |
| 設定エラー | default_company_idが未設定 | エラー通知を表示し、招待処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Laravelキュー設定に依存 |
| リトライ間隔 | Laravelキュー設定に依存 |
| リトライ対象エラー | キュー処理時の一時的なエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（システム設定に依存） |
| 1日あたり上限 | 制限なし（システム設定に依存） |

### 配信時間帯

特に制限なし。管理者の操作に応じて即時送信される。

## セキュリティ考慮事項

- 招待URLは署名付きURL（signed route）を使用しており、改ざんを検知できる
- 招待リンクには有効期限が設定される（Laravel signed routeのデフォルト動作）
- メールアドレスの検証（バリデーション）は送信前に実施される
- 招待メールは特定のユーザーのみが送信可能（UserSettings.enable_user_invitationの権限制御）

## 備考

- 本機能はWebkul Securityプラグインの一部として実装されている
- 招待を受けたユーザーがアカウントを作成する際のルートは `security.invitation.accept`
- 多言語対応されており、件名や本文は言語ファイルから取得される
