# 通知設計書 11-メール認証通知

## 概要

本ドキュメントは、顧客ポータル登録時にユーザーのメールアドレスを確認するために送信されるメール認証通知の設計を記載する。

### 本通知の処理概要

本通知は、顧客ポータルへの新規登録時にユーザーのメールアドレスの真正性を確認するためのメール通知である。

**業務上の目的・背景**：顧客ポータルを利用するユーザーが正当なメールアドレスを所有していることを確認し、不正なアカウント作成を防止する。また、重要な通知や情報をユーザーに確実に届けられるようにするため、メールアドレスの検証が必要となる。

**通知の送信タイミング**：顧客ポータル登録画面（Register.php）でユーザーが登録フォームを送信し、アカウント作成が完了した直後に送信される。具体的には、`register()`メソッド内で`sendEmailVerificationNotification()`が呼び出されるタイミングである。

**通知の受信者**：新規登録したユーザー自身。登録時に入力されたメールアドレス宛に送信される。ユーザーモデルがMustVerifyEmailインターフェースを実装している場合のみ送信対象となる。

**通知内容の概要**：メールアドレス確認用のURLリンクを含むメール。ユーザーがリンクをクリックすることでメールアドレスの所有が確認される。

**期待されるアクション**：受信者はメール内の確認リンクをクリックし、メールアドレスの検証を完了する。検証完了後、顧客ポータルの全機能が利用可能となる。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | Filament標準設定に依存 |

### 送信先決定ロジック

新規登録時にフォームで入力されたメールアドレス宛に送信される。以下の条件をすべて満たす場合のみ送信：
1. ユーザーモデルがMustVerifyEmailインターフェースを実装している
2. ユーザーがまだメールアドレスを検証していない（hasVerifiedEmail() がfalse）
3. ユーザーモデルにnotify()メソッドが存在する

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | システム設定のデフォルトメールアドレス |
| 送信元名称 | システム設定のデフォルト名称 |
| 件名 | Filament標準のVerifyEmail通知に依存 |
| 形式 | HTML/テキスト |

### 本文テンプレート

```
Filament標準のVerifyEmail通知テンプレートを使用
- 確認用URLリンク
- 確認期限（設定による）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| url | メール確認用URL | Filament::getVerifyEmailUrl($user) | Yes |
| user | ユーザー情報 | 登録されたユーザーモデル | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 顧客ポータル登録フォーム送信 | MustVerifyEmail実装 & 未検証 | register()メソッド実行時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| MustVerifyEmail未実装 | ユーザーモデルがMustVerifyEmailを実装していない場合 |
| 検証済み | ユーザーが既にメールアドレスを検証済みの場合 |
| notify()メソッド不在 | ユーザーモデルにnotify()メソッドがない場合（例外発生） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[登録フォーム送信] --> B[ユーザー作成処理]
    B --> C[Registeredイベント発火]
    C --> D{MustVerifyEmail実装?}
    D -->|Yes| E{メール検証済み?}
    D -->|No| I[送信スキップ]
    E -->|Yes| I
    E -->|No| F{notify()メソッド存在?}
    F -->|No| J[例外発生]
    F -->|Yes| G[VerifyEmail通知作成]
    G --> H[確認URLセット]
    H --> K[メール送信]
    K --> L[ユーザーログイン]
    I --> L
    L --> M[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報取得 | Filamentの認証プロバイダから取得 |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| email | 送信先メールアドレス | 新規登録ユーザー |
| email_verified_at | 検証状態確認 | null = 未検証 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| users | UPDATE | メール検証完了時にemail_verified_atを更新（別処理） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| - | - | - | Filament標準機能のため、専用ログテーブルなし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| notify()メソッド不在 | ユーザーモデルにnotify()がない | Exception発生、ログ出力 |
| レート制限 | 短時間に2回以上登録試行 | TooManyRequestsException、警告通知表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Filament/Laravel標準設定に依存 |
| リトライ間隔 | 設定依存 |
| リトライ対象エラー | メール送信一時障害 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 2回（登録レート制限） |
| 1日あたり上限 | 設定依存 |

### 配信時間帯

特に制限なし（24時間送信可能）

## セキュリティ考慮事項

- 確認URLは署名付きURLを使用し、改ざんを防止
- URLには有効期限が設定される
- メールアドレスは個人情報として適切に取り扱う
- レート制限により、不正な大量登録を防止

## 備考

- Filament標準のVerifyEmail通知クラスを使用
- 言語ファイルは `website::filament/customer/pages/auth/register` を参照
- 確認URL生成は `Filament::getVerifyEmailUrl($user)` を使用
