# 通知設計書 12-操作成功通知

## 概要

本ドキュメントは、各種操作（作成、更新、削除など）の成功時に画面上に表示されるアプリ内通知の設計を記載する。

### 本通知の処理概要

本通知は、システム内での各種CRUD操作やその他のアクションが正常に完了した際に、ユーザーに即時フィードバックを提供するアプリ内通知である。

**業務上の目的・背景**：ユーザーが実行した操作の結果を即座に確認できるようにし、操作完了の安心感を提供する。また、次のアクションへの判断材料を提供することで、業務効率の向上を図る。Filament Notificationコンポーネントを使用した統一的なUI/UXを実現している。

**通知の送信タイミング**：各種リソースのCreate/Edit/Delete/Update処理が正常に完了した直後に表示される。具体的にはFilamentのCreateAction、EditAction、DeleteAction、RestoreAction等のsuccessNotificationとして設定されている。

**通知の受信者**：操作を実行したログインユーザー自身。画面上にトースト形式で通知が表示される。

**通知内容の概要**：操作の種類（作成、更新、削除など）と対象リソースに応じたタイトルと本文メッセージ。緑色のsuccess状態でハイライト表示される。

**期待されるアクション**：通知内容を確認し、必要に応じて次の操作に進む。通知は一定時間後に自動的に消える、またはユーザーが手動で閉じることができる。

## 通知種別

アプリ内通知（Filament Notification - トースト形式）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面即時表示） |
| 優先度 | 中 |
| リトライ | なし（UI通知のため） |

### 送信先決定ロジック

操作を実行した現在ログイン中のユーザーのブラウザ画面に直接表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | 画面右上（Filamentデフォルト） |
| 表示色 | 緑色（success） |
| 自動消去 | あり（数秒後） |
| 手動消去 | 可能 |

### 本文テンプレート

```
タイトル: {操作種別}完了メッセージ
本文: {対象リソース}が正常に{操作種別}されました

例1（作成成功）:
  タイトル: "Created"
  本文: "The product has been created successfully."

例2（更新成功）:
  タイトル: "Saved"
  本文: "The record has been updated successfully."

例3（削除成功）:
  タイトル: "Deleted"
  本文: "The record has been deleted successfully."
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | アプリ内通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | 通知タイトル | 言語ファイル（各リソース固有） | Yes |
| body | 通知本文 | 言語ファイル（各リソース固有） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | CreateAction完了 | 作成処理成功 | 新規レコード作成時 |
| 画面操作 | EditAction完了 | 更新処理成功 | 既存レコード編集時 |
| 画面操作 | DeleteAction完了 | 削除処理成功 | レコード削除時 |
| 画面操作 | RestoreAction完了 | 復元処理成功 | 論理削除レコード復元時 |
| 画面操作 | BulkAction完了 | 一括処理成功 | 複数レコード一括操作時 |
| 画面操作 | カスタムAction完了 | 処理成功 | その他のカスタム操作時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 処理失敗 | 操作が失敗した場合は操作失敗通知(No.13)が表示される |
| successNotification未設定 | アクションにsuccessNotificationが設定されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザー操作開始] --> B[アクション実行]
    B --> C{処理成功?}
    C -->|Yes| D[successNotification設定確認]
    C -->|No| E[失敗通知へ]
    D -->|設定あり| F[Notification::make]
    D -->|設定なし| G[Filamentデフォルト通知]
    F --> H[->success]
    H --> I[->title設定]
    I --> J[->body設定]
    J --> K[->send]
    G --> K
    K --> L[画面にトースト表示]
    L --> M[終了]
    E --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | UIのみの通知のためDB参照なし |

### テーブル別参照項目詳細

通知表示自体はデータベースを参照しない。操作対象のデータは各アクションで別途参照される。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | UIのみの通知のためDB更新なし |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| なし | - | - | アプリ内通知のため送信ログなし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 表示失敗 | JavaScriptエラー等 | ブラウザ開発者ツールでデバッグ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（操作回数に依存） |
| 1日あたり上限 | なし |

### 配信時間帯

特に制限なし（ユーザー操作時に即時表示）

## セキュリティ考慮事項

- XSS対策：タイトル・本文は適切にエスケープされる（Filament標準機能）
- 機密情報は通知に含めない（レコードIDや詳細データの表示は最小限）
- 他ユーザーへの通知漏洩リスクなし（操作者のブラウザのみに表示）

## 備考

- Filament Notificationコンポーネントを使用
- 言語ファイルは各プラグインの `resources/lang/{locale}/filament/resources/` 配下に配置
- success()メソッドで緑色のスタイルが適用される
- 複数通知は順次表示（スタック形式）
- 主な使用箇所：
  - accounts: 請求書、支払い、税金等の操作
  - employees: 従業員、部門等の操作
  - inventories: 在庫、倉庫、配送等の操作
  - products: 商品、属性等の操作
  - partners: 取引先、連絡先等の操作
  - time-off: 休暇申請、休暇タイプ等の操作
  - timesheets: 勤怠記録の操作
