# 通知設計書 13-操作失敗通知

## 概要

本ドキュメントは、各種操作（作成、更新、削除など）の失敗時に画面上に表示されるアプリ内通知の設計を記載する。

### 本通知の処理概要

本通知は、システム内での各種CRUD操作やその他のアクションが失敗した際に、ユーザーにエラー情報をフィードバックするアプリ内通知である。

**業務上の目的・背景**：ユーザーが実行した操作が失敗したことを明確に伝え、何が問題だったかを理解できるようにする。これにより、ユーザーは適切な対処（再試行、データ修正、管理者への連絡等）を取ることができる。

**通知の送信タイミング**：各種リソースのCreate/Edit/Delete/Update処理が失敗した時点、または例外がキャッチされた時点で表示される。QueryException、Validation Error、ビジネスロジックエラーなど、様々なエラー発生時に使用される。

**通知の受信者**：操作を実行したログインユーザー自身。画面上にトースト形式で通知が表示される。

**通知内容の概要**：エラーの種類と簡潔なエラーメッセージ。赤色のdanger状態でハイライト表示される。場合によっては詳細なエラーメッセージ（例外メッセージ等）も表示される。

**期待されるアクション**：エラー内容を確認し、問題を解決してから再試行する。解決できない場合は管理者に連絡する。

## 通知種別

アプリ内通知（Filament Notification - トースト形式）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面即時表示） |
| 優先度 | 高 |
| リトライ | なし（UI通知のため） |

### 送信先決定ロジック

操作を実行した現在ログイン中のユーザーのブラウザ画面に直接表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | 画面右上（Filamentデフォルト） |
| 表示色 | 赤色（danger） |
| 自動消去 | persistent()設定時は手動消去まで表示継続 |
| 手動消去 | 可能 |

### 本文テンプレート

```
タイトル: {エラー種別}メッセージ
本文: {詳細なエラーメッセージ}

例1（削除失敗 - 参照整合性エラー）:
  タイトル: "Deletion Failed"
  本文: "This record cannot be deleted because it is referenced by other records."

例2（プラグインインストール失敗）:
  タイトル: "Installation Failed"
  本文: "{例外メッセージ}"

例3（商品強制削除失敗）:
  タイトル: "Force Delete Failed"
  本文: "Product cannot be force deleted due to existing references."
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | アプリ内通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | 通知タイトル | 言語ファイル（各リソース固有） | Yes |
| body | エラー詳細メッセージ | 例外メッセージまたは言語ファイル | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Delete/ForceDelete失敗 | QueryException発生 | 参照整合性違反等 |
| 画面操作 | プラグインインストール失敗 | Throwable発生 | インストールコマンド失敗 |
| 画面操作 | プラグインアンインストール失敗 | Throwable発生 | アンインストールコマンド失敗 |
| 画面操作 | 在庫操作失敗 | バリデーションエラー | 数量不足等 |
| 画面操作 | バリアント生成失敗 | Exception発生 | 属性設定不整合等 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 処理成功 | 操作が成功した場合は操作成功通知(No.12)が表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザー操作開始] --> B[アクション実行]
    B --> C{処理成功?}
    C -->|Yes| D[成功通知へ]
    C -->|No| E[例外キャッチ]
    E --> F[Notification::make]
    F --> G[->danger]
    G --> H[->title設定]
    H --> I[->body設定]
    I --> J{永続表示必要?}
    J -->|Yes| K[->persistent]
    J -->|No| L[->send]
    K --> L
    L --> M[画面にトースト表示]
    M --> N[action->cancel または 終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | UIのみの通知のためDB参照なし |

### テーブル別参照項目詳細

通知表示自体はデータベースを参照しない。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | UIのみの通知のためDB更新なし |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| なし | - | - | アプリ内通知のため送信ログなし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| QueryException | DB参照整合性違反 | ユーザーに依存レコードの削除を案内 |
| Throwable | 各種実行時エラー | エラーメッセージを表示、ログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（エラー発生回数に依存） |
| 1日あたり上限 | なし |

### 配信時間帯

特に制限なし（エラー発生時に即時表示）

## セキュリティ考慮事項

- XSS対策：エラーメッセージは適切にエスケープされる
- 機密情報は通知に含めない（スタックトレース等は表示しない）
- 例外メッセージをそのまま表示する場合、機密情報漏洩に注意
- report()関数でエラーを適切にログ記録

## 備考

- Filament Notificationコンポーネントを使用
- danger()メソッドで赤色のスタイルが適用される
- persistent()メソッドで自動消去を無効化可能（重要なエラー向け）
- action->cancel()でアクションをキャンセルしてUI状態を維持
- 主な使用箇所：
  - products: ForceDeleteAction失敗時
  - plugin-manager: インストール/アンインストール失敗時
  - inventories: 削除失敗時（参照整合性違反）
