# 通知設計書 16-休暇割当関連通知

## 概要

本ドキュメントは、休暇割当の承認・却下・更新時に表示されるアプリ内通知の設計を記載する。

### 本通知の処理概要

本通知は、time-offプラグインにおける休暇割当（Allocation）のライフサイクル全体を通じて、各種操作完了時にユーザーへフィードバックを提供するアプリ内通知である。

**業務上の目的・背景**：従業員への休暇日数の割り当て管理において、割当の作成・編集・承認・却下の各処理状態をリアルタイムで伝達し、人事・労務管理業務の円滑な運用を支援する。管理者と従業員の双方が操作結果を即座に確認できる。

**通知の送信タイミング**：休暇割当の作成、編集、削除、承認、却下、確認待ちマーク、およびマイルストーン管理時に表示される。

**通知の受信者**：操作を実行したログインユーザー自身。画面上にトースト形式で通知が表示される。

**通知内容の概要**：操作種別（作成、更新、削除、承認、却下）と結果に応じたメッセージ。成功時は緑色で表示される。

**期待されるアクション**：通知内容を確認し、必要に応じて次の操作（承認フローの続行など）に進む。

## 通知種別

アプリ内通知（Filament Notification - トースト形式）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面即時表示） |
| 優先度 | 中 |
| リトライ | なし（UI通知のため） |

### 送信先決定ロジック

操作を実行した現在ログイン中のユーザーのブラウザ画面に直接表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | 画面右上（Filamentデフォルト） |
| 表示色 | 緑色（success） |
| 自動消去 | あり（数秒後） |
| 手動消去 | 可能 |

### 本文テンプレート

```
【休暇割当作成成功】
タイトル: "Allocation Created"
本文: "Allocation has been created successfully."

【休暇割当更新成功】
タイトル: "Allocation Updated"
本文: "Allocation has been updated successfully."

【休暇割当削除成功】
タイトル: "Allocation Deleted"
本文: "Allocation has been deleted successfully."

【休暇割当承認成功】
タイトル: "Allocation Approved"
本文: "Allocation has been approved successfully."

【休暇割当却下成功】
タイトル: "Allocation Refused"
本文: "Allocation has been refused successfully."

【確認待ちマーク成功】
タイトル: "Marked as Ready to Confirm"
本文: "Allocation has been marked as ready to confirm."

【マイルストーン作成成功】
タイトル: "Milestone Created"
本文: "Accrual milestone has been created successfully."

【マイルストーン編集成功】
タイトル: "Milestone Updated"
本文: "Accrual milestone has been updated successfully."

【マイルストーン削除成功】
タイトル: "Milestone Deleted"
本文: "Accrual milestone has been deleted successfully."
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | アプリ内通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | 通知タイトル | 言語ファイル | Yes |
| body | 通知本文 | 言語ファイル | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | CreateAllocation成功 | 作成処理完了 | 休暇割当新規作成 |
| 画面操作 | EditAllocation成功 | 更新処理完了 | 休暇割当編集 |
| 画面操作 | DeleteAllocation成功 | 削除処理完了 | 休暇割当削除 |
| 画面操作 | Approveボタン押下 | 承認処理完了 | state -> VALIDATE_TWO |
| 画面操作 | Refuseボタン押下 | 却下処理完了 | state -> REFUSE |
| 画面操作 | Mark as Ready to Confirmボタン押下 | マーク処理完了 | state -> CONFIRM |
| 画面操作 | マイルストーン作成成功 | 作成処理完了 | LeaveAccrualPlan trait |
| 画面操作 | マイルストーン編集成功 | 更新処理完了 | LeaveAccrualPlan trait |
| 画面操作 | マイルストーン削除成功 | 削除処理完了 | LeaveAccrualPlan trait |
| 画面操作 | マイルストーン一括削除成功 | 一括削除処理完了 | LeaveAccrualPlan trait |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 処理失敗 | 操作が失敗した場合は操作失敗通知が表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[休暇割当操作開始] --> B{操作種別}
    B -->|作成| C[CreateAllocation実行]
    B -->|編集| D[EditAllocation実行]
    B -->|削除| E[DeleteAllocation実行]
    B -->|承認| F[Approve Action実行]
    B -->|却下| G[Refuse Action実行]
    B -->|確認待ち| H[Mark as Ready Action実行]
    C --> I{処理成功?}
    D --> I
    E --> I
    F --> J[state更新: VALIDATE_TWO]
    G --> K[state更新: REFUSE]
    H --> L[state更新: CONFIRM]
    J --> M[refreshFormData]
    K --> M
    L --> M
    I -->|Yes| N[成功通知表示]
    I -->|No| O[失敗通知表示]
    M --> N
    N --> P[終了]
    O --> P
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| time_off_leave_allocations | 割当データ取得 | CRUD対象 |
| time_off_leave_types | 休暇タイプ情報 | 割当対象の休暇タイプ |
| employees_employees | 従業員情報 | 割当対象の従業員 |
| time_off_leave_accrual_levels | マイルストーン情報 | 発生計画のマイルストーン |

### テーブル別参照項目詳細

#### time_off_leave_allocations

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | レコード特定 | 操作対象ID |
| state | 状態確認・更新 | 現在の承認状態 |
| employee_id | 従業員特定 | 割当対象 |
| leave_type_id | 休暇タイプ特定 | 割当対象 |
| number_of_days | 割当日数 | 表示・計算用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| time_off_leave_allocations | INSERT/UPDATE/DELETE | 割当データ操作 |
| time_off_leave_accrual_levels | INSERT/UPDATE/DELETE | マイルストーン操作 |

#### state更新パターン

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| Approve | state | VALIDATE_TWO | 承認完了状態 |
| Refuse | state | REFUSE | 却下状態 |
| Mark as Ready | state | CONFIRM | 確認待ち状態 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| バリデーションエラー | 必須項目未入力等 | Filament標準のバリデーションエラー表示 |
| DB制約違反 | 参照整合性エラー等 | 失敗通知表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

特に制限なし（操作時に即時表示）

## セキュリティ考慮事項

- 休暇割当情報は個人情報として適切に取り扱う
- 承認・却下権限は適切なロールに制限
- 他従業員の割当情報は権限に応じて表示制御

## 備考

- time-offプラグインで使用
- Management（管理者向け）とMyTime（従業員向け）で別々のリソース
- LeaveAccrualPlan traitでマイルストーン管理の通知を共通化
- State Enumで承認ワークフローを管理
  - DRAFT: 下書き
  - CONFIRM: 確認待ち
  - REFUSE: 却下
  - VALIDATE_TWO: 承認（第2承認）
- 言語ファイルは `time-off::filament/clusters/management/resources/allocation/` 配下に配置
- 関連ページ:
  - CreateAllocation.php
  - EditAllocation.php
  - ViewAllocation.php
  - LeaveAccrualPlan.php (trait)
