# 通知設計書 17-勤怠記録通知

## 概要

本ドキュメントは、タイムシート記録の作成・更新時に表示されるアプリ内通知の設計を記載する。

### 本通知の処理概要

本通知は、timesheetsプラグインにおける勤怠（タイムシート）記録のCRUD操作完了時にユーザーへフィードバックを提供するアプリ内通知である。

**業務上の目的・背景**：従業員の勤怠管理において、タイムシート記録の作成・編集・削除の各処理状態をリアルタイムで伝達し、正確な労働時間管理を支援する。従業員と管理者の双方が操作結果を即座に確認できる。

**通知の送信タイミング**：タイムシート記録の作成、編集、削除、および一括削除時に表示される。

**通知の受信者**：操作を実行したログインユーザー自身。画面上にトースト形式で通知が表示される。

**通知内容の概要**：操作種別（作成、更新、削除）と結果に応じたメッセージ。成功時は緑色で表示される。

**期待されるアクション**：通知内容を確認し、必要に応じて次の操作（別の日付の記録入力など）に進む。

## 通知種別

アプリ内通知（Filament Notification - トースト形式）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面即時表示） |
| 優先度 | 中 |
| リトライ | なし（UI通知のため） |

### 送信先決定ロジック

操作を実行した現在ログイン中のユーザーのブラウザ画面に直接表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | 画面右上（Filamentデフォルト） |
| 表示色 | 緑色（success） |
| 自動消去 | あり（数秒後） |
| 手動消去 | 可能 |

### 本文テンプレート

```
【タイムシート作成成功】
タイトル: "Timesheet Created"
本文: "Timesheet entry has been created successfully."

【タイムシート更新成功】
タイトル: "Timesheet Updated"
本文: "Timesheet entry has been updated successfully."

【タイムシート削除成功】
タイトル: "Timesheet Deleted"
本文: "Timesheet entry has been deleted successfully."

【タイムシート一括削除成功】
タイトル: "Timesheets Deleted"
本文: "Selected timesheet entries have been deleted successfully."
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | アプリ内通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | 通知タイトル | 言語ファイル | Yes |
| body | 通知本文 | 言語ファイル | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ManageTimesheets Create成功 | 作成処理完了 | タイムシート新規作成 |
| 画面操作 | TimesheetResource Edit成功 | 更新処理完了 | タイムシート編集 |
| 画面操作 | TimesheetResource Delete成功 | 削除処理完了 | タイムシート削除 |
| 画面操作 | TimesheetResource BulkDelete成功 | 一括削除処理完了 | 複数タイムシート削除 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 処理失敗 | 操作が失敗した場合は操作失敗通知が表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[タイムシート操作開始] --> B{操作種別}
    B -->|作成| C[CreateAction実行]
    B -->|編集| D[EditAction実行]
    B -->|削除| E[DeleteAction実行]
    B -->|一括削除| F[DeleteBulkAction実行]
    C --> G[mutateDataUsing: creator_id設定]
    G --> H[レコード保存]
    D --> I[レコード更新]
    E --> J[レコード削除]
    F --> K[複数レコード削除]
    H --> L{処理成功?}
    I --> L
    J --> L
    K --> L
    L -->|Yes| M[successNotification表示]
    L -->|No| N[失敗通知表示]
    M --> O[終了]
    N --> O
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| timesheets_timesheets | タイムシートデータ取得 | CRUD対象 |
| employees_employees | 従業員情報 | 記録者情報 |
| projects | プロジェクト情報 | プロジェクト別集計 |
| tasks | タスク情報 | タスク別集計 |

### テーブル別参照項目詳細

#### timesheets_timesheets

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | レコード特定 | 操作対象ID |
| employee_id | 従業員特定 | 記録者 |
| date | 日付 | 記録日 |
| unit_amount | 時間数 | 労働時間 |
| project_id | プロジェクト | 作業対象 |
| task_id | タスク | 作業対象 |
| name | 説明 | 作業内容 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| timesheets_timesheets | INSERT/UPDATE/DELETE | タイムシートデータ操作 |

#### 作成時のデータ設定

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | creator_id | Auth::id() | mutateDataUsingで設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| バリデーションエラー | 必須項目未入力等 | Filament標準のバリデーションエラー表示 |
| DB制約違反 | 参照整合性エラー等 | 失敗通知表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

特に制限なし（操作時に即時表示）

## セキュリティ考慮事項

- 勤怠記録は個人情報として適切に取り扱う
- 他従業員の記録は権限に応じて表示制御
- 記録の改ざん防止のため監査ログを検討

## 備考

- timesheetsプラグインで使用
- TimesheetResourceでテーブル形式の一覧表示
- ManageTimesheetsページで一覧管理
- mutateDataUsingでcreator_idを自動設定
- 言語ファイルは以下に配置:
  - `timesheets::filament/resources/timesheet.table.actions`
  - `timesheets::filament/resources/timesheet/manage-timesheets.header-actions`
- 関連ファイル:
  - TimesheetResource.php
  - ManageTimesheets.php
