# 通知設計書 18-プラグイン操作通知

## 概要

本ドキュメントは、プラグインの有効化・無効化時に表示されるアプリ内通知の設計を記載する。

### 本通知の処理概要

本通知は、plugin-managerプラグインにおけるプラグインのインストール・アンインストール・同期操作時にユーザーへフィードバックを提供するアプリ内通知である。

**業務上の目的・背景**：システム管理者がプラグインの有効化・無効化を行う際に、操作結果を明確に伝達し、システムの機能拡張や調整を円滑に行えるようにする。成功時・失敗時の両方で通知を表示し、問題発生時には詳細なエラーメッセージを提供する。

**通知の送信タイミング**：プラグインのインストール、アンインストール、同期処理の完了時または失敗時に表示される。

**通知の受信者**：操作を実行したログインユーザー（通常はシステム管理者）。画面上にトースト形式で通知が表示される。

**通知内容の概要**：操作種別（インストール、アンインストール、同期）と結果（成功、失敗）に応じたメッセージ。成功時は緑色、失敗時は赤色で表示される。

**期待されるアクション**：成功通知の場合は確認のみ。失敗通知の場合は、エラー内容を確認し、問題を解決してから再試行する。

## 通知種別

アプリ内通知（Filament Notification - トースト形式）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面即時表示） |
| 優先度 | 高 |
| リトライ | なし（UI通知のため） |

### 送信先決定ロジック

操作を実行した現在ログイン中のユーザーのブラウザ画面に直接表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | 画面右上（Filamentデフォルト） |
| 表示色 | 成功：緑色（success）、失敗：赤色（danger） |
| 自動消去 | 成功：あり（数秒後）、失敗：なし（persistent） |
| 手動消去 | 可能 |

### 本文テンプレート

```
【プラグインインストール成功】
タイトル: "Plugin Installed"
本文: "{プラグイン名} has been installed successfully."

【プラグインインストール失敗】
タイトル: "Installation Failed"
本文: "{例外メッセージ}"

【プラグインアンインストール成功】
タイトル: "Plugin Uninstalled"
本文: "{プラグイン名} has been uninstalled successfully."

【プラグインアンインストール失敗】
タイトル: "Uninstallation Failed"
本文: "{エラーメッセージ}"

【プラグイン同期成功】
タイトル: "Plugins Synced Successfully"
本文: "Found and synced {件数} new plugin(s)."

【プラグイン同期失敗】
タイトル: "Sync Failed"
本文: "{例外メッセージ}"
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | アプリ内通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | 通知タイトル | 言語ファイル | Yes |
| body | 通知本文 | 言語ファイル / 例外メッセージ | Yes |
| name | プラグイン名 | $record->name | Yes（成功時） |
| count | 同期件数 | $synced変数 | Yes（同期成功時） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Installアクション成功 | インストール処理完了 | プラグイン有効化 |
| 画面操作 | Installアクション失敗 | Throwable発生 | インストールエラー |
| 画面操作 | Uninstallアクション成功 | アンインストール処理完了 | プラグイン無効化 |
| 画面操作 | Uninstallアクション失敗 | エラー発生 | アンインストールエラー |
| 画面操作 | Syncアクション成功 | 同期処理完了 | プラグイン一覧同期 |
| 画面操作 | Syncアクション失敗 | Throwable発生 | 同期エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 処理完了時は必ず通知を表示 |

## 処理フロー

### 送信フロー（インストール）

```mermaid
flowchart TD
    A[Installアクション実行] --> B[try-catchブロック開始]
    B --> C[DBトランザクション開始]
    C --> D[artisanコマンド構築]
    D --> E[exec実行: plugin:install]
    E --> F{処理成功?}
    F -->|Yes| G[is_installed, is_active = true更新]
    G --> H[成功通知表示]
    F -->|No| I[Throwableキャッチ]
    I --> J[失敗通知表示（persistent）]
    H --> K[終了]
    J --> K
```

### 送信フロー（アンインストール）

```mermaid
flowchart TD
    A[Uninstallアクション実行] --> B[依存プラグインチェック]
    B --> C{依存あり?}
    C -->|Yes| D[依存プラグイン先にアンインストール]
    C -->|No| E[try-catchブロック開始]
    D --> E
    E --> F[exec実行: plugin:uninstall]
    F --> G{処理成功?}
    G -->|Yes| H[is_installed, is_active = false更新]
    H --> I[成功通知表示]
    G -->|No| J[エラーを配列に追加]
    J --> K{エラーあり?}
    I --> L[終了]
    K -->|Yes| M[失敗通知表示（persistent）]
    K -->|No| I
    M --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| plugins | プラグイン情報取得 | インストール状態確認 |

### テーブル別参照項目詳細

#### plugins

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | レコード特定 | 操作対象ID |
| name | プラグイン名 | 通知メッセージに使用 |
| is_installed | インストール状態 | 状態確認 |
| is_active | 有効状態 | 状態確認 |
| path | プラグインパス | コマンド実行用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| plugins | UPDATE/INSERT | プラグイン状態更新・新規登録 |

#### インストール時の更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | is_installed | true | インストール完了 |
| UPDATE | is_active | true | 有効化 |

#### アンインストール時の更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | is_installed | false | アンインストール完了 |
| UPDATE | is_active | false | 無効化 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Throwable | インストールコマンド失敗 | エラー通知表示、report()でログ |
| 依存エラー | 依存プラグインが必要 | 先に依存をアンインストール |
| execエラー | コマンド実行失敗 | エラーメッセージ表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（ユーザーが手動で再試行） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

特に制限なし（操作時に即時表示）

## セキュリティ考慮事項

- プラグイン管理は管理者権限が必要
- execコマンドの実行は信頼されたパスのみ
- エラーメッセージにシステム情報が含まれる可能性があるため注意
- report()関数で詳細ログを記録

## 備考

- plugin-managerプラグインで使用
- artisanコマンド `plugin:install` と `plugin:uninstall` を使用
- 失敗時は `->persistent()` で通知が自動消去されない
- 依存プラグインの解決は再帰的に行われる
- 言語ファイルは `plugin-manager::filament/resources/plugin.notifications` に配置
- 同期処理ではプラグインディレクトリをスキャンして新規プラグインを検出
- 関連ファイル:
  - PluginResource.php
  - ListPlugins.php
