# 通知設計書 19-商品バリアント生成通知

## 概要

本ドキュメントは、商品バリアント生成処理の結果通知を設計するドキュメントである。

### 本通知の処理概要

本通知は、productsプラグインにおける商品バリアント（属性の組み合わせに基づく派生商品）の自動生成処理完了時にユーザーへフィードバックを提供するアプリ内通知である。

**業務上の目的・背景**：商品にサイズや色などの属性を設定した後、その組み合わせから自動的にバリアント商品を生成する機能において、処理結果を明確に伝達する。成功時・失敗時の両方で通知を表示し、特に失敗時には問題の把握を支援する。

**通知の送信タイミング**：商品の属性管理画面でGenerateVariantsアクションを実行し、バリアント生成処理が完了または失敗した時点で表示される。

**通知の受信者**：操作を実行したログインユーザー。画面上にトースト形式で通知が表示される。

**通知内容の概要**：バリアント生成の成功または失敗のメッセージ。成功時は緑色、失敗時は赤色で表示される。

**期待されるアクション**：成功通知の場合は生成されたバリアント一覧を確認。失敗通知の場合は、属性設定を見直してから再試行する。

## 通知種別

アプリ内通知（Filament Notification - トースト形式）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面即時表示） |
| 優先度 | 中 |
| リトライ | なし（UI通知のため） |

### 送信先決定ロジック

操作を実行した現在ログイン中のユーザーのブラウザ画面に直接表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | 画面右上（Filamentデフォルト） |
| 表示色 | 成功：緑色（success）、失敗：赤色（danger） |
| 自動消去 | あり（数秒後） |
| 手動消去 | 可能 |

### 本文テンプレート

```
【バリアント生成成功】
タイトル: "Variants Generated"
本文: "Product variants have been generated successfully."

【バリアント生成失敗】
タイトル: "Variant Generation Failed"
本文: "Failed to generate product variants. Please check your attribute configuration."
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | アプリ内通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | 通知タイトル | 言語ファイル | Yes |
| body | 通知本文 | 言語ファイル | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | GenerateVariantsAction成功 | バリアント生成完了 | 全バリアント生成成功 |
| 画面操作 | GenerateVariantsAction失敗 | Exception発生 | 生成処理エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 属性なし | 商品に属性が設定されていない場合はアクション自体が非表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GenerateVariantsAction実行] --> B[try-catchブロック開始]
    B --> C[商品の属性情報取得]
    C --> D{属性数}
    D -->|1つ| E[handleSingleAttributeVariants]
    D -->|複数| F[handleMultipleAttributeVariants]
    E --> G[既存バリアントチェック]
    F --> G
    G --> H{既存バリアント?}
    H -->|あり| I[updateVariant]
    H -->|なし| J[createVariant]
    I --> K[ProductCombination作成/更新]
    J --> K
    K --> L[不要バリアント削除]
    L --> M{処理成功?}
    M -->|Yes| N[is_configurable = true設定]
    N --> O[成功通知表示]
    M -->|No| P[Exception発生]
    P --> Q[失敗通知表示]
    O --> R[終了]
    Q --> R
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| products_products | 親商品・バリアント情報 | 生成元・生成先 |
| products_product_attributes | 商品属性関連 | 属性取得 |
| products_product_attribute_values | 属性値 | 組み合わせ生成用 |
| products_product_combinations | バリアント組み合わせ | 既存確認・新規作成 |
| products_attributes | 属性マスタ | 属性情報 |
| products_attribute_options | 属性オプション | オプション値 |

### テーブル別参照項目詳細

#### products_products

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | 親商品特定 | 操作対象 |
| name | バリアント名生成 | 親商品名 + 属性値 |
| price | バリアント価格計算 | 親商品価格 + extra_price |
| parent_id | バリアント判定 | null = 親商品 |

#### products_product_attribute_values

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | 組み合わせ特定 | 属性値ID |
| extra_price | 価格加算 | バリアント価格計算 |
| attribute_option_id | オプション名取得 | 表示用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| products_products | INSERT/UPDATE/DELETE | バリアント商品CRUD |
| products_product_combinations | INSERT/DELETE | 組み合わせ情報管理 |

#### バリアント作成時

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | name | 親商品名 + 属性値名 | 例: "Tシャツ - 赤 / M" |
| INSERT | price | 親価格 + extra_price合計 | 追加価格反映 |
| INSERT | parent_id | 親商品ID | 親子関係 |
| INSERT | creator_id | Auth::id() | 作成者 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Exception | 属性設定不整合等 | 失敗通知表示、属性設定見直し |
| DB制約違反 | 重複データ等 | 失敗通知表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（ユーザーが手動で再試行） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

特に制限なし（操作時に即時表示）

## セキュリティ考慮事項

- 商品情報の編集権限が必要
- 大量バリアント生成時のサーバー負荷を考慮
- バリアント削除時のデータ整合性確認

## 備考

- productsプラグインで使用
- GenerateVariantsActionクラスで実装
- ManageAttributesページから呼び出し
- 属性が1つの場合と複数の場合で処理を分岐
- 既存バリアントは再利用（更新）、不要なバリアントは削除
- is_configurable フラグで設定可能商品を識別
- バリアント名は「親商品名 - 属性値1 / 属性値2 / ...」形式
- 言語ファイルは `products::filament/resources/product/actions/generate-variants` に配置
- 関連ファイル:
  - GenerateVariantsAction.php
  - ManageAttributes.php
  - ManageVariants.php
