# 通知設計書 2-購買発注メール

## 概要

本ドキュメントは、AureusERPシステムにおける購買発注メール（VendorPurchaseOrderMail）通知機能の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、購買担当者がベンダー（仕入先）に対して見積依頼書（RFQ: Request for Quotation）または購買発注書（PO: Purchase Order）を送信する際に使用されるメール通知である。

**業務上の目的・背景**：購買業務において、仕入先への見積依頼や発注は迅速かつ正確に行う必要がある。本通知機能により、システム内で作成したRFQやPOをPDF形式で添付し、仕入先に直接メール送信できる。これにより、FAXや郵送といった従来の方法に比べて、発注リードタイムの短縮と業務効率化を実現する。

**通知の送信タイミング**：購買発注画面において、担当者が「RFQ送信」または「発注書送信」アクションを実行し、送信先ベンダー・件名・メッセージを入力して送信を確定した時点で送信される。

**通知の受信者**：送信フォームで選択されたベンダー（取引先）のメールアドレス。複数のベンダーを選択した場合、各ベンダーに個別に送信される。

**通知内容の概要**：ユーザーが入力したカスタムメッセージ本文と、見積依頼書または購買発注書のPDFファイルが添付される。

**期待されるアクション**：仕入先は添付されたPDFを確認し、見積回答または受注確認を行うことが期待される。

## 通知種別

メール通知（HTML形式、Laravel Mailableコンポーネント使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Queueable trait使用） |
| 優先度 | 中 |
| リトライ | Laravelキューのデフォルト設定に依存 |

### 送信先決定ロジック

1. 送信フォームで選択されたベンダーIDリストを取得
2. 各ベンダーIDに対応するPartnerレコードを取得
3. Partnerレコードにメールアドレスが設定されている場合のみ送信
4. メールアドレスがないベンダーはスキップされる

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | システムのデフォルトメールアドレス（config('mail.from.address')） |
| 送信元名称 | システムのデフォルト名称（config('mail.from.name')） |
| 件名 | ユーザー入力（$data['subject']） |
| 形式 | HTML（Markdown） |

### 本文テンプレート

```
{ユーザーが入力したメッセージ}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| Request for Quotation-{注文番号}.pdf | PDF | RFQ送信時 | 見積依頼書PDF |
| Purchase Order-{注文番号}.pdf | PDF | PO送信時 | 購買発注書PDF |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | メール本文 | ユーザー入力（$data['message']） | Yes |
| subject | メール件名 | ユーザー入力（$data['subject']） | Yes |
| pdfPath | 添付PDF保存パス | generateRFQPdf/generatePurchaseOrderPdf | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | RFQ送信アクション実行 | ベンダーにメールアドレスが設定されている | 見積依頼書の送信 |
| 画面操作 | 購買発注書送信アクション実行 | ベンダーにメールアドレスが設定されている | 発注書の送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ベンダーのemail項目がnullまたは空 | Partner::find($vendorId)?->emailがfalsy値の場合、スキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[担当者がRFQ/PO送信アクション実行] --> B[PDFファイル生成]
    B --> C[ベンダーリストをループ]
    C --> D{ベンダーにメールアドレスあり?}
    D -->|なし| E[スキップして次のベンダーへ]
    D -->|あり| F[VendorPurchaseOrderMail送信]
    F --> G[次のベンダーへ]
    E --> G
    G --> H{全ベンダー処理完了?}
    H -->|No| C
    H -->|Yes| I[注文ステータス更新]
    I --> J[メッセージ履歴追加]
    J --> K[PDF添付追加]
    K --> L[一時PDFファイル削除]
    L --> M[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| partners | ベンダー情報（メールアドレス）取得 | Partner::find($vendorId) |
| purchases_orders | 発注情報取得 | PDF生成用データ |
| purchases_order_lines | 発注明細取得 | PDF生成用データ |

### テーブル別参照項目詳細

#### partners

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ベンダー識別子 | フォームで選択されたID |
| email | 送信先メールアドレス | - |

#### purchases_orders

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | 注文番号（PDFファイル名に使用） | 対象レコード |
| state | 注文ステータス | 更新対象 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| purchases_orders | UPDATE | ステータスをSENTに更新（RFQ送信時のみ） |
| chatter_messages | INSERT | メッセージ履歴の追加 |
| chatter_attachments | INSERT | PDF添付ファイルの追加 |

#### 更新詳細

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | state | 'sent' | RFQ送信時のみ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー等 | Laravelキューの標準リトライ機構に依存 |
| PDF生成失敗 | テンプレートエラー等 | 例外がスローされ、処理が中断される |
| ベンダーメールなし | Partner.emailがnull | スキップして次のベンダーを処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Laravelキュー設定に依存 |
| リトライ間隔 | Laravelキュー設定に依存 |
| リトライ対象エラー | キュー処理時の一時的なエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（システム設定に依存） |
| 1日あたり上限 | 制限なし（システム設定に依存） |

### 配信時間帯

特に制限なし。担当者の操作に応じて即時送信される。

## セキュリティ考慮事項

- PDFファイルはpublicストレージに一時保存されるため、送信完了後に削除される
- 発注金額等の機密情報がPDFに含まれるため、メール送信はTLS暗号化が推奨される
- ベンダーの選択は画面上で行われ、任意のメールアドレスへの送信は防止されている

## 備考

- 本機能はWebkul Purchasesプラグインの一部として実装されている
- PDF生成にはbarryvdh/laravel-dompdfパッケージを使用
- RFQ送信後、注文ステータスは自動的に「SENT」に更新される
- 送信されたメッセージとPDFはChatter機能を通じて履歴として保存される
