# 通知設計書 3-販売見積メール

## 概要

本ドキュメントは、AureusERPシステムにおける販売見積メール（SaleOrderQuotation）通知機能の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、営業担当者が顧客に対して販売見積書または注文書を送信する際に使用されるメール通知である。

**業務上の目的・背景**：販売業務において、顧客への見積提示は迅速かつプロフェッショナルに行う必要がある。本通知機能により、システム内で作成した見積書や注文書をPDF形式で添付し、顧客に直接メール送信できる。これにより、営業プロセスの効率化と顧客対応の迅速化を実現する。

**通知の送信タイミング**：販売注文画面において、担当者が「メール送信」アクションを実行し、送信先顧客・件名・説明を入力して送信を確定した時点で送信される。

**通知の受信者**：送信フォームで選択された取引先（Partner）のメールアドレス。複数の取引先を選択した場合、各取引先に個別に送信される。

**通知内容の概要**：ユーザーが入力した説明文、注文番号、会社情報、および見積書/注文書のPDFファイルが添付される。

**期待されるアクション**：顧客は添付されたPDFを確認し、見積内容を検討後、注文確定または交渉を行うことが期待される。

## 通知種別

メール通知（HTML形式、Laravel Mailableコンポーネント使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Queueable trait使用） |
| 優先度 | 中 |
| リトライ | Laravelキューのデフォルト設定に依存 |

### 送信先決定ロジック

1. 送信フォームで選択された取引先IDリストを取得
2. 各取引先IDに対応するPartnerレコードを取得
3. Partnerレコードにメールアドレスが設定されている場合のみ送信
4. メールアドレスがない取引先は失敗リストに追加される

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | payload['from']['address']（送信者設定） |
| 送信元名称 | payload['from']['name']（送信者名） |
| 件名 | ユーザー入力（$data['subject']） |
| 形式 | HTML（Bladeビュー） |

### 本文テンプレート

```html
<div class="breadcrumb">
    <p>{注文番号}</p>
</div>

<div class="notification">
    {ユーザーが入力した説明文}
</div>

<div class="company-info">
    <div class="company-name">{会社名}</div>
    <p class="company-details">
        {電話番号} | {メールアドレス} | {ウェブサイト}
    </p>
</div>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| {指定ファイル名} | PDF等 | ファイルパス指定時 | 見積書/注文書PDF |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| payload.record_name | 注文番号 | $record->name | Yes |
| payload.model_name | モデル名（ステータスラベル） | $record->state->getLabel() | Yes |
| payload.subject | メール件名 | ユーザー入力 | Yes |
| payload.description | 説明文 | ユーザー入力 | Yes |
| payload.to.address | 送信先メールアドレス | $partner->email | Yes |
| payload.to.name | 送信先名 | $partner->name | Yes |
| payload.from.company | 送信元会社情報 | Auth::user()->defaultCompany | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 販売注文画面のメール送信アクション実行 | 取引先にメールアドレスが設定されている | 見積書/注文書の送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 取引先のemail項目が空 | Partner.emailが空の場合、失敗リストに「No email address」として記録 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[担当者がメール送信アクション実行] --> B[取引先リストをループ]
    B --> C{取引先にメールアドレスあり?}
    C -->|なし| D[失敗リストに追加]
    C -->|あり| E[SaleOrderQuotation送信]
    E --> F{送信成功?}
    F -->|成功| G[成功リストに追加]
    F -->|失敗| H[失敗リストにエラー追加]
    D --> I[次の取引先へ]
    G --> I
    H --> I
    I --> J{全取引先処理完了?}
    J -->|No| B
    J -->|Yes| K{成功あり かつ ステータスがDRAFT?}
    K -->|Yes| L[ステータスをSENTに更新]
    K -->|No| M[終了]
    L --> N[メッセージ履歴追加]
    N --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| partners | 取引先情報（メールアドレス、名前）取得 | Partner::whereIn |
| sales_orders | 注文情報取得 | 注文番号、ステータス |
| users | 送信者の会社情報取得 | Auth::user()->defaultCompany |

### テーブル別参照項目詳細

#### partners

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | 取引先識別子 | フォームで選択されたID |
| email | 送信先メールアドレス | - |
| name | 送信先名 | - |

#### sales_orders

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | 注文番号 | 対象レコード |
| state | 注文ステータス | 更新判定用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sales_orders | UPDATE | ステータスをSENTに更新（DRAFTからの送信時） |
| chatter_messages | INSERT | メッセージ履歴の追加 |

#### 更新詳細

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | state | 'sent' | ステータスがDRAFTの場合のみ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー等 | 例外をキャッチし、失敗リストにエラーメッセージを追加 |
| メールアドレスなし | Partner.emailが空 | 失敗リストに「No email address」を追加 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Laravelキュー設定に依存 |
| リトライ間隔 | Laravelキュー設定に依存 |
| リトライ対象エラー | キュー処理時の一時的なエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（システム設定に依存） |
| 1日あたり上限 | 制限なし（システム設定に依存） |

### 配信時間帯

特に制限なし。担当者の操作に応じて即時送信される。

## セキュリティ考慮事項

- 添付ファイルはpublicストレージから取得される
- 送信元アドレスと名称は動的に設定可能なため、なりすまし防止の設定が必要
- 会社情報（電話、メール、ウェブサイト）がメール本文に含まれる
- 見積金額等の機密情報がPDFに含まれる可能性があるため、TLS暗号化が推奨される

## 備考

- 本機能はWebkul Salesプラグインの一部として実装されている
- EmailServiceを通じてメール送信が行われる
- 送信結果（成功・失敗）は配列で返却され、呼び出し元で処理される
- 送信成功時、メール内容がChatter機能を通じて履歴として保存される
- ステータスがDRAFTの場合のみ、送信後にSENTへ自動更新される
