# 通知設計書 4-販売見積キャンセルメール

## 概要

本ドキュメントは、AureusERPシステムにおける販売見積キャンセルメール（SaleOrderCancelQuotation）通知機能の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、販売見積（Quotation）をキャンセルする際に、関連する顧客に対してキャンセルを通知するメールである。

**業務上の目的・背景**：販売業務において、見積のキャンセルは様々な理由で発生する。顧客との信頼関係を維持するためには、キャンセル時に適切な通知を行うことが重要である。本通知機能により、キャンセル理由や代替提案を含むメッセージを顧客に送信し、プロフェッショナルな対応を実現する。

**通知の送信タイミング**：販売注文画面においてキャンセルアクションを実行し、メール送信オプションを選択した場合に送信される。キャンセル処理とメール送信は連動しており、メール送信を希望する場合のみ通知が送られる。

**通知の受信者**：送信フォームで選択された取引先（Partner）のメールアドレス。複数の取引先を選択した場合、各取引先に個別に送信される。

**通知内容の概要**：ユーザーが入力した説明文（キャンセル理由等）と会社情報が含まれる。

**期待されるアクション**：顧客はキャンセル通知を確認し、必要に応じて代替注文の検討や問い合わせを行うことが期待される。

## 通知種別

メール通知（HTML形式、Laravel Mailableコンポーネント使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Queueable trait使用） |
| 優先度 | 中 |
| リトライ | Laravelキューのデフォルト設定に依存 |

### 送信先決定ロジック

1. キャンセル送信フォームで選択された取引先IDリストを取得
2. 各取引先IDに対応するPartnerレコードを取得
3. 各取引先にメール送信を実行

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | payload['from']['address']（送信者設定） |
| 送信元名称 | payload['from']['name']（送信者名） |
| 件名 | ユーザー入力（$data['subject']） |
| 形式 | HTML（Bladeビュー） |

### 本文テンプレート

```html
<div class="notification">
    {ユーザーが入力した説明文（キャンセル理由等）}
</div>

<div class="company-info">
    <div class="company-name">{会社名}</div>
    <p class="company-details">
        {電話番号} | {メールアドレス} | {ウェブサイト}
    </p>
</div>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルは通常不要 |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| payload.record_name | 注文番号 | $record->name | Yes |
| payload.model_name | モデル名 | 'Quotation' | Yes |
| payload.subject | メール件名 | ユーザー入力 | Yes |
| payload.description | 説明文（キャンセル理由） | ユーザー入力 | Yes |
| payload.to.address | 送信先メールアドレス | $partner->email | No |
| payload.to.name | 送信先名 | $partner->name | No |
| payload.from.company | 送信元会社情報 | Auth::user()->defaultCompany | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 販売注文キャンセルアクション実行 | メール送信オプションが選択されている | キャンセル時の通知送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| メール送信オプション未選択 | キャンセル処理のみでメール送信しない選択が可能 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[担当者がキャンセルアクション実行] --> B{メール送信オプションあり?}
    B -->|なし| C[キャンセル処理のみ実行]
    B -->|あり| D[cancelAndSendEmailメソッド呼び出し]
    D --> E[取引先リストをループ]
    E --> F[SaleOrderCancelQuotation送信]
    F --> G[メッセージ履歴追加]
    G --> H[次の取引先へ]
    H --> I{全取引先処理完了?}
    I -->|No| E
    I -->|Yes| J[終了]
    C --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| partners | 取引先情報（メールアドレス、名前）取得 | Partner::whereIn |
| sales_orders | 注文情報取得 | 注文番号、ステータス |
| users | 送信者の会社情報取得 | Auth::user()->defaultCompany |

### テーブル別参照項目詳細

#### partners

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | 取引先識別子 | フォームで選択されたID |
| email | 送信先メールアドレス | - |
| name | 送信先名 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sales_orders | UPDATE | ステータスをCANCELに更新（キャンセル処理本体で実施） |
| chatter_messages | INSERT | メッセージ履歴の追加 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー等 | Laravelキューの標準リトライ機構に依存 |
| 取引先メールなし | Partner.emailがnull | メール送信処理は実行されるが、送信先が空になる可能性あり |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Laravelキュー設定に依存 |
| リトライ間隔 | Laravelキュー設定に依存 |
| リトライ対象エラー | キュー処理時の一時的なエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（システム設定に依存） |
| 1日あたり上限 | 制限なし（システム設定に依存） |

### 配信時間帯

特に制限なし。担当者の操作に応じて即時送信される。

## セキュリティ考慮事項

- 送信元アドレスと名称は動的に設定可能なため、なりすまし防止の設定が必要
- 会社情報（電話、メール、ウェブサイト）がメール本文に含まれる
- キャンセル理由等の業務情報が含まれるため、適切な内容入力が必要

## 備考

- 本機能はWebkul Salesプラグインの一部として実装されている
- EmailServiceを通じてメール送信が行われる
- キャンセル処理（cancelSaleOrderメソッド）とメール送信（cancelAndSendEmailメソッド）は別のメソッドで実装されている
- 送信されたメッセージはChatter機能を通じて履歴として保存される
- 添付ファイル機能はクラスに実装されているが、キャンセル通知では通常使用されない
