# 通知設計書 5-請求書送信メール

## 概要

本ドキュメントは、AureusERPシステムにおける請求書送信メール（InvoiceEmail）通知機能の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、経理担当者が顧客に対して請求書を送信する際に使用されるメール通知である。

**業務上の目的・背景**：会計業務において、請求書の迅速な送付は売掛金回収の重要な要素である。本通知機能により、システム内で作成した請求書をPDF形式で添付し、顧客に直接メール送信できる。これにより、請求プロセスの効率化と入金サイクルの短縮を実現する。

**通知の送信タイミング**：請求書画面において、担当者が「印刷して送信」（Print and Send）アクションを実行し、送信先顧客・件名・説明を入力して送信を確定した時点で送信される。

**通知の受信者**：送信フォームで選択された取引先（Partner）のメールアドレス。複数の取引先を選択した場合、各取引先に個別に送信される。

**通知内容の概要**：請求書番号、ユーザーが入力した説明文、会社情報、および請求書PDFファイルが添付される。

**期待されるアクション**：顧客は添付された請求書PDFを確認し、支払期日までに支払いを行うことが期待される。

## 通知種別

メール通知（HTML形式、Laravel Mailableコンポーネント使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Queueable trait使用） |
| 優先度 | 高（請求書は財務上重要） |
| リトライ | Laravelキューのデフォルト設定に依存 |

### 送信先決定ロジック

1. 送信フォームで選択された取引先IDリストを取得
2. 各取引先IDに対応するPartnerレコードを取得
3. Partnerレコードにメールアドレスが設定されている場合のみ送信
4. メールアドレスがない取引先はスキップされる

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | payload['from']['address']（送信者設定） |
| 送信元名称 | payload['from']['name']（送信者名） |
| 件名 | ユーザー入力（$data['subject']） |
| 形式 | HTML（Bladeビュー） |

### 本文テンプレート

```html
<div class="breadcrumb">
    <p>{請求書番号}</p>
</div>

<div class="notification">
    {ユーザーが入力した説明文}
</div>

<div class="company-info">
    <div class="company-name">{会社名}</div>
    <p class="company-details">
        {電話番号} | {メールアドレス} | {ウェブサイト}
    </p>
</div>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| {指定ファイル名} | PDF | ファイル選択時 | 請求書PDF |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| payload.record_name | 請求書番号 | $record->name | Yes |
| payload.model_name | モデル名 | class_basename($record) | Yes |
| payload.subject | メール件名 | ユーザー入力 | Yes |
| payload.description | 説明文 | ユーザー入力 | Yes |
| payload.to.address | 送信先メールアドレス | $partner->email | No |
| payload.to.name | 送信先名 | $partner->name | No |
| payload.from.company | 送信元会社情報 | Auth::user()->defaultCompany | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 請求書画面の「印刷して送信」アクション実行 | 取引先にメールアドレスが設定されている | 請求書の送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 取引先のemail項目がnullまたは空 | Partner.emailがfalsy値の場合、スキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[担当者が印刷して送信アクション実行] --> B[取引先リストをループ]
    B --> C{取引先にメールアドレスあり?}
    C -->|なし| D[スキップして次の取引先へ]
    C -->|あり| E[添付ファイル準備]
    E --> F[InvoiceEmail送信]
    F --> G[次の取引先へ]
    D --> G
    G --> H{全取引先処理完了?}
    H -->|No| B
    H -->|Yes| I[メッセージ履歴追加]
    I --> J[成功通知表示]
    J --> K[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| partners | 取引先情報（メールアドレス、名前）取得 | Partner::whereIn |
| accounts_moves | 請求書情報取得 | 請求書番号 |
| users | 送信者の会社情報取得 | Auth::user()->defaultCompany |

### テーブル別参照項目詳細

#### partners

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | 取引先識別子 | フォームで選択されたID |
| email | 送信先メールアドレス | - |
| name | 送信先名 | - |

#### accounts_moves

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | 請求書番号 | 対象レコード |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| chatter_messages | INSERT | メッセージ履歴の追加 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー等 | Laravelキューの標準リトライ機構に依存 |
| 取引先メールなし | Partner.emailがnull | スキップして次の取引先を処理 |
| 添付ファイルなし | ファイルパスが無効 | 添付なしで送信される可能性あり |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Laravelキュー設定に依存 |
| リトライ間隔 | Laravelキュー設定に依存 |
| リトライ対象エラー | キュー処理時の一時的なエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（システム設定に依存） |
| 1日あたり上限 | 制限なし（システム設定に依存） |

### 配信時間帯

特に制限なし。担当者の操作に応じて即時送信される。

## セキュリティ考慮事項

- 請求書PDFには金額情報が含まれるため、TLS暗号化が推奨される
- 送信元アドレスと名称は動的に設定可能なため、なりすまし防止の設定が必要
- 会社情報（電話、メール、ウェブサイト）がメール本文に含まれる
- 添付ファイルはpublicストレージから取得される

## 備考

- 本機能はWebkul Accountsプラグインの一部として実装されている
- AccountManagerクラスのprintAndSendメソッドで処理される
- EmailServiceを通じてメール送信が行われる
- 送信成功後、Filament Notificationで成功メッセージが表示される
- 送信されたメッセージはChatter機能を通じて履歴として保存される
- ビューテンプレートはaccounts::mail/invoice/actions/invoice
