# 通知設計書 6-フォロワー追加メール

## 概要

本ドキュメントは、AureusERPシステムにおけるフォロワー追加メール（FollowerMail）通知機能の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、レコード（販売注文、購買注文、応募者など）にフォロワーとして追加された際に、追加されたユーザーに対して送信される通知メールである。

**業務上の目的・背景**：ERPシステムでは、複数のユーザーが協力して業務を遂行する。特定のレコードに対する更新情報を適切なメンバーに共有するため、フォロワー機能が実装されている。本通知は、フォロワーとして追加されたことをユーザーに知らせ、該当レコードへの関心と追跡を促すものである。

**通知の送信タイミング**：任意のレコード画面でフォロワー追加アクションを実行し、「通知する」オプションをオンにして保存した場合に送信される。

**通知の受信者**：フォロワーとして追加されたPartner（取引先/ユーザー）のメールアドレス。

**通知内容の概要**：フォロワー追加の通知メッセージ、レコードへのリンク、および任意のノート（メモ）が含まれる。

**期待されるアクション**：受信者はメール内のリンクをクリックして該当レコードを確認し、必要に応じてコメントや対応を行うことが期待される。

## 通知種別

メール通知（HTML形式、Laravel Mailableコンポーネント使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Queueable trait使用） |
| 優先度 | 低 |
| リトライ | Laravelキューのデフォルト設定に依存 |

### 送信先決定ロジック

1. フォロワー追加フォームで選択されたパートナーIDリストを取得
2. 各パートナーIDに対応するPartnerレコードを取得
3. 「通知する」オプションがオンの場合のみ、メール送信を実行
4. パートナーのメールアドレスに送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | payload['from']['address']（送信者設定） |
| 送信元名称 | payload['from']['name']（送信者名） |
| 件名 | "You have been added as a follower on {model_name}: {record_name}" |
| 形式 | HTML（Bladeビュー） |

### 本文テンプレート

```html
<div class="breadcrumb">
    <a href="{レコードURL}" class="view-button">
        View {モデル名}
    </a>
    <p>{レコード名}</p>
</div>

<div class="notification">
    {送信者名} ({送信者メールアドレス}) has added you as a follower on {モデル名}.

    {任意のノート}
</div>

<div class="company-info">
    <div class="company-name">{会社名}</div>
    <p class="company-details">
        {電話番号} | {メールアドレス} | {ウェブサイト}
    </p>
</div>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| payload.record_url | レコードへのURL | Resource::getUrl('view', ...) | Yes |
| payload.record_name | レコード名/タイトル | $record->name または recordTitleAttribute | Yes |
| payload.model_name | モデル名 | class_basename($record) | Yes |
| payload.subject | メール件名 | 自動生成（翻訳キー使用） | Yes |
| payload.note | 任意のノート | ユーザー入力 | No |
| payload.to.address | 送信先メールアドレス | $partner->email | Yes |
| payload.to.name | 送信先名 | $partner->name | Yes |
| payload.from.name | 送信者名 | EmailService設定 | Yes |
| payload.from.address | 送信者アドレス | EmailService設定 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | フォロワー追加アクション実行 | 「通知する」オプションがオン | フォロワー追加の通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| notifyオプションがfalse | 通知しないオプションを選択した場合 |
| notifyオプションが未設定 | 通知オプションが指定されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[担当者がフォロワー追加アクション実行] --> B[選択されたパートナーをループ]
    B --> C[パートナーをフォロワーとして追加]
    C --> D{通知オプションがオン?}
    D -->|No| E[次のパートナーへ]
    D -->|Yes| F[notifyFollowerメソッド呼び出し]
    F --> G[FollowerMail送信]
    G --> H[成功通知表示]
    H --> E
    E --> I{全パートナー処理完了?}
    I -->|No| B
    I -->|Yes| J[Chatterパネルリフレッシュ]
    J --> K[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| partners | フォロワー情報（メールアドレス、名前）取得 | Partner::findOrFail |
| {対象モデルテーブル} | レコード情報取得 | 動的にモデルに依存 |

### テーブル別参照項目詳細

#### partners

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | パートナー識別子 | フォームで選択されたID |
| email | 送信先メールアドレス | - |
| name | 送信先名 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| chatter_followers | INSERT | フォロワー関連レコードの追加 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー等 | エラーログに記録、エラー通知を表示 |
| パートナー取得失敗 | 無効なパートナーID | 例外がスローされ、エラー通知を表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Laravelキュー設定に依存 |
| リトライ間隔 | Laravelキュー設定に依存 |
| リトライ対象エラー | キュー処理時の一時的なエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（システム設定に依存） |
| 1日あたり上限 | 制限なし（システム設定に依存） |

### 配信時間帯

特に制限なし。担当者の操作に応じて即時送信される。

## セキュリティ考慮事項

- レコードへの直接URLが含まれるため、受信者は適切なアクセス権を持っている必要がある
- 認証なしでURLにアクセスした場合は、ログインが要求される
- 送信元アドレスと名称はEmailServiceの設定に基づく

## 備考

- 本機能はWebkul Chatterプラグインの一部として実装されている
- FollowerActionクラスで処理される
- EmailServiceを通じてメール送信が行われる
- ビューテンプレートはchatter::mail.follower-mail（カスタマイズ可能）
- setFollowerMailViewメソッドでビューをカスタマイズ可能
- フォロワー追加成功時にFilament Notificationで成功メッセージが表示される
