# 通知設計書 7-メッセージ通知メール

## 概要

本ドキュメントは、AureusERPシステムにおけるメッセージ通知メール（MessageMail）通知機能の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、レコード（販売注文、購買注文、応募者など）にメッセージが投稿された際に、そのレコードのフォロワー全員に対して送信される通知メールである。

**業務上の目的・背景**：ERPシステムでは、チーム内でのコミュニケーションと情報共有が重要である。Chatter機能を通じてレコードにコメントやメッセージを投稿でき、関係者（フォロワー）に即座に通知することで、迅速な対応と意思決定を支援する。

**通知の送信タイミング**：任意のレコード画面でメッセージ投稿アクションを実行し、メッセージを送信した時点で、そのレコードのフォロワー全員に自動的に送信される。

**通知の受信者**：対象レコードに登録されている全フォロワーのPartner（取引先/ユーザー）のメールアドレス。

**通知内容の概要**：投稿されたメッセージ内容、レコードへのリンク、送信者情報、および添付ファイル（存在する場合）が含まれる。

**期待されるアクション**：受信者はメール内のリンクをクリックして該当レコードを確認し、必要に応じて返信や対応を行うことが期待される。

## 通知種別

メール通知（HTML形式、Laravel Mailableコンポーネント使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Queueable trait使用） |
| 優先度 | 中 |
| リトライ | Laravelキューのデフォルト設定に依存 |

### 送信先決定ロジック

1. 対象レコードのフォロワーリストを取得
2. 各フォロワーのパートナー情報を取得
3. パートナーにメールアドレスが設定されている場合に送信
4. 全フォロワーに対して個別にメール送信を実行

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | payload['from']['address']（送信者設定） |
| 送信元名称 | payload['from']['name']（送信者名） |
| 件名 | "New message on {record_name}" |
| 形式 | HTML（Bladeビュー） |

### 本文テンプレート

```html
<div class="breadcrumb">
    <a href="{レコードURL}" class="view-button">
        View {モデル名}
    </a>
    <p>{レコード名}</p>
</div>

<div class="notification">
    {メッセージ内容}

    <p>{送信者名}</p>
</div>

<div class="company-info">
    <div class="company-name">{会社名}</div>
    <p class="company-details">
        {電話番号} | {メールアドレス} | {ウェブサイト}
    </p>
</div>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| {オリジナルファイル名} | 各種 | メッセージに添付がある場合 | 投稿時に添付されたファイル |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| payload.record_url | レコードへのURL | Resource::getUrl('view', ...) | Yes |
| payload.record_name | レコード名/タイトル | $record->name または recordTitleAttribute | Yes |
| payload.model_name | モデル名 | class_basename($record) | Yes |
| payload.subject | メール件名 | 自動生成（翻訳キー使用） | Yes |
| payload.content | メッセージ内容 | $message->body | Yes |
| payload.to.address | 送信先メールアドレス | $partner->email | Yes |
| payload.to.name | 送信先名 | $partner->name | Yes |
| payload.from.name | 送信者名 | EmailService設定 | Yes |
| payload.from.address | 送信者アドレス | EmailService設定 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | メッセージ投稿アクション実行 | フォロワーが存在し、パートナーにメールアドレスがある | メッセージ投稿の通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| フォロワーなし | 対象レコードにフォロワーが登録されていない場合 |
| パートナーなし | フォロワーに関連するパートナーがない場合 |
| メールアドレスなし | パートナーにメールアドレスが設定されていない場合（暗黙的スキップ） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがメッセージ投稿アクション実行] --> B[メッセージをレコードに追加]
    B --> C{添付ファイルあり?}
    C -->|Yes| D[添付ファイルをレコードに追加]
    C -->|No| E[notifyFollowerメソッド呼び出し]
    D --> E
    E --> F[フォロワーリストをループ]
    F --> G{フォロワーにパートナーあり?}
    G -->|No| H[次のフォロワーへ]
    G -->|Yes| I[MessageMail送信]
    I --> J[添付ファイル含めて送信]
    J --> H
    H --> K{全フォロワー処理完了?}
    K -->|No| F
    K -->|Yes| L[成功通知表示]
    L --> M[Chatterパネルリフレッシュ]
    M --> N[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| chatter_followers | フォロワー情報取得 | $record->followers |
| partners | フォロワーのパートナー情報取得 | $follower->partner |
| chatter_attachments | 添付ファイル情報取得 | $message->attachments |
| {対象モデルテーブル} | レコード情報取得 | 動的にモデルに依存 |

### テーブル別参照項目詳細

#### chatter_followers

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| partner_id | 関連パートナー取得 | 対象レコードのフォロワー |

#### partners

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| email | 送信先メールアドレス | フォロワーのパートナー |
| name | 送信先名 | フォロワーのパートナー |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| chatter_messages | INSERT | メッセージレコードの追加 |
| chatter_attachments | INSERT | 添付ファイルレコードの追加（存在する場合） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー等 | 例外をキャッチしてログに記録、エラー通知を表示 |
| メッセージ保存失敗 | データベースエラー | 例外をスローし、エラー通知を表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Laravelキュー設定に依存 |
| リトライ間隔 | Laravelキュー設定に依存 |
| リトライ対象エラー | キュー処理時の一時的なエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（システム設定に依存） |
| 1日あたり上限 | 制限なし（システム設定に依存） |

### 配信時間帯

特に制限なし。メッセージ投稿に応じて即時送信される。

## セキュリティ考慮事項

- レコードへの直接URLが含まれるため、受信者は適切なアクセス権を持っている必要がある
- 添付ファイルにはpublicストレージのURLが使用される
- メッセージ内容はHTMLとして表示されるため、XSS対策が必要（テンプレートでの{!! !!}使用に注意）
- 添付ファイルのサイズ・種類制限が適用される（10MB、特定MIME型のみ）

## 備考

- 本機能はWebkul Chatterプラグインの一部として実装されている
- MessageActionクラスで処理される
- EmailServiceを通じてメール送信が行われる
- ビューテンプレートはchatter::mail.message-mail（カスタマイズ可能）
- setMessageMailViewメソッドでビューをカスタマイズ可能
- 添付可能なファイル形式：画像、PDF、Word、Excel、テキスト
- 最大添付サイズ：10MB
- メッセージ投稿成功時にFilament Notificationで成功メッセージが表示される
