# 通知設計書 8-応募確認メール

## 概要

本ドキュメントは、AureusERPシステムにおける応募確認メール（ApplicationConfirmMail）通知機能の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、採用応募者が応募ステージに進んだ際に、応募者に対して応募受付確認を通知するメールである。

**業務上の目的・背景**：採用活動において、応募者とのコミュニケーションは重要である。応募を受け付けたことを迅速に通知することで、応募者に安心感を与え、企業のプロフェッショナルな印象を醸成する。本通知により、応募者は自身の応募が正常に受理されたことを確認できる。

**通知の送信タイミング**：応募者レコードの編集時に、ステージIDが初めて設定された（応募が受け付けられた）タイミングで自動的に送信される。

**通知の受信者**：応募者（Candidate）のメールアドレス（email_from）。

**通知内容の概要**：応募確認のメッセージ、応募した求人ポジション名、会社情報、および今後の選考プロセスに関する情報が含まれる。

**期待されるアクション**：応募者は応募が受理されたことを確認し、選考結果を待つ。追加の質問がある場合は会社に連絡することが案内される。

## 通知種別

メール通知（HTML形式、Laravel Mailableコンポーネント使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Queueable trait使用） |
| 優先度 | 中 |
| リトライ | Laravelキューのデフォルト設定に依存 |

### 送信先決定ロジック

1. 応募者レコード（Applicant）の候補者情報（Candidate）を取得
2. 候補者のemail_fromフィールドに送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | payload['from']['address']（送信者設定） |
| 送信元名称 | payload['from']['name']（送信者名） |
| 件名 | "Application Confirmation for {job_position}" |
| 形式 | HTML（Bladeビュー） |

### 本文テンプレート

```html
<div class="breadcrumb">
    Application confirmation: <p>{応募者名}</p>
</div>

<div class="notification">
    <p>Hello,</p>
    <p>
        Thank you for your application to the position of <strong class="highlighted-text">{求人ポジション名}</strong>
        at <strong>{会社名}</strong>.
    </p>
    <p>We appreciate your interest and will get back to you as soon as possible.</p>
    <hr class="separator">
    <h3 class="next-step-title">What happens next?</h3>
    <p>Our team will review your application and get back to you shortly.</p>
    <p>If you have any questions, feel free to contact us.</p>
</div>

<div class="company-info">
    <div class="company-name">{会社名}</div>
    <p class="company-details">
        {電話番号} | {メールアドレス} | {ウェブサイト}
    </p>
</div>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | 通常は添付なし | 添付機能は実装されているが通常使用しない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| payload.record_name | 応募者名 | $record->candidate->name | Yes |
| payload.job_position | 求人ポジション名 | $record->job->name | Yes |
| payload.subject | メール件名 | 翻訳キーで生成 | Yes |
| payload.to.address | 送信先メールアドレス | $record->candidate->email_from | Yes |
| payload.to.name | 送信先名 | $record->candidate->name | Yes |
| payload.from.company | 送信元会社情報 | Auth::user()->defaultCompany | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 応募者レコード編集・保存 | stage_idが初めて設定された場合 | 応募受付確認の通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| stage_idが既に設定済み | 既にステージが割り当てられている応募者には送信されない |
| stage_idの変更のみ | ステージの変更（初回設定以外）では送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[担当者が応募者レコードを編集・保存] --> B{stage_idが初めて設定された?}
    B -->|No| C[通知なしで終了]
    B -->|Yes| D[afterSaveフック実行]
    D --> E[sendApplicationConfirmationNotificationメソッド呼び出し]
    E --> F[prepareCandidateNotificationPayloadでペイロード作成]
    F --> G[ApplicationConfirmMail送信]
    G --> H[メッセージ履歴追加]
    H --> I[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| recruitments_applicants | 応募者情報取得 | $record |
| recruitments_candidates | 候補者情報取得 | $record->candidate |
| recruitments_jobs | 求人情報取得 | $record->job |
| users | 送信者の会社情報取得 | Auth::user()->defaultCompany |

### テーブル別参照項目詳細

#### recruitments_applicants

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| candidate_id | 候補者関連取得 | 対象レコード |
| job_id | 求人関連取得 | 対象レコード |
| stage_id | トリガー判定 | 対象レコード |

#### recruitments_candidates

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | 送信先名 | $record->candidate |
| email_from | 送信先メールアドレス | $record->candidate |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| chatter_messages | INSERT | メッセージ履歴の追加 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー等 | Laravelキューの標準リトライ機構に依存 |
| 候補者メールなし | email_fromがnull | メール送信が失敗する可能性あり |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Laravelキュー設定に依存 |
| リトライ間隔 | Laravelキュー設定に依存 |
| リトライ対象エラー | キュー処理時の一時的なエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（システム設定に依存） |
| 1日あたり上限 | 制限なし（システム設定に依存） |

### 配信時間帯

特に制限なし。レコード保存に応じて即時送信される。

## セキュリティ考慮事項

- 応募者の個人情報（名前、メールアドレス）が含まれる
- 送信元アドレスと名称はEmailServiceの設定に基づく
- 会社情報（電話、メール、ウェブサイト）がメール本文に含まれる

## 備考

- 本機能はWebkul Recruitmentsプラグインの一部として実装されている
- EditApplicantページクラスのafterSaveフックで処理される
- EmailServiceを通じてメール送信が行われる
- ビューテンプレートはrecruitments::mails.application-confirm
- 送信後、メール内容がChatter機能を通じて履歴として保存される
- 多言語対応されており、メッセージは翻訳キーから取得される
