# 通知設計書 9-応募者不採用メール

## 概要

本ドキュメントは、AureusERPシステムにおける応募者不採用メール（ApplicantRefuseMail）通知機能の設計仕様を定義するものである。

### 本通知の処理概要

本通知は、採用応募者が不採用となった際に、応募者に対して選考結果を通知するメールである。

**業務上の目的・背景**：採用活動において、不採用となった応募者への丁寧な連絡は企業ブランドの維持に重要である。本通知により、応募者に対して敬意を持った形で選考結果を伝え、将来の関係性を維持することができる。不採用理由に応じたテンプレートを選択できる柔軟性も備えている。

**通知の送信タイミング**：応募者画面において「不採用」（Refuse）アクションを実行し、不採用理由を選択、かつ「通知する」オプションをオンにした場合に送信される。

**通知の受信者**：応募者（Candidate）のメールアドレス。送信フォームでメールアドレスを変更することも可能。

**通知内容の概要**：不採用の通知メッセージ、応募への感謝、今後の成功を願うメッセージ、および管理者連絡先が含まれる。

**期待されるアクション**：応募者は選考結果を確認し、必要に応じて問い合わせを行う。

## 通知種別

メール通知（HTML形式、Laravel Mailableコンポーネント使用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Queueable trait使用） |
| 優先度 | 中 |
| リトライ | Laravelキューのデフォルト設定に依存 |

### 送信先決定ロジック

1. 不採用フォームでメールアドレスを取得（デフォルトは候補者のemail_from）
2. フォームでメールアドレスが変更された場合はその値を使用
3. 指定されたメールアドレスに送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | payload['from']['address']（送信者設定） |
| 送信元名称 | payload['from']['name']（送信者名） |
| 件名 | "Application Status for {job_position}" |
| 形式 | HTML（Bladeビュー） |

### 本文テンプレート

```html
<div class="breadcrumb">
    Application Status: {応募者名}
</div>

<div class="notification">
    <div class="message-content">
        <p>Dear Applicant,</p>
        <p>Thank you for your interest in joining {会社名}.</p>
        <p>We wish you all the best in your future endeavors.</p>
        <div class="admin-details">
            <p><strong>Contact: {管理者名}</strong></p>
            <p>Email: {管理者メールアドレス}</p>
        </div>
    </div>
</div>

<div class="company-info">
    <div class="company-name">{会社名}</div>
    <p class="company-details">
        {電話番号} | {メールアドレス} | {ウェブサイト}
    </p>
</div>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | 通常は添付なし | 添付機能は実装されているが通常使用しない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| payload.applicant_name | 応募者名 | $record->candidate->name | Yes |
| payload.subject | メール件名 | 翻訳キーで生成 | Yes |
| payload.to.address | 送信先メールアドレス | フォーム入力または$record->candidate->email_from | Yes |
| payload.to.name | 送信先名 | $record->candidate->name | Yes |
| payload.from.name | 送信者名 | EmailService設定 | Yes |
| payload.from.address | 送信者メールアドレス | EmailService設定 | Yes |
| payload.from.company | 送信元会社情報 | Auth::user()->defaultCompany | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 応募者画面の「不採用」アクション実行 | 不採用理由を選択かつ「通知する」オプションがオン | 不採用通知の送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| notifyオプションがfalse | 通知しないオプションを選択した場合 |
| refuse_reason_idがnull | 不採用理由が選択されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[担当者が不採用アクション実行] --> B{不採用理由を選択?}
    B -->|No| C[処理終了]
    B -->|Yes| D[setAsRefusedメソッド呼び出し]
    D --> E{通知オプションがオン?}
    E -->|No| F[不採用設定のみで終了]
    E -->|Yes| G[prepareApplicantRefuseNotificationPayloadでペイロード作成]
    G --> H[ApplicantRefuseMail送信]
    H --> I[不採用理由に応じたテンプレートを使用]
    I --> J[成功通知表示]
    J --> K[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| recruitments_applicants | 応募者情報取得 | $record |
| recruitments_candidates | 候補者情報取得 | $record->candidate |
| recruitments_refuse_reasons | 不採用理由取得 | RefuseReason::find() |
| recruitments_jobs | 求人情報取得 | $record->job |
| users | 送信者の会社情報取得 | Auth::user()->defaultCompany |

### テーブル別参照項目詳細

#### recruitments_applicants

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| candidate_id | 候補者関連取得 | 対象レコード |
| job_id | 求人関連取得 | 対象レコード |
| refuse_reason_id | 不採用理由関連 | 更新対象 |

#### recruitments_refuse_reasons

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | 不採用理由ID | フォームで選択 |
| name | 不採用理由名 | 表示用 |
| template | メールテンプレート名 | ビュー選択に使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| recruitments_applicants | UPDATE | refuse_reason_idの設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー等 | Laravelキューの標準リトライ機構に依存 |
| 不採用理由なし | refuse_reason_idがnull | 処理を中断（return null） |
| テンプレートなし | 不採用理由のテンプレートが未定義 | エラーが発生する可能性あり |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Laravelキュー設定に依存 |
| リトライ間隔 | Laravelキュー設定に依存 |
| リトライ対象エラー | キュー処理時の一時的なエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（システム設定に依存） |
| 1日あたり上限 | 制限なし（システム設定に依存） |

### 配信時間帯

特に制限なし。担当者の操作に応じて即時送信される。

## セキュリティ考慮事項

- 応募者の個人情報（名前、メールアドレス）が含まれる
- 送信先メールアドレスはフォームで変更可能なため、誤送信に注意
- 管理者の連絡先情報がメール本文に含まれる
- 送信元アドレスと名称はEmailServiceの設定に基づく

## 備考

- 本機能はWebkul Recruitmentsプラグインの一部として実装されている
- EditApplicantページクラスのrefuseアクションで処理される
- EmailServiceを通じてメール送信が行われる
- ビューテンプレートはrecruitments::mails.{refuse_reason.template}で動的に選択
- 不採用理由ごとに異なるテンプレートを使用可能
- 標準テンプレート：applicant-refuse, applicant-not-interested
- ViewApplicantページからも同様の不採用処理が可能
