---
generated_at: 2025-12-27 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：1-ユーザー招待メール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **リトライ仕様**：Laravelキュー設定への依存のため、実際の設定値は未確認
  2. **レート制限**：システム設定への依存のため、実際の制限値は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/security/src/Mail/UserInvitationMail.php`
- E-02: `plugins/webkul/security/src/Filament/Resources/UserResource/Pages/ListUsers.php`
- E-03: `plugins/webkul/security/resources/views/emails/user-invitation.blade.php`
- E-04: `plugins/webkul/security/resources/lang/en/mail/user-invitation-mail.php`
- E-05: `plugins/webkul/security/resources/lang/en/views/emails/user-invitation.php`
- E-06: `plugins/webkul/security/src/Models/Invitation.php`
- E-07: `plugins/webkul/security/database/migrations/2024_11_11_112529_create_user_invitations_table.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 非同期送信方式（Queueable使用） | E-01（16行目：use Queueable） | ○ |
| C-02 | 件名は多言語対応で「You're Invited to Join Our {app}」 | E-01（34行目）, E-04 | ○ |
| C-03 | 署名付きURL（signed route）を使用 | E-01（48-50行目：URL::signedRoute） | ○ |
| C-04 | Markdownテンプレートを使用 | E-01（46行目：markdown: 'security::emails.user-invitation'） | ○ |
| C-05 | 添付ファイルなし | E-01（61-63行目：return []） | ○ |
| C-06 | user_invitationsテーブルにINSERT | E-02（65行目：Invitation::create） | ○ |
| C-07 | テーブル構造（id, email, timestamps） | E-07（14-17行目） | ○ |
| C-08 | enable_user_invitation設定で機能制御 | E-02（47行目：visible条件） | ○ |
| C-09 | default_company_id未設定時にエラー | E-02（55-62行目） | ○ |
| C-10 | 送信成功時に成功通知表示 | E-02（70-73行目） | ○ |
| C-11 | 送信失敗時に例外をキャッチしてエラー通知 | E-02（75-82行目） | ○ |
| C-12 | 本文に招待メッセージ、ボタン、注意書きを含む | E-03, E-05 | ○ |
| C-13 | acceptUrl変数で招待承認URLを渡す | E-01（48-50行目）, E-03（4行目） | ○ |
| C-14 | app変数でアプリケーション名を渡す | E-04（5行目：config('app.name')） | ○ |
| C-15 | Invitationモデルをパラメータとして受け取る | E-01（23-25行目） | ○ |
| C-16 | ルート名はsecurity.invitation.accept | E-01（49行目） | ○ |
| C-17 | リトライ回数・間隔はLaravelキュー設定に依存 | **根拠なし** | △ |
| C-18 | レート制限は制限なし（システム設定に依存） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- リトライ仕様について：コード上でQueueableトレイトを使用していることは確認できるが、実際のキュー設定（リトライ回数、間隔など）はconfig/queue.phpや.envファイルで定義されるため、本分析では確認できなかった
  - 候補：config/queue.php / .env / Laravel公式ドキュメント
- レート制限について：メール送信に対するレート制限の実装は確認できなかった。アプリケーションレベルまたはSMTPプロバイダーレベルでの制限が適用される可能性がある
  - 候補：メールプロバイダー設定 / Laravelレートリミット設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 署名付きURLの有効期限設定（Laravelデフォルト動作として記述）
- 0: 低リスク - 招待メールの重複送信防止機構（現状は明示的な制御なし）
- 1: 中リスク - リトライ・レート制限の具体的な値が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] 署名付きURLの有効期限が適切か確認（security要件との整合性）
- [ ] キュー設定（リトライ回数・間隔）が運用要件を満たしているか確認
- [ ] メール送信のレート制限がSMTPプロバイダーの制限内か確認
- [ ] 多言語対応が必要な言語すべてで翻訳が用意されているか確認
