---
generated_at: 2025-12-27 00:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：14-警告通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **全使用箇所の網羅性**：他プラグインでの使用箇所の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/TodoAction.php` (27-30行目)
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/ValidateAction.php` (103-182行目)
- E-03: `plugins/webkul/time-off/src/Traits/TimeOffHelper.php` (229-256行目, 309-328行目)
- E-04: `通知一覧.csv` (No.14の備考欄)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Filament Notificationを使用している | E-01, E-02, E-03, E-04 | ○ |
| C-02 | Notification::make()->warning()でwarning状態を設定 | E-01 (30行目), E-02 (181行目) | ○ |
| C-03 | 移動明細なしで警告表示 | E-01 (26行目: if (! $record->moves->count())) | ○ |
| C-04 | 明細行なしで警告表示 | E-02 (102行目: if ($move->lines->isEmpty())) | ○ |
| C-05 | ロット番号未設定で警告表示 | E-02 (134行目: if $isLotTracking && lot_id未設定) | ○ |
| C-06 | シリアル番号数量不正で警告表示 | E-02 (147行目: if qty != 1) | ○ |
| C-07 | 部分パッケージ移動で警告表示 | E-02 (113-128行目: partial-package check) | ○ |
| C-08 | 従業員未設定で警告表示 | E-03 (228-233行目: if (! $employee)) | ○ |
| C-09 | 期間重複で警告表示 | E-03 (251-256行目: if ($overlap)) | ○ |
| C-10 | 割当残高なしで警告表示 | E-03 (308-318行目: if $totalAllocated <= 0) | ○ |
| C-11 | 残高不足で警告表示 | E-03 (322-332行目: if $requestedDays > $availableBalance) | ○ |
| C-12 | 全使用箇所を網羅 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 全使用箇所の完全なリスト：他のプラグインでの使用箇所を網羅的に調査する必要あり
  - 候補：accounts / employees / partners 等の各プラグイン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 警告通知は情報提供目的であり、セキュリティリスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] 警告メッセージがユーザーにとって理解可能か確認
- [ ] 警告後の処理フローが適切か確認（続行可能/中断）
- [ ] 言語ファイルに該当するキーが存在するか確認
