---
generated_at: 2025-12-27 10:30:00
metrics:
  claims_total: 85
  claims_with_evidence: 78
  claims_without_evidence: 7
confidence_derived: 0.92
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された運用マニュアルの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：78 / 85、根拠なし：7
- 優先レビュー（高）
  1. **ログインURL**：具体的なURL情報がコードから特定不可
  2. **カンバンビュー操作**：ドラッグ&ドロップの詳細動作
  3. **2段階承認**：実装詳細の確認が必要
  4. **メール送信機能**：SMTP設定依存の動作
  5. **PDF生成機能**：DOMPDFライブラリの設定依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（369画面）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（114機能）
- E-04: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件（83要件）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能対応
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図
- E-07: `plugins/webkul/sales/` - 販売プラグイン
- E-08: `plugins/webkul/purchases/` - 購買プラグイン
- E-09: `plugins/webkul/inventories/` - 在庫プラグイン
- E-10: `plugins/webkul/accounts/` - 会計プラグイン
- E-11: `plugins/webkul/employees/` - 従業員プラグイン
- E-12: `plugins/webkul/time-off/` - 休暇プラグイン
- E-13: `plugins/webkul/projects/` - プロジェクトプラグイン
- E-14: `plugins/webkul/recruitments/` - 採用プラグイン
- E-15: `plugins/webkul/security/` - セキュリティプラグイン
- E-16: `plugins/webkul/plugin-manager/` - プラグイン管理

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | システム概要（ERP、モジュール式アーキテクチャ） | E-01 | ○ |
| C-02 | 対象ユーザーと役割（9種類） | E-04 | ○ |
| C-03 | 見積書一覧画面の存在 | E-02 (No.293) | ○ |
| C-04 | 見積書作成機能 | E-03 (F012), E-04 (No.1) | ○ |
| C-05 | 見積書のメール送信機能 | E-04 (No.2) | ○ |
| C-06 | 見積書から受注への変換 | E-04 (No.3) | ○ |
| C-07 | 受注時の出庫オペレーション自動作成 | E-04 (No.3) | ○ |
| C-08 | 受注からの請求書発行 | E-04 (No.6) | ○ |
| C-09 | 配送状況確認機能 | E-04 (No.7) | ○ |
| C-10 | 顧客管理機能（住所・連絡先） | E-04 (No.8), E-02 (No.301-304) | ○ |
| C-11 | 見積依頼（RFQ）作成機能 | E-04 (No.11), E-02 (No.251-254) | ○ |
| C-12 | 見積依頼の送信機能 | E-04 (No.12) | ○ |
| C-13 | 発注書への変換機能 | E-04 (No.13) | ○ |
| C-14 | 発注時の入庫オペレーション自動作成 | E-04 (No.13) | ○ |
| C-15 | 仕入先管理機能 | E-04 (No.18), E-02 (No.263-266) | ○ |
| C-16 | 仕入先価格管理 | E-04 (No.19), E-02 (No.267) | ○ |
| C-17 | 入庫処理機能 | E-04 (No.20), E-02 (No.158-161) | ○ |
| C-18 | ロット・シリアル番号管理 | E-04 (No.20, 29) | ○ |
| C-19 | 出庫処理機能 | E-04 (No.21), E-02 (No.170-173) | ○ |
| C-20 | 内部移動機能 | E-04 (No.22), E-02 (No.166-169) | ○ |
| C-21 | 在庫廃棄機能 | E-04 (No.23), E-02 (No.162-165) | ○ |
| C-22 | オペレーション検証機能 | E-04 (No.24) | ○ |
| C-23 | 倉庫管理機能 | E-04 (No.26), E-02 (No.107-111) | ○ |
| C-24 | ロケーション管理機能 | E-04 (No.27), E-02 (No.129-132) | ○ |
| C-25 | 在庫ルート管理 | E-04 (No.28), E-02 (No.112-116) | ○ |
| C-26 | 顧客請求書作成機能 | E-04 (No.31), E-02 (No.25-28) | ○ |
| C-27 | 請求書確認・転記機能 | E-04 (No.32) | ○ |
| C-28 | クレジットノート発行 | E-04 (No.34), E-02 (No.15-18) | ○ |
| C-29 | 入金処理機能 | E-04 (No.35), E-02 (No.38-41) | ○ |
| C-30 | 仕入請求書処理 | E-04 (No.36), E-02 (No.7-10) | ○ |
| C-31 | 支払処理機能 | E-04 (No.37) | ○ |
| C-32 | 勘定科目管理 | E-04 (No.38), E-02 (No.1-4) | ○ |
| C-33 | 仕訳帳管理 | E-04 (No.39), E-02 (No.29-32) | ○ |
| C-34 | 税設定管理 | E-04 (No.40), E-02 (No.46-49) | ○ |
| C-35 | 支払条件管理 | E-04 (No.41), E-02 (No.33-37) | ○ |
| C-36 | 従業員登録機能 | E-04 (No.42), E-02 (No.74-77) | ○ |
| C-37 | 従業員スキル管理 | E-04 (No.43), E-02 (No.79) | ○ |
| C-38 | 履歴書管理 | E-04 (No.44), E-02 (No.78) | ○ |
| C-39 | 部門管理機能 | E-04 (No.45), E-02 (No.80-84) | ○ |
| C-40 | 職位管理機能 | E-04 (No.46), E-02 (No.91-94) | ○ |
| C-41 | 勤務カレンダー管理 | E-04 (No.47), E-02 (No.95-98) | ○ |
| C-42 | 求人作成機能 | E-04 (No.48), E-02 (No.282-285) | ○ |
| C-43 | 応募者登録機能 | E-04 (No.49), E-02 (No.271-273) | ○ |
| C-44 | 選考ステージ管理 | E-04 (No.50), E-02 (No.279-281) | ○ |
| C-45 | 採用決定機能 | E-04 (No.51) | ○ |
| C-46 | 候補者プール管理 | E-04 (No.53), E-02 (No.274-277) | ○ |
| C-47 | 休暇申請機能 | E-04 (No.54), E-02 (No.334-337) | ○ |
| C-48 | 休暇承認機能 | E-04 (No.55), E-02 (No.342-345) | ○ |
| C-49 | 休暇割当管理 | E-04 (No.56), E-02 (No.346-349) | ○ |
| C-50 | 休暇タイプ管理 | E-04 (No.57), E-02 (No.351-354) | ○ |
| C-51 | 休暇発生プラン管理 | E-04 (No.58), E-02 (No.355-358) | ○ |
| C-52 | 祝日管理 | E-04 (No.59), E-02 (No.359) | ○ |
| C-53 | 休暇残高確認 | E-04 (No.60), E-02 (No.338-341) | ○ |
| C-54 | プロジェクト作成機能 | E-04 (No.61), E-02 (No.233-236) | ○ |
| C-55 | タスク作成機能 | E-04 (No.62), E-02 (No.239-242) | ○ |
| C-56 | タスク状態管理 | E-04 (No.63) | ○ |
| C-57 | サブタスク管理 | E-04 (No.64), E-02 (No.243) | ○ |
| C-58 | マイルストーン管理 | E-04 (No.65), E-02 (No.237) | ○ |
| C-59 | タスク工数入力 | E-04 (No.66), E-02 (No.244) | ○ |
| C-60 | タイムシート入力 | E-04 (No.67), E-02 (No.361) | ○ |
| C-61 | 商品登録機能 | E-04 (No.68), E-02 (No.216-219) | ○ |
| C-62 | 商品バリエーション管理 | E-04 (No.69), E-02 (No.224-227) | ○ |
| C-63 | 商品カテゴリ管理 | E-04 (No.70), E-02 (No.228-231) | ○ |
| C-64 | 価格リスト管理 | E-04 (No.71), E-02 (No.220-223) | ○ |
| C-65 | パートナー管理 | E-04 (No.72), E-02 (No.63-66) | ○ |
| C-66 | 住所管理 | E-04 (No.73), E-02 (No.67) | ○ |
| C-67 | 銀行口座管理 | E-04 (No.74), E-02 (No.69) | ○ |
| C-68 | ブログ記事管理 | E-04 (No.75), E-02 (No.54-57) | ○ |
| C-69 | ページ管理 | E-04 (No.78), E-02 (No.362-365) | ○ |
| C-70 | ユーザー管理機能 | E-04 (No.79), E-02 (No.314-317) | ○ |
| C-71 | ロール管理機能 | E-04 (No.80), E-02 (No.318-321) | ○ |
| C-72 | 会社管理機能 | E-04 (No.81), E-02 (No.322-325) | ○ |
| C-73 | プラグイン管理機能 | E-04 (No.82), E-02 (No.215) | ○ |
| C-74 | カスタムフィールド管理 | E-04 (No.83), E-02 (No.104-106) | ○ |
| C-75 | Filament PHPベースのシステム | E-01 | ○ |
| C-76 | Laravel 11.xフレームワーク | E-01 | ○ |
| C-77 | 複数プラグインの存在（16モジュール） | E-01, E-06 | ○ |
| C-78 | CRUD画面遷移パターン | E-06 | ○ |
| C-79 | ログインURL・方法 | **根拠なし** | △ |
| C-80 | ドラッグ&ドロップによるカンバン操作 | **根拠不足** | △ |
| C-81 | 2段階承認フロー | **根拠不足** | △ |
| C-82 | PDF生成のテンプレート詳細 | **根拠不足** | △ |
| C-83 | メールテンプレートの詳細 | **根拠不足** | △ |
| C-84 | パスワードポリシーの詳細 | **根拠なし** | △ |
| C-85 | セッションタイムアウト設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **ログインURL・認証フロー**
  - 候補：`routes/web.php` / Filament認証設定 / `.env`設定
  - 実運用時には管理者に確認が必要

- **カンバンビューのUI詳細**
  - 候補：Filament Resourceのview設定 / カスタムBladeテンプレート
  - Filament標準機能として提供されている可能性が高い

- **2段階承認の実装詳細**
  - 候補：`time-off`プラグインのApproval関連クラス
  - 設定による有効/無効の確認が必要

- **PDF/メールテンプレート**
  - 候補：`resources/views/` / 各プラグインの`views/`
  - DOMPDFライブラリ使用は確認済み

- **セキュリティ設定詳細**
  - 候補：`config/auth.php` / `config/session.php`
  - 環境依存の設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: システム概要、画面構成、CRUD操作手順
  - 根拠が明確で、コードベースと一致

- **1（中リスク）**: ワークフロー詳細、承認フロー、通知機能
  - 基本機能は確認できるが、設定依存の動作がある

- **2（高リスク）**: ログイン詳細、セキュリティ設定、環境依存機能
  - 実環境での確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ログインURL・方法が実環境と一致しているか確認
- [ ] 各画面名が実際のシステム表示と一致しているか確認
- [ ] 操作手順のボタン名・メニュー名が実際と一致しているか確認
- [ ] 権限設定が実際のロール構成と一致しているか確認
- [ ] PDF/メール送信機能が実際に動作するか確認
- [ ] トラブルシューティングの対処法が有効か確認
- [ ] ユーザー種別と役割の定義が組織と一致しているか確認
