# Aureus ERP 運用マニュアル

## 1. はじめに

### 1.1 システム概要

Aureus ERPは、中小企業から大規模企業向けに設計された包括的なオープンソースERPシステムです。財務会計、人事管理、在庫管理、販売管理、購買管理、プロジェクト管理など、ビジネス運営のあらゆる側面をサポートします。

主な特徴：
- モジュール式プラグインアーキテクチャにより、必要な機能のみを選択して使用可能
- ロールベースのアクセス制御による柔軟な権限管理
- 販売から出荷、請求までの一貫したビジネスプロセス管理
- 購買から入庫、支払までの統合的なサプライチェーン管理
- 従業員管理、休暇管理、採用管理などの包括的な人事機能

### 1.2 対象ユーザーと役割

| ユーザー種別 | 役割 | 主な業務 |
|-------------|------|---------|
| 営業担当者 | 販売活動の実行 | 見積書作成、受注管理、顧客対応 |
| 購買担当者 | 購買活動の実行 | 見積依頼、発注、仕入先管理 |
| 倉庫担当者 | 在庫オペレーションの実行 | 入庫、出庫、在庫移動、棚卸 |
| 経理担当者 | 財務会計の管理 | 請求書発行、入出金管理、仕訳処理 |
| 人事担当者 | 人事業務の管理 | 従業員管理、休暇管理、採用管理 |
| プロジェクトマネージャー | プロジェクト管理 | プロジェクト作成、タスク管理、進捗管理 |
| 従業員 | 日常業務の遂行 | 休暇申請、工数入力、タスク実行 |
| マネージャー | 承認・管理業務 | 休暇承認、タスク確認、レポート確認 |
| システム管理者 | システム全体の管理 | ユーザー管理、権限設定、プラグイン管理 |

### 1.3 業務フロー図

```
+------------------------------------------------------------------------------------+
|                              【メイン業務フロー】                                      |
|                                                                                    |
|    販売プロセス          購買プロセス          在庫プロセス        会計プロセス        |
|                                                                                    |
|       (1)         ←→        (2)         ←→        (3)        →        (4)        |
|                                                                                    |
|  ・見積書作成           ・見積依頼作成         ・入庫処理          ・請求書発行       |
|  ・受注確定             ・発注確定             ・出庫処理          ・入金処理         |
|  ・出荷指示             ・入庫確認             ・在庫調整          ・支払処理         |
|  ・請求書発行           ・仕入請求確認         ・ロット管理        ・仕訳処理         |
+------------------------------------------------------------------------------------+

+------------------------------------------------------------------------------------+
|                              【人事・プロジェクト業務】                               |
|                                                                                    |
|    人事管理              休暇管理              採用管理           プロジェクト管理   |
|                                                                                    |
|       (A)                  (B)                  (C)                  (D)          |
|                                                                                    |
|  ・従業員登録           ・休暇申請            ・求人作成          ・プロジェクト作成  |
|  ・部門配置             ・承認処理            ・応募者管理        ・タスク管理        |
|  ・スキル管理           ・残高確認            ・選考進行          ・工数管理          |
+------------------------------------------------------------------------------------+
```

**本マニュアルの章構成は、上記の業務フローに対応しています。**

---

## 2. 販売管理

本章では、見積書の作成から受注、出荷、請求までの販売プロセスについて説明します。

### 2.1 見積書を作成するとき

**業務シーン**: 顧客から商品やサービスの見積依頼を受けた場合

**前提条件**:
- 顧客情報が登録済みであること
- 販売商品が登録済みであること

**やるべきこと**:
1. 顧客情報を確認する
2. 見積書を新規作成する
3. 商品明細を追加する
4. 価格・税金・支払条件を設定する
5. 見積書を保存する

**システムでの操作手順**:

1. **見積書一覧画面を開く**
   - 左メニューから「販売」>「見積書」を選択
   - 「見積書一覧」画面が表示される

2. **新規見積書を作成する**
   - 右上の「作成」ボタンをクリック
   - 以下の情報を入力：
     - 顧客：顧客名を選択（検索可能）
     - 有効期限：見積の有効期間
     - 支払条件：支払条件を選択
   - 「保存」ボタンで保存

3. **商品明細を追加する**
   - 「明細を追加」ボタンをクリック
   - 商品を選択し、数量・単価を入力
   - 税金が自動計算される
   - 必要に応じて割引を設定

**関連画面**: 見積書一覧、見積書作成、見積書編集、顧客一覧

**注意点・Tips**:
- 見積テンプレートを使用すると、よく使う構成を素早く作成できます
- 価格リストを設定している場合、顧客に応じた価格が自動適用されます

**次のステップ**: 見積書の送信、または受注への変換

---

### 2.2 見積書を顧客に送信するとき

**業務シーン**: 作成した見積書を顧客にメールで送付する場合

**前提条件**:
- 見積書が作成済みであること
- 顧客のメールアドレスが登録されていること

**やるべきこと**:
1. 見積書の内容を最終確認する
2. PDFプレビューで体裁を確認する
3. メールで見積書を送信する

**システムでの操作手順**:

1. **見積書詳細画面を開く**
   - 「見積書一覧」から対象の見積書をクリック
   - 見積書の詳細画面が表示される

2. **見積書をメール送信する**
   - 「メール送信」ボタンをクリック
   - メール作成ダイアログが表示される
   - 宛先・件名・本文を確認
   - PDF添付が自動設定される
   - 「送信」ボタンでメール送信

**関連画面**: 見積書詳細

**注意点・Tips**:
- 送信後、見積書のステータスが「送信済み」に変更されます
- 送信履歴はチャッターで確認できます

**次のステップ**: 顧客からの返答待ち、または受注への変換

---

### 2.3 見積書を受注に変換するとき

**業務シーン**: 顧客から見積承諾を得て、正式な受注として処理する場合

**前提条件**:
- 見積書が作成済みであること
- 顧客から承諾を得ていること

**やるべきこと**:
1. 見積書を確認する
2. 受注に変換する
3. 出庫オペレーションを確認する

**システムでの操作手順**:

1. **見積書詳細画面を開く**
   - 「見積書一覧」から対象の見積書をクリック

2. **受注に変換する**
   - 「確認」ボタンをクリック
   - 見積書が受注に変換される
   - 在庫ルールに基づき出庫オペレーションが自動作成される

3. **受注内容を確認する**
   - 受注番号が付与される
   - 配送ステータスが「未発送」として表示される

**関連画面**: 見積書詳細、受注詳細、出庫一覧

**注意点・Tips**:
- 在庫連携が有効な場合、出庫オペレーションが自動作成されます
- 設定により、確認時に自動ロックを有効にできます

**次のステップ**: 出荷処理、請求書発行

---

### 2.4 受注から請求書を発行するとき

**業務シーン**: 受注に対して請求書を発行する場合

**前提条件**:
- 受注が確定していること

**やるべきこと**:
1. 受注詳細を開く
2. 請求書を作成する
3. 請求書を確認・送信する

**システムでの操作手順**:

1. **受注詳細画面を開く**
   - 「販売」>「受注」から対象の受注をクリック

2. **請求書を作成する**
   - 「請求書作成」ボタンをクリック
   - 請求書タイプを選択（通常請求書/前払請求書）
   - 請求書が作成される

3. **請求書を確認する**
   - 作成された請求書を開く
   - 「確認」ボタンで請求書を確定
   - 必要に応じてメール送信

**関連画面**: 受注詳細、請求書一覧、請求書詳細

**注意点・Tips**:
- 前払い請求と納品後請求の両方に対応しています
- 部分請求も可能です

**次のステップ**: 入金確認

---

### 2.5 顧客を管理するとき

**業務シーン**: 新規顧客の登録、既存顧客情報の更新を行う場合

**前提条件**:
- 顧客に関する基本情報を把握していること

**やるべきこと**:
1. 顧客情報を登録/編集する
2. 住所情報を設定する
3. 連絡先を設定する

**システムでの操作手順**:

1. **顧客一覧画面を開く**
   - 「販売」>「顧客」を選択

2. **顧客を新規作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 会社名/個人名
     - メールアドレス
     - 電話番号
     - 業種
   - 「保存」ボタンで保存

3. **住所を追加する**
   - 顧客詳細画面で「住所」タブを選択
   - 「追加」ボタンで請求先・配送先住所を登録

**関連画面**: 顧客一覧、顧客作成、顧客編集、顧客詳細

**注意点・Tips**:
- 請求先と配送先で異なる住所を設定できます
- タグを使って顧客を分類できます

**次のステップ**: 見積書・受注の作成

---

## 3. 購買管理

本章では、見積依頼の作成から発注、入庫、支払までの購買プロセスについて説明します。

### 3.1 見積依頼（RFQ）を作成するとき

**業務シーン**: 仕入先に商品の見積依頼を行う場合

**前提条件**:
- 仕入先情報が登録済みであること
- 購買商品が登録済みであること

**やるべきこと**:
1. 仕入先を選択する
2. 見積依頼を作成する
3. 商品明細を追加する
4. 見積依頼を送信する

**システムでの操作手順**:

1. **見積依頼一覧画面を開く**
   - 左メニューから「購買」>「見積依頼」を選択

2. **新規見積依頼を作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 仕入先：仕入先名を選択
     - 希望納期：希望する納品日
     - 担当者：購買担当者
   - 商品明細を追加

3. **見積依頼を送信する**
   - 「メール送信」ボタンをクリック
   - PDF添付でメール送信
   - ステータスが「送信済み」に変更

**関連画面**: 見積依頼一覧、見積依頼作成、見積依頼詳細

**注意点・Tips**:
- 複数の仕入先に同時に見積依頼を送ることで、価格比較ができます

**次のステップ**: 見積回答の受領、発注への変換

---

### 3.2 発注書を確定するとき

**業務シーン**: 仕入先からの見積回答を受けて、正式に発注する場合

**前提条件**:
- 見積依頼が作成済みであること
- 仕入先から見積回答を受けていること

**やるべきこと**:
1. 見積内容を確認する
2. 発注書に変換する
3. 入庫オペレーションを確認する

**システムでの操作手順**:

1. **見積依頼詳細画面を開く**
   - 「見積依頼一覧」から対象の見積依頼をクリック

2. **発注に変換する**
   - 「発注確定」ボタンをクリック
   - 見積依頼が発注書に変換される
   - 入庫オペレーションが自動作成される

3. **発注内容を確認する**
   - 発注番号が付与される
   - 入庫ステータスが「未受領」として表示される

**関連画面**: 見積依頼詳細、発注書詳細、入庫一覧

**注意点・Tips**:
- 発注確定後は編集がロックされます（アンロック操作で編集可能）

**次のステップ**: 入庫処理、仕入請求書処理

---

### 3.3 仕入先を管理するとき

**業務シーン**: 新規仕入先の登録、既存仕入先情報の更新を行う場合

**前提条件**:
- 仕入先に関する基本情報を把握していること

**やるべきこと**:
1. 仕入先情報を登録/編集する
2. 仕入先価格を設定する
3. 銀行口座情報を登録する

**システムでの操作手順**:

1. **仕入先一覧画面を開く**
   - 「購買」>「仕入先」を選択

2. **仕入先を新規作成する**
   - 「作成」ボタンをクリック
   - 会社名、連絡先、住所を入力
   - 「保存」ボタンで保存

3. **仕入先価格を設定する**
   - 「購買」>「設定」>「仕入先価格」を選択
   - 商品別に仕入先・価格・最小発注数量を設定

**関連画面**: 仕入先一覧、仕入先作成、仕入先価格一覧

**注意点・Tips**:
- 仕入先別にリードタイムを設定できます
- 価格履歴が管理されるため、過去の価格変動を確認できます

**次のステップ**: 見積依頼・発注書の作成

---

## 4. 在庫管理

本章では、入庫、出庫、在庫移動などの在庫オペレーションについて説明します。

### 4.1 商品を入庫するとき

**業務シーン**: 仕入先から商品が届き、在庫に登録する場合

**前提条件**:
- 発注書が確定済みであること（または手動入庫の場合は商品が登録済みであること）

**やるべきこと**:
1. 入庫オペレーションを確認する
2. 入庫数量を入力する
3. ロット/シリアル番号を設定する（該当する場合）
4. 入庫を検証する

**システムでの操作手順**:

1. **入庫一覧画面を開く**
   - 左メニューから「在庫」>「オペレーション」>「入庫」を選択

2. **入庫オペレーションを確認する**
   - 発注から自動作成された入庫オペレーションを開く
   - または「作成」ボタンで手動作成

3. **入庫数量を入力する**
   - 商品明細の「入庫数量」を入力
   - ロット管理商品の場合はロット番号を設定
   - 有効期限がある場合は有効期限を入力

4. **入庫を検証する**
   - 「検証」ボタンをクリック
   - 在庫数量が増加する
   - ステータスが「完了」に変更

**関連画面**: 入庫一覧、入庫作成、入庫詳細、ロット一覧

**注意点・Tips**:
- 検証後は数量の変更ができなくなります
- 部分入庫の場合は、残りの数量で新しい入庫オペレーションが作成されます

**次のステップ**: 在庫確認、仕入請求書処理

---

### 4.2 商品を出庫するとき

**業務シーン**: 受注に基づいて商品を出荷する場合

**前提条件**:
- 受注が確定済みであること
- 在庫が十分にあること

**やるべきこと**:
1. 出庫オペレーションを確認する
2. 出庫数量を入力する
3. ピッキングを完了する
4. 出庫を検証する

**システムでの操作手順**:

1. **出庫一覧画面を開く**
   - 左メニューから「在庫」>「オペレーション」>「出庫」を選択

2. **出庫オペレーションを確認する**
   - 受注から自動作成された出庫オペレーションを開く

3. **出庫処理を行う**
   - 商品明細の「出庫数量」を確認
   - ロケーションから商品をピッキング
   - 必要に応じてパッケージを作成

4. **出庫を検証する**
   - 「検証」ボタンをクリック
   - 在庫数量が減少する
   - ステータスが「完了」に変更

**関連画面**: 出庫一覧、出庫詳細、パッケージ一覧

**注意点・Tips**:
- 在庫が不足している場合、バックオーダーが作成されます
- ロット/シリアル管理商品は、先入先出で出庫されます

**次のステップ**: 配送、請求書発行

---

### 4.3 在庫を移動するとき

**業務シーン**: 倉庫間やロケーション間で在庫を移動する場合

**前提条件**:
- 移動元に在庫があること
- 移動先のロケーションが存在すること

**やるべきこと**:
1. 内部移動オペレーションを作成する
2. 移動元・移動先を設定する
3. 移動数量を入力する
4. 移動を検証する

**システムでの操作手順**:

1. **内部移動一覧画面を開く**
   - 左メニューから「在庫」>「オペレーション」>「内部移動」を選択

2. **内部移動を作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 移動元ロケーション
     - 移動先ロケーション
     - 商品と数量

3. **移動を検証する**
   - 「検証」ボタンをクリック
   - 移動元の在庫が減少し、移動先の在庫が増加

**関連画面**: 内部移動一覧、内部移動作成、内部移動詳細

**注意点・Tips**:
- 複数ステップの移動にも対応しています
- ルート設定により、自動的な移動を設定できます

**次のステップ**: 在庫確認

---

### 4.4 在庫を廃棄するとき

**業務シーン**: 不良品や期限切れ商品を在庫から除外する場合

**前提条件**:
- 廃棄対象の在庫があること

**やるべきこと**:
1. 廃棄オペレーションを作成する
2. 廃棄数量と理由を入力する
3. 廃棄を検証する

**システムでの操作手順**:

1. **廃棄一覧画面を開く**
   - 左メニューから「在庫」>「オペレーション」>「廃棄」を選択

2. **廃棄を作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 商品
     - 数量
     - ロケーション
     - 廃棄理由

3. **廃棄を検証する**
   - 「検証」ボタンをクリック
   - 在庫数量が減少
   - 廃棄ロケーションに移動

**関連画面**: 廃棄一覧、廃棄作成、廃棄詳細

**注意点・Tips**:
- 廃棄理由を記録することで、後で分析できます

**次のステップ**: 在庫レポート確認

---

## 5. 会計管理

本章では、請求書発行、入出金管理、仕訳処理などの会計業務について説明します。

### 5.1 顧客請求書を発行するとき

**業務シーン**: 顧客に対して請求書を発行する場合

**前提条件**:
- 顧客情報が登録済みであること
- （受注連携の場合）受注が確定済みであること

**やるべきこと**:
1. 請求書を作成する
2. 明細を追加する
3. 請求書を確認・転記する
4. 請求書を送信する

**システムでの操作手順**:

1. **請求書一覧画面を開く**
   - 左メニューから「会計」>「顧客」>「請求書」を選択

2. **請求書を作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 顧客
     - 請求日
     - 支払条件
   - 明細を追加（商品・数量・単価）

3. **請求書を確認する**
   - 「確認」ボタンをクリック
   - 会計仕訳が自動作成される
   - 請求書番号が付与される

4. **請求書を送信する**
   - 「メール送信」ボタンでPDF添付メールを送信

**関連画面**: 請求書一覧、請求書作成、請求書詳細

**注意点・Tips**:
- 確認後は編集ができなくなります（修正が必要な場合はキャンセル後に再作成）
- クレジットノートで返金処理が可能です

**次のステップ**: 入金確認

---

### 5.2 入金を処理するとき

**業務シーン**: 顧客からの入金を記録し、請求書と消込を行う場合

**前提条件**:
- 請求書が確認済みであること
- 入金があったこと

**やるべきこと**:
1. 支払を作成する
2. 請求書と消込を行う
3. 支払を確認する

**システムでの操作手順**:

1. **支払一覧画面を開く**
   - 左メニューから「会計」>「支払」を選択

2. **支払を作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 顧客
     - 金額
     - 支払日
     - 仕訳帳（銀行口座等）

3. **請求書と消込を行う**
   - 対象の請求書を選択
   - 消込金額を入力
   - 部分入金の場合は残高が残る

**関連画面**: 支払一覧、支払作成、支払詳細

**注意点・Tips**:
- 部分入金にも対応しています
- 複数の請求書を一括で消込できます

**次のステップ**: 入金レポート確認

---

### 5.3 仕入請求書を処理するとき

**業務シーン**: 仕入先からの請求書を登録し、支払準備を行う場合

**前提条件**:
- 発注書が確定済みであること（または手動登録）
- 仕入先から請求書を受領していること

**やるべきこと**:
1. 仕入請求書を作成する
2. 明細を確認する
3. 請求書を確認・転記する
4. 支払処理を行う

**システムでの操作手順**:

1. **仕入請求書一覧画面を開く**
   - 左メニューから「会計」>「仕入先」>「請求書」を選択

2. **仕入請求書を作成する**
   - 発注書から「請求書作成」で自動作成
   - または「作成」ボタンで手動作成
   - 明細を確認・調整

3. **請求書を確認する**
   - 「確認」ボタンをクリック
   - 会計仕訳が自動作成される

4. **支払を行う**
   - 「支払登録」ボタンで支払を記録

**関連画面**: 仕入請求書一覧、仕入請求書詳細、支払一覧

**注意点・Tips**:
- 発注書との照合を行い、差異がないか確認してください

**次のステップ**: 支払処理

---

### 5.4 勘定科目を管理するとき

**業務シーン**: 勘定科目を追加・編集する場合

**前提条件**:
- 経理担当者または管理者権限があること

**やるべきこと**:
1. 勘定科目を作成/編集する
2. 科目コードと名称を設定する
3. 科目タイプを設定する

**システムでの操作手順**:

1. **勘定科目一覧画面を開く**
   - 左メニューから「会計」>「設定」>「勘定科目」を選択

2. **勘定科目を作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 勘定科目コード
     - 勘定科目名
     - 科目タイプ（資産/負債/収益/費用等）
     - タグ（分類用）

**関連画面**: 勘定科目一覧、勘定科目作成、勘定科目詳細

**注意点・Tips**:
- 使用中の勘定科目は削除できません
- タグで科目をグループ化できます

**次のステップ**: 仕訳帳設定

---

## 6. 人事管理

本章では、従業員管理、部門管理、スキル管理などの人事業務について説明します。

### 6.1 従業員を登録するとき

**業務シーン**: 新入社員を登録する、または既存従業員情報を更新する場合

**前提条件**:
- 部門・職位が登録済みであること

**やるべきこと**:
1. 従業員の基本情報を登録する
2. 部門・職位を設定する
3. 連絡先情報を設定する
4. スキル情報を登録する

**システムでの操作手順**:

1. **従業員一覧画面を開く**
   - 左メニューから「人事」>「従業員」を選択

2. **従業員を作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 氏名
     - 職位
     - 部門
     - マネージャー
     - メールアドレス
     - 電話番号

3. **追加情報を設定する**
   - 「個人情報」タブで住所・緊急連絡先を入力
   - 「職務情報」タブで入社日・雇用形態を設定

**関連画面**: 従業員一覧、従業員作成、従業員詳細

**注意点・Tips**:
- 写真をアップロードして従業員を識別しやすくできます
- ユーザーアカウントと紐付けることで、システムへのログインを許可できます

**次のステップ**: スキル登録、休暇割当

---

### 6.2 従業員スキルを管理するとき

**業務シーン**: 従業員のスキル・資格を登録・更新する場合

**前提条件**:
- 従業員が登録済みであること
- スキルタイプが定義済みであること

**やるべきこと**:
1. 従業員詳細画面を開く
2. スキルを追加する
3. スキルレベルを設定する

**システムでの操作手順**:

1. **従業員詳細画面を開く**
   - 「従業員一覧」から対象の従業員をクリック

2. **スキル管理画面を開く**
   - 「スキル」タブを選択

3. **スキルを追加する**
   - 「追加」ボタンをクリック
   - スキルタイプ・スキル名を選択
   - スキルレベルを設定（初級/中級/上級/エキスパート等）

**関連画面**: 従業員詳細、スキル管理、スキルタイプ一覧

**注意点・Tips**:
- スキルレポートで組織全体のスキル状況を確認できます

**次のステップ**: スキルレポート確認

---

### 6.3 部門を管理するとき

**業務シーン**: 組織構造を設定する、部門を追加・変更する場合

**前提条件**:
- 管理者権限があること

**やるべきこと**:
1. 部門を作成する
2. 親部門を設定する（階層構造）
3. マネージャーを設定する

**システムでの操作手順**:

1. **部署一覧画面を開く**
   - 左メニューから「人事」>「部署」を選択

2. **部署を作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 部署名
     - 親部署（階層構造の場合）
     - マネージャー
     - 会社

**関連画面**: 部署一覧、部署作成、部署詳細

**注意点・Tips**:
- 階層構造で組織図を表現できます
- 部署ごとに従業員を一覧表示できます

**次のステップ**: 従業員の部門配置

---

## 7. 休暇管理

本章では、休暇申請、承認、残高管理などの休暇業務について説明します。

### 7.1 休暇を申請するとき（従業員向け）

**業務シーン**: 有給休暇や特別休暇を申請する場合

**前提条件**:
- 従業員としてシステムに登録されていること
- 休暇タイプが設定されていること

**やるべきこと**:
1. 休暇残高を確認する
2. 休暇申請を作成する
3. 承認を待つ

**システムでの操作手順**:

1. **マイ休暇画面を開く**
   - 左メニューから「休暇」>「マイ休暇」>「休暇申請」を選択

2. **休暇を申請する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 休暇タイプ（有給/病欠/慶弔等）
     - 開始日・終了日
     - 理由（任意）
   - 「送信」ボタンで申請

3. **申請状況を確認する**
   - 「マイ休暇」一覧でステータスを確認
   - 承認待ち/承認/却下のステータスが表示

**関連画面**: マイ休暇一覧、マイ休暇作成、マイ割当一覧

**注意点・Tips**:
- 半日休暇や時間単位の休暇も申請できます（設定による）
- 残高を超える申請はできません

**次のステップ**: 承認結果の確認

---

### 7.2 休暇を承認するとき（マネージャー向け）

**業務シーン**: 部下からの休暇申請を承認または却下する場合

**前提条件**:
- マネージャー権限があること
- 部下から休暇申請があること

**やるべきこと**:
1. 休暇申請を確認する
2. 承認または却下する

**システムでの操作手順**:

1. **休暇管理画面を開く**
   - 左メニューから「休暇」>「管理」>「休暇申請」を選択

2. **申請を確認する**
   - 「承認待ち」のフィルタで未処理の申請を表示
   - 申請内容（期間・理由）を確認

3. **承認または却下する**
   - 「承認」ボタンで承認
   - 「却下」ボタンで却下（理由を入力）
   - 申請者に通知が送信される

**関連画面**: 休暇管理一覧、休暇詳細

**注意点・Tips**:
- 2段階承認を設定している場合は、最終承認者まで承認が必要です
- カレンダービューで休暇状況を確認できます

**次のステップ**: 休暇レポート確認

---

### 7.3 休暇を割り当てるとき（人事担当者向け）

**業務シーン**: 従業員に年次休暇や特別休暇の日数を付与する場合

**前提条件**:
- 人事担当者権限があること
- 休暇タイプが設定されていること

**やるべきこと**:
1. 休暇割当を作成する
2. 従業員・日数を設定する
3. 割当を承認する

**システムでの操作手順**:

1. **割当管理画面を開く**
   - 左メニューから「休暇」>「管理」>「割当」を選択

2. **割当を作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 従業員
     - 休暇タイプ
     - 付与日数
     - 有効期間

3. **割当を承認する**
   - 「承認」ボタンで割当を確定
   - 従業員の休暇残高に反映

**関連画面**: 割当管理一覧、割当作成、割当詳細

**注意点・Tips**:
- 累積プランを使用すると、自動的に休暇が発生します
- 繰越・失効ルールも設定できます

**次のステップ**: 従業員別レポート確認

---

## 8. プロジェクト管理

本章では、プロジェクト作成、タスク管理、工数管理などのプロジェクト業務について説明します。

### 8.1 プロジェクトを作成するとき

**業務シーン**: 新規プロジェクトを立ち上げる場合

**前提条件**:
- プロジェクトマネージャー権限があること

**やるべきこと**:
1. プロジェクトを作成する
2. メンバーを設定する
3. マイルストーンを設定する
4. タスクを作成する

**システムでの操作手順**:

1. **プロジェクト一覧画面を開く**
   - 左メニューから「プロジェクト」>「プロジェクト」を選択

2. **プロジェクトを作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - プロジェクト名
     - 顧客（該当する場合）
     - 開始日・終了日
     - プロジェクトマネージャー

3. **マイルストーンを設定する**
   - 「マイルストーン」タブを選択
   - 中間目標とその期日を設定

**関連画面**: プロジェクト一覧、プロジェクト作成、プロジェクト詳細

**注意点・Tips**:
- テンプレートから作成すると、標準的なタスク構成を素早く設定できます
- お気に入り登録でよく使うプロジェクトにすぐアクセスできます

**次のステップ**: タスク作成

---

### 8.2 タスクを管理するとき

**業務シーン**: プロジェクト内のタスクを作成・進行管理する場合

**前提条件**:
- プロジェクトが作成済みであること

**やるべきこと**:
1. タスクを作成する
2. 担当者・期限を設定する
3. タスクの状態を更新する
4. サブタスクを作成する（必要に応じて）

**システムでの操作手順**:

1. **タスク一覧画面を開く**
   - 左メニューから「プロジェクト」>「タスク」を選択
   - またはプロジェクト詳細から「タスク」タブを選択

2. **タスクを作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - タスク名
     - プロジェクト
     - 担当者
     - 期限
     - 優先度

3. **タスクの状態を更新する**
   - カンバンビューでドラッグ&ドロップ
   - または詳細画面でステータスを変更

4. **サブタスクを追加する**
   - タスク詳細で「サブタスク」タブを選択
   - サブタスクを追加

**関連画面**: タスク一覧、タスク作成、タスク詳細、サブタスク管理

**注意点・Tips**:
- カンバンビューで視覚的にタスクを管理できます
- タスクにタグを付けて分類できます

**次のステップ**: 工数入力

---

### 8.3 工数を入力するとき

**業務シーン**: タスクに対する作業時間を記録する場合

**前提条件**:
- タスクが作成済みであること
- 担当者として割り当てられていること

**やるべきこと**:
1. タイムシートを開く
2. 作業時間を入力する
3. 保存する

**システムでの操作手順**:

1. **タスク詳細画面を開く**
   - 対象のタスクをクリック

2. **タイムシートを入力する**
   - 「タイムシート」タブを選択
   - 「追加」ボタンをクリック
   - 日付・作業時間・作業内容を入力
   - 「保存」ボタンで保存

3. **または専用画面から入力する**
   - 「タイムシート」>「タイムシート」を選択
   - 週次ビューで一括入力

**関連画面**: タスク詳細、タイムシート管理

**注意点・Tips**:
- 週次・月次で集計が自動計算されます
- プロジェクト別・タスク別の工数レポートを確認できます

**次のステップ**: 工数レポート確認

---

## 9. 採用管理

本章では、求人作成、応募者管理、選考プロセスなどの採用業務について説明します。

### 9.1 求人を作成するとき

**業務シーン**: 新しい職位の求人を公開する場合

**前提条件**:
- 職位・部門が登録済みであること

**やるべきこと**:
1. 職位情報を登録する
2. 求人要件を設定する
3. 求人を公開する

**システムでの操作手順**:

1. **職位一覧画面を開く**
   - 左メニューから「採用」>「設定」>「職位」を選択

2. **職位を作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 職位名
     - 部門
     - 雇用形態
     - 必要スキル
     - 募集人数

3. **求人を公開する**
   - 「公開」ステータスに変更
   - 求人サイト連携がある場合は自動公開

**関連画面**: 職位一覧、職位作成、職位詳細

**注意点・Tips**:
- 採用枠管理で募集人数を追跡できます

**次のステップ**: 応募者管理

---

### 9.2 応募者を管理するとき

**業務シーン**: 応募者情報を登録し、選考を進める場合

**前提条件**:
- 求人が作成済みであること

**やるべきこと**:
1. 応募者情報を登録する
2. 選考ステージを進める
3. 面接をスケジュールする

**システムでの操作手順**:

1. **応募者一覧画面を開く**
   - 左メニューから「採用」>「応募者」を選択

2. **応募者を登録する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 氏名
     - メールアドレス
     - 応募職位
     - 履歴書（添付）
     - 応募経路

3. **選考ステージを進める**
   - カンバンビューでドラッグ&ドロップ
   - 書類選考 → 一次面接 → 二次面接 → 内定 等

4. **面接をスケジュールする**
   - 「活動を追加」で面接予定を設定
   - 面接官・日時を設定

**関連画面**: 応募者一覧、応募者詳細、候補者一覧

**注意点・Tips**:
- ステージごとにテンプレートメールを送信できます
- 不採用の場合は不採用理由を記録できます

**次のステップ**: 採用決定または不採用処理

---

### 9.3 採用を決定するとき

**業務シーン**: 応募者を採用し、従業員として登録する場合

**前提条件**:
- 選考プロセスが完了していること

**やるべきこと**:
1. 採用を決定する
2. 従業員として登録する
3. オンボーディングを開始する

**システムでの操作手順**:

1. **応募者詳細画面を開く**
   - 対象の応募者をクリック

2. **採用を決定する**
   - 「採用」ボタンをクリック
   - 採用条件を確認

3. **従業員として登録する**
   - 「従業員作成」で従業員モジュールに連携
   - 応募者情報が自動入力される
   - 追加情報を入力して保存

**関連画面**: 応募者詳細、従業員作成

**注意点・Tips**:
- 候補者プールに保存して、将来の採用に備えることもできます

**次のステップ**: 従業員オンボーディング

---

## 10. 日常業務（補助）

本章では、業務開始時の確認事項やダッシュボード活用など、日常的に行う補助業務について説明します。

### 10.1 業務開始時の確認事項

**業務シーン**: 出勤時にシステムにログインし、本日の業務を確認する場合

**やるべきこと**:
1. システムにログインする
2. ダッシュボードで通知を確認する
3. 本日のタスク・スケジュールを確認する
4. 未対応項目を確認する

**システムでの操作手順**:

1. **ログイン**
   - システムURLにアクセス
   - メールアドレス・パスワードを入力
   - 「ログイン」ボタンをクリック

2. **ダッシュボードの確認**
   - ログイン後、ダッシュボードが表示される
   - 以下を確認：
     - 未読通知
     - 本日のスケジュール
     - 承認待ちタスク
     - アラート

3. **各モジュールの確認**
   - 担当業務に応じたモジュールを確認
   - フィルタ機能で「本日分」「未完了」を絞り込み

**関連画面**: ダッシュボード、各モジュール一覧画面

---

### 10.2 検索・フィルタの活用

**業務シーン**: 大量のデータから必要な情報を素早く見つける場合

**やるべきこと**:
1. 検索機能を使用する
2. フィルタを適用する
3. ビューを保存する

**システムでの操作手順**:

1. **検索を使用する**
   - 各一覧画面の検索ボックスにキーワードを入力
   - 関連するデータが表示される

2. **フィルタを適用する**
   - 「フィルタ」ボタンをクリック
   - 条件を設定（ステータス、日付範囲、担当者等）
   - 「適用」ボタンで絞り込み

3. **ビューを保存する**
   - よく使うフィルタ設定を保存
   - 次回以降ワンクリックで呼び出し可能

**関連画面**: 各モジュール一覧画面

**注意点・Tips**:
- グループ化機能でデータをカテゴリ別に表示できます
- ソート機能で並び順を変更できます

---

## 11. 管理業務（管理者向け）

本章では、システム管理者が行うユーザー管理、権限設定、システム設定などの業務について説明します。

### 11.1 ユーザーを管理するとき

**業務シーン**: 新しいスタッフの追加、退職者の削除、権限変更などを行う場合

**前提条件**:
- システム管理者権限があること

**やるべきこと**:
1. ユーザーを追加/編集/削除する
2. 適切なロールを設定する
3. 会社・チームを設定する

**システムでの操作手順**:

1. **ユーザー一覧画面を開く**
   - 左メニューから「設定」>「ユーザー」を選択

2. **ユーザーを作成する**
   - 「作成」ボタンをクリック
   - 以下の情報を入力：
     - 名前
     - メールアドレス
     - パスワード
     - ロール
     - 会社
   - 「保存」ボタンで保存

3. **招待メールを送信する**
   - 「招待メール送信」で初回ログイン案内を送信

**関連画面**: ユーザー一覧、ユーザー作成、ユーザー編集

**注意点・Tips**:
- ロールで権限を一括管理できます
- 従業員レコードと紐付けることで、休暇申請等が可能になります

---

### 11.2 ロール・権限を管理するとき

**業務シーン**: 新しいロールを作成する、既存ロールの権限を変更する場合

**前提条件**:
- システム管理者権限があること

**やるべきこと**:
1. ロールを作成/編集する
2. リソースごとに権限を設定する
3. ユーザーにロールを割り当てる

**システムでの操作手順**:

1. **ロール一覧画面を開く**
   - 左メニューから「設定」>「ロール」を選択

2. **ロールを作成する**
   - 「作成」ボタンをクリック
   - ロール名を入力
   - 各リソースの権限をチェック：
     - 表示/作成/編集/削除

3. **ユーザーに割り当てる**
   - ユーザー編集画面でロールを選択

**関連画面**: ロール一覧、ロール作成、ロール編集

**注意点・Tips**:
- 最小権限の原則に基づき、必要な権限のみを付与してください
- Super Adminロールは全ての権限を持ちます

---

### 11.3 システム設定を管理するとき

**業務シーン**: システム全体の設定を変更する場合

**設定項目一覧**:

| 設定画面 | 設定内容 |
|---------|---------|
| ユーザー設定 | パスワードポリシー、セッション設定 |
| 通貨設定 | 使用通貨、為替レート |
| 会社設定 | 会社情報、ロゴ、住所 |
| プラグイン管理 | プラグインの有効/無効切り替え |
| カスタムフィールド | 各リソースへのフィールド追加 |

**関連画面**: 設定メニュー配下の各画面

---

### 11.4 プラグインを管理するとき

**業務シーン**: 新しいプラグインをインストールする、不要なプラグインを無効化する場合

**前提条件**:
- システム管理者権限があること

**やるべきこと**:
1. プラグイン一覧を確認する
2. プラグインを有効/無効化する
3. 必要に応じてインストール/アンインストールする

**システムでの操作手順**:

1. **プラグイン一覧画面を開く**
   - 左メニューから「設定」>「プラグイン」を選択

2. **プラグインを有効化する**
   - 対象プラグインの「有効化」ボタンをクリック
   - 依存関係がある場合は自動でインストール

3. **プラグインを無効化する**
   - 対象プラグインの「無効化」ボタンをクリック
   - 関連データに注意

**関連画面**: プラグイン一覧

**注意点・Tips**:
- プラグイン間の依存関係に注意してください
- 無効化してもデータは保持されます

---

## 12. トラブルシューティング

本章では、よくある問題と対処法について説明します。

### 12.1 ログインできない場合

**症状と対処法**:

| 症状 | 原因 | 対処法 |
|------|------|--------|
| 「IDまたはパスワードが違います」 | ID/パスワードの入力誤り | 正しいID/パスワードを入力。Caps Lockを確認 |
| 「アカウントがロックされています」 | 連続ログイン失敗 | システム管理者に解除を依頼 |
| 「タイムアウトしました」 | セッション切れ | ページを更新して再ログイン |
| 画面が真っ白になる | キャッシュの問題 | ブラウザのキャッシュをクリア |

---

### 12.2 画面が表示されない場合

**症状と対処法**:

| 症状 | 原因 | 対処法 |
|------|------|--------|
| 「権限がありません」 | アクセス権限不足 | 管理者に権限付与を依頼 |
| 「ページが見つかりません」 | URLの誤り/削除されたデータ | 正しいURLを確認、一覧に戻る |
| 読み込みが終わらない | ネットワーク遅延 | ネットワーク接続を確認、ページを更新 |
| エラーメッセージが表示される | 入力データの問題 | エラーメッセージを確認し、入力を修正 |

---

### 12.3 データが保存できない場合

**症状と対処法**:

| 症状 | 原因 | 対処法 |
|------|------|--------|
| 「必須項目が入力されていません」 | 必須項目の未入力 | 赤字で表示された項目を入力 |
| 「重複するデータがあります」 | 一意制約違反 | 既存データと異なる値を入力 |
| 「参照先が見つかりません」 | 関連データが削除済み | 有効な参照先を選択 |
| 「ロックされています」 | レコードがロック中 | ロック解除、または別ユーザーの編集完了を待つ |

---

### 12.4 よくある質問（FAQ）

**Q: パスワードを忘れた場合はどうすればよいですか？**
A: ログイン画面の「パスワードをお忘れですか？」リンクからパスワードリセットを行うか、システム管理者に連絡してください。

**Q: 削除したデータを復元できますか？**
A: ソフトデリート対応のデータは「ゴミ箱」から復元可能です。完全削除されたデータは復元できません。

**Q: 複数のブラウザタブで同時に操作できますか？**
A: 可能ですが、同じレコードを同時編集すると競合が発生する可能性があります。保存前にデータを確認してください。

**Q: 表示言語を変更できますか？**
A: ユーザー設定から表示言語を変更できます。ただし、システムで対応している言語に限られます。

**Q: モバイルデバイスで使用できますか？**
A: レスポンシブデザインに対応しているため、スマートフォン・タブレットでも基本操作が可能です。ただし、PCでの操作を推奨します。

---

## 付録. 画面リファレンス

### 管理画面一覧

| カテゴリ | 画面名 | 説明 |
|---------|-------|------|
| 販売 | 見積書一覧 | 見積書の一覧・検索・作成 |
| 販売 | 受注一覧 | 受注の一覧・検索・管理 |
| 販売 | 顧客一覧 | 顧客情報の管理 |
| 購買 | 見積依頼一覧 | RFQの一覧・検索・作成 |
| 購買 | 発注書一覧 | 発注書の一覧・管理 |
| 購買 | 仕入先一覧 | 仕入先情報の管理 |
| 在庫 | 入庫一覧 | 入庫オペレーションの管理 |
| 在庫 | 出庫一覧 | 出庫オペレーションの管理 |
| 在庫 | 商品一覧 | 在庫商品の管理 |
| 会計 | 請求書一覧 | 請求書の発行・管理 |
| 会計 | 支払一覧 | 入出金の管理 |
| 会計 | 勘定科目一覧 | 勘定科目の設定 |
| 人事 | 従業員一覧 | 従業員情報の管理 |
| 人事 | 部署一覧 | 組織構造の管理 |
| 休暇 | マイ休暇 | 休暇申請の作成・確認 |
| 休暇 | 休暇管理 | 休暇申請の承認・管理 |
| プロジェクト | プロジェクト一覧 | プロジェクトの管理 |
| プロジェクト | タスク一覧 | タスクの管理 |
| 採用 | 応募者一覧 | 応募者の管理・選考 |
| 設定 | ユーザー一覧 | ユーザーアカウントの管理 |
| 設定 | ロール一覧 | 権限の設定 |

---

## 改訂履歴

| バージョン | 日付 | 変更内容 |
|-----------|------|---------|
| 1.0 | 2025-12-27 | 初版作成 |
