---
generated_at: 2025-12-27 12:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 45
  claims_without_evidence: 5
confidence_derived: 0.90
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された非機能要件テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・設定ファイル・composer.json等の根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 45 / 50 = 0.90
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：45 / 50、根拠なし：5
- 優先レビュー（高）
  1. **NFT-010 同時ユーザー接続**：具体的な同時接続数の要件定義が未確認
  2. **NFT-013 メモリ使用量**：メモリリークテストの具体的基準が未定義
  3. **NFT-041 クロスブラウザ互換性**：対象ブラウザバージョンの明確な定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `composer.json` - プロジェクト依存関係定義
- E-02: `config/cache.php` - キャッシュ設定（database/redis/memcached対応）
- E-03: `config/queue.php` - キュー設定（database/redis/sqs対応、retry_after: 90秒）
- E-04: `config/session.php` - セッション設定（lifetime: 120分、http_only: true、same_site: lax）
- E-05: `config/auth.php` - 認証設定（web/customerガード、60分トークン有効期限）
- E-06: `config/database.php` - データベース設定（MySQL/PostgreSQL/MariaDB/SQLite/SQL Server対応）
- E-07: `config/logging.php` - ログ設定（stack/single/daily、14日間保持）
- E-08: `config/permission.php` - 権限設定（24時間キャッシュ、display_permission_in_exception: false）
- E-09: `config/filesystems.php` - ストレージ設定（local/public/S3対応）
- E-10: `config/filament-shield.php` - Filament Shield設定（100以上のリソース権限定義）
- E-11: `bootstrap/app.php` - アプリケーション設定（/upヘルスチェック）
- E-12: `app/Providers/Filament/AdminPanelProvider.php` - 管理パネル設定（ミドルウェア一覧）
- E-13: `app/Providers/Filament/CustomerPanelProvider.php` - 顧客パネル設定
- E-14: `database/migrations/0001_01_01_000000_create_users_table.php` - ユーザーテーブル定義（softDeletes）
- E-15: `app/Models/User.php` - Userモデル（passwordハッシュ化キャスト）
- E-16: `plugins/webkul/security/routes/web.php` - 署名付きURL（signedミドルウェア）
- E-17: `plugins/webkul/*/src/Policies/*.php` - 90以上のPolicyクラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャッシュドライバとしてdatabaseがデフォルト | E-02 | ○ |
| C-02 | Redisキャッシュサポート | E-02, E-06 | ○ |
| C-03 | キューのリトライ間隔90秒 | E-03 | ○ |
| C-04 | failed_jobsテーブルで失敗ジョブ管理 | E-03 | ○ |
| C-05 | セッションライフタイム120分 | E-04 | ○ |
| C-06 | Cookie HttpOnly設定有効 | E-04 | ○ |
| C-07 | Cookie SameSite=lax設定 | E-04 | ○ |
| C-08 | web/customerの2つの認証ガード | E-05 | ○ |
| C-09 | パスワードリセットトークン60分有効 | E-05 | ○ |
| C-10 | パスワードリセットスロットル60秒 | E-05 | ○ |
| C-11 | パスワード確認タイムアウト10800秒 | E-05 | ○ |
| C-12 | MySQL/PostgreSQL/MariaDB/SQLite/SQL Server対応 | E-06 | ○ |
| C-13 | 外部キー制約デフォルト有効 | E-06 | ○ |
| C-14 | Redisクラスター対応 | E-06 | ○ |
| C-15 | ログチャンネルstack/single/daily | E-07 | ○ |
| C-16 | ログ保持期間14日 | E-07 | ○ |
| C-17 | Spatie Permission 24時間キャッシュ | E-08 | ○ |
| C-18 | 権限名の例外メッセージ非表示 | E-08 | ○ |
| C-19 | local/public/S3ストレージ対応 | E-09 | ○ |
| C-20 | 100以上のFilament Shieldリソース権限 | E-10 | ○ |
| C-21 | /upヘルスチェックエンドポイント | E-11 | ○ |
| C-22 | VerifyCsrfTokenミドルウェア適用 | E-12 | ○ |
| C-23 | EncryptCookiesミドルウェア適用 | E-12 | ○ |
| C-24 | AuthenticateSessionミドルウェア適用 | E-12 | ○ |
| C-25 | SoftDeletes対応 | E-14 | ○ |
| C-26 | パスワードhashed自動キャスト | E-15 | ○ |
| C-27 | 署名付きURL（signedミドルウェア） | E-16 | ○ |
| C-28 | 90以上のPolicyクラス存在 | E-17 | ○ |
| C-29 | PHP 8.2以上要件 | E-01 | ○ |
| C-30 | Laravel 11.9以上使用 | E-01 | ○ |
| C-31 | Filament 4.1以上使用 | E-01 | ○ |
| C-32 | PHPUnit 11.0.1以上使用 | E-01 | ○ |
| C-33 | Laravel Pint使用 | E-01 | ○ |
| C-34 | Laravel Debugbar使用 | E-01 | ○ |
| C-35 | optimize-autoloader有効 | E-01 | ○ |
| C-36 | Filament Shieldプラグイン使用 | E-01, E-10 | ○ |
| C-37 | メール認証機能 | E-12 | ○ |
| C-38 | パスワードリセット機能 | E-12 | ○ |
| C-39 | 20以上のプラグイン存在 | E-01 | ○ |
| C-40 | ユーザーlanguageカラム存在 | E-14 | ○ |
| C-41 | 時間制限300秒設定 | E-12 | ○ |
| C-42 | 管理パネルと顧客パネル分離 | E-12, E-13 | ○ |
| C-43 | dompdfによるPDF生成 | E-01 | ○ |
| C-44 | セッション暗号化オプション | E-04 | ○ |
| C-45 | バッチジョブ管理 | E-03 | ○ |
| C-46 | 同時接続50ユーザー要件 | **根拠なし** | △ |
| C-47 | メモリリークテスト基準 | **根拠なし** | △ |
| C-48 | 具体的レスポンス時間基準 | **根拠なし** | △ |
| C-49 | 対象ブラウザバージョン定義 | **根拠なし** | △ |
| C-50 | 大量データ件数しきい値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **同時接続数要件**：SLA定義書や性能要件定義書が存在しない
  - 候補：運用設計書 / インフラ設計書 / SLA文書
- **レスポンス時間基準**：具体的なレスポンス時間のSLA定義がない
  - 候補：性能要件定義書 / 顧客契約書
- **対象ブラウザ定義**：サポート対象ブラウザ・バージョンの明記がない
  - 候補：動作環境定義書 / システム要件書
- **大量データ基準**：「大量」の定義が不明確
  - 候補：性能テスト仕様書 / 負荷テスト計画書

## 5) リスクフラグ（レビュー観点）
- **2（高リスク）**: NFT-010, NFT-013 - 負荷テスト・ストレステストの合格基準が推定値
- **1（中リスク）**: NFT-001〜NFT-004 - レスポンス時間基準は業界標準を適用
- **0（低リスク）**: セキュリティ関連テストケース - 設定ファイルから明確に根拠確認

## 6) レビュアーチェックリスト（最小）
- [ ] 同時接続数要件（NFT-010）の合格基準が運用要件と整合しているか確認
- [ ] レスポンス時間基準（NFT-001〜NFT-004）が顧客要件と一致しているか確認
- [ ] 対象ブラウザ・バージョン（NFT-041）の定義を追加する必要があるか検討
- [ ] 大量データの定義（NFT-005）を具体的なレコード数で定義する必要があるか検討
- [ ] メモリリーク判定基準（NFT-013）の具体的な数値目標を設定する必要があるか検討
- [ ] 各セキュリティテストケース（NFT-015〜NFT-030）のテスト手順が明確か確認
- [ ] キャッシュ・キュー関連テスト（NFT-006〜NFT-009）の環境依存事項を確認
