---
generated_at: 2025-12-27 12:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された非機能要件定義書の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・設定ファイル・既存ドキュメントなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **同時接続数100ユーザー**：負荷テスト未実施のため推定値
  2. **秒間リクエスト50 req/s**：ベンチマーク未実施のため推定値
  3. **稼働率99.5%**：SLA未定義のため推奨値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `composer.json` - Laravel 11.x, FilamentPHP 4.x, PHP 8.2 依存関係
- E-02: `.env.example` - 環境変数設定のデフォルト値
- E-03: `config/cache.php` - キャッシュドライバ設定
- E-04: `config/session.php` - セッション管理設定
- E-05: `config/auth.php` - 認証設定
- E-06: `config/permission.php` - 権限管理設定
- E-07: `config/queue.php` - キュー処理設定
- E-08: `config/logging.php` - ログ設定
- E-09: `config/database.php` - データベース接続設定
- E-10: `config/app.php` - アプリケーション基本設定
- E-11: `config/filament.php` - Filament設定
- E-12: `config/filament-shield.php` - 権限Shield設定
- E-13: `config/mail.php` - メール配信設定
- E-14: `config/filesystems.php` - ファイルストレージ設定
- E-15: `app/Providers/Filament/AdminPanelProvider.php` - 管理画面設定
- E-16: `app/Models/User.php` - ユーザーモデル
- E-17: `plugins/webkul/security/src/Models/User.php` - セキュリティユーザーモデル
- E-18: `bootstrap/app.php` - アプリケーションブートストラップ
- E-19: `phpunit.xml` - テスト設定
- E-20: `README.md` - プロジェクト概要
- E-21: `plugins/webkul/support/src/SupportServiceProvider.php` - サポートサービスプロバイダ
- E-22: `plugins/webkul/support/src/PackageServiceProvider.php` - パッケージサービスプロバイダ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Laravel 11.x ベースのフレームワーク | E-01 | ○ |
| C-02 | FilamentPHP 4.x 管理画面 | E-01 | ○ |
| C-03 | PHP 8.2 以上が必要 | E-01 | ○ |
| C-04 | キャッシュドライバはデフォルトでdatabase | E-03 | ○ |
| C-05 | セッション有効期限は120分 | E-04 | ○ |
| C-06 | パスワードリセットトークン有効期限60分 | E-05 | ○ |
| C-07 | パスワードスロットル60秒 | E-05 | ○ |
| C-08 | 権限キャッシュ有効期限24時間 | E-06 | ○ |
| C-09 | キュードライバはデフォルトでdatabase | E-07 | ○ |
| C-10 | ジョブリトライ90秒後 | E-07 | ○ |
| C-11 | 失敗ジョブはdatabase-uuidsで管理 | E-07 | ○ |
| C-12 | ログドライバはstack（single） | E-08 | ○ |
| C-13 | 日次ログ保持期間14日 | E-08 | ○ |
| C-14 | SQLiteがデフォルトDB | E-09 | ○ |
| C-15 | MySQL/MariaDB/PostgreSQL/SQL Server対応 | E-09 | ○ |
| C-16 | Redis接続設定対応 | E-09 | ○ |
| C-17 | 暗号化アルゴリズムAES-256-CBC | E-10 | ○ |
| C-18 | デフォルトタイムゾーンUTC | E-10 | ○ |
| C-19 | メンテナンスドライバはfile | E-10 | ○ |
| C-20 | Livewireローディング遅延200ms | E-11 | ○ |
| C-21 | Spatie/laravel-permissionによる権限管理 | E-06, E-12 | ○ |
| C-22 | Filament Shieldによるロール管理 | E-12 | ○ |
| C-23 | SMTP/SES/Postmark等メール配信対応 | E-13 | ○ |
| C-24 | S3ストレージ対応 | E-14 | ○ |
| C-25 | CSRFミドルウェア適用 | E-15 | ○ |
| C-26 | セッション認証ミドルウェア適用 | E-15 | ○ |
| C-27 | Cookie暗号化適用 | E-15 | ○ |
| C-28 | set_time_limit(300)設定 | E-15 | ○ |
| C-29 | パスワードはhashedでキャスト | E-16 | ○ |
| C-30 | ソフトデリート対応 | E-17 | ○ |
| C-31 | HasRolesトレイト使用 | E-17 | ○ |
| C-32 | ヘルスチェックエンドポイント/up | E-18 | ○ |
| C-33 | PHPUnit 11.x テストフレームワーク | E-01, E-19 | ○ |
| C-34 | bcrypt 12ラウンド | E-02 | ○ |
| C-35 | セッションドライバはデフォルトでdatabase | E-02, E-04 | ○ |
| C-36 | HTTP Only Cookie有効 | E-04 | ○ |
| C-37 | Same-Site Cookie lax | E-04 | ○ |
| C-38 | メール認証対応 | E-15 | ○ |
| C-39 | パスワードリセット対応 | E-15 | ○ |
| C-40 | 24種類のプラグイン対応 | E-20, E-21, E-22 | ○ |
| C-41 | CLI/GUIでプラグイン管理 | E-20 | ○ |
| C-42 | パスワード確認タイムアウト10800秒 | E-05 | ○ |
| C-43 | 同時接続数100ユーザー | **根拠なし** | △ |
| C-44 | 秒間リクエスト50 req/s | **根拠なし** | △ |
| C-45 | 稼働率99.5% | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **同時接続数・スループット目標値**
  - 負荷テスト結果が存在しないため、一般的なLaravelアプリケーションの目安値を記載
  - 候補：JMeter / k6 / Laravel Octane ベンチマーク実施

- **稼働率・RTO/RPO目標値**
  - SLA（Service Level Agreement）ドキュメントが存在しない
  - 候補：運用設計書 / SLA定義書 / インフラ設計書

- **レスポンスタイム目標値**
  - APM（Application Performance Monitoring）データが存在しない
  - 候補：New Relic / Datadog / Laravel Telescope

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 設定ファイルから直接読み取った値（認証設定、キャッシュ設定等）
- **1（中リスク）**: 推奨値として記載したセキュリティ設定（本番環境での検証が必要）
- **2（高リスク）**: 負荷テスト未実施のパフォーマンス目標値（要実測）

| リスク | 対象 | 対応推奨 |
| --- | --- | --- |
| 2 | 同時接続数・スループット | 負荷テスト実施 |
| 2 | 稼働率・RTO/RPO | SLA定義・運用設計 |
| 1 | パフォーマンス最適化設定 | 本番環境での検証 |
| 0 | 認証・セッション設定 | 設定値確認のみ |

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス目標値（同時接続数、スループット）は実測に基づく値に更新が必要か確認
- [ ] 稼働率・RTO/RPO目標はビジネス要件と整合しているか確認
- [ ] 本番環境でのセキュリティ設定（APP_DEBUG=false等）を確認
- [ ] Redis/Memcached等のキャッシュバックエンドへの変更要否を確認
- [ ] SSL/TLS設定（SESSION_SECURE_COOKIE）の適用状況を確認
- [ ] バックアップ運用ポリシーが定義されているか確認
- [ ] 監視・アラート設定が実装されているか確認
