# 非機能要件定義書

## 概要

本ドキュメントは、AureusERP（Laravel / FilamentPHP ベースのオープンソースERPシステム）の非機能要件を定義するものです。プロジェクトコードベースの解析結果に基づき、性能、可用性、セキュリティ、拡張性、保守性、運用・監視の各観点から要件を明確化します。

## システム概要

| 項目 | 内容 |
| --- | --- |
| システム名 | AureusERP |
| フレームワーク | Laravel 11.x |
| 管理画面 | FilamentPHP 4.x |
| PHP バージョン | 8.2 以上 |
| 対応データベース | MySQL 8.0+, SQLite, PostgreSQL, SQL Server |
| ライセンス | MIT |

---

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| 画面表示 | 3秒以内 | 管理画面（Filament）の表示時間 |
| API応答 | 1秒以内 | 通常のCRUD操作 |
| レポート生成 | 10秒以内 | PDF帳票・分析レポート |
| バッチ処理 | 処理量に依存 | キュー経由で非同期処理 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時接続数 | 100ユーザー | デフォルト構成での目安 |
| 秒間リクエスト数 | 50 req/s | Webサーバー設定に依存 |

### キャッシュ設定

| キャッシュ種別 | ドライバ | 有効期限 | 根拠ファイル |
| --- | --- | --- | --- |
| アプリケーションキャッシュ | database（デフォルト） | 設定による | `config/cache.php` |
| セッションキャッシュ | database | 120分 | `config/session.php` |
| 権限キャッシュ | default | 24時間 | `config/permission.php` |
| Filamentコンポーネント | file | 無期限 | `config/filament.php` |

**対応キャッシュドライバ:**
- array, database, file, memcached, redis, dynamodb, octane

### タイムアウト設定

| 項目 | 設定値 | 根拠ファイル |
| --- | --- | --- |
| Webリクエスト制限時間 | 300秒 | `AdminPanelProvider.php` (set_time_limit) |
| キュージョブリトライ | 90秒後 | `config/queue.php` |
| Livewireローディング遅延 | 200ms（default） | `config/filament.php` |

---

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | 99.5% | 年間約44時間以内の計画外停止 |
| 計画停止時間 | 月4時間以内 | メンテナンスウィンドウ |
| 障害復旧時間（RTO） | 4時間以内 | データベースバックアップからの復元 |
| 目標復旧時点（RPO） | 1時間以内 | 定期バックアップ間隔に依存 |

### メンテナンスモード

| 項目 | 設定 | 根拠ファイル |
| --- | --- | --- |
| メンテナンスドライバ | file | `config/app.php` |
| メンテナンスストア | database | 複数サーバー間で同期可能 |

### ヘルスチェック

| エンドポイント | 用途 | 根拠ファイル |
| --- | --- | --- |
| `/up` | アプリケーション稼働状態確認 | `bootstrap/app.php` |

### キュー処理

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| キュードライバ | database | デフォルト設定 |
| 失敗ジョブ管理 | database-uuids | `config/queue.php` |
| ジョブバッチ処理 | 対応 | `config/queue.php` |

---

## セキュリティ要件

### 認証・認可

| 項目 | 実装内容 | 根拠ファイル |
| --- | --- | --- |
| 認証方式 | セッションベース認証 | `config/auth.php` |
| パスワードハッシュ | bcrypt（12ラウンド） | `.env.example` |
| パスワードリセット | トークン有効期限60分、スロットル60秒 | `config/auth.php` |
| パスワード確認タイムアウト | 10,800秒（3時間） | `config/auth.php` |
| メール認証 | 対応 | `AdminPanelProvider.php` |

### 権限管理

| 項目 | 実装内容 | 根拠ファイル |
| --- | --- | --- |
| 権限管理 | Spatie/laravel-permission | `config/permission.php` |
| ロール管理 | Filament Shield | `config/filament-shield.php` |
| ユーザーモデル | `Webkul\Security\Models\User` | `config/filament-shield.php` |
| ソフトデリート | 対応 | `plugins/webkul/security/src/Models/User.php` |

**対応権限操作:**
- view_any, view, create, update, delete, restore, delete_any, force_delete, force_delete_any, restore_any, reorder

### セッション管理

| 項目 | 設定値 | 根拠ファイル |
| --- | --- | --- |
| セッションドライバ | database | `config/session.php` |
| セッション有効期限 | 120分 | `config/session.php` |
| セッション暗号化 | 無効（オプション） | `config/session.php` |
| HTTP Only Cookie | 有効 | `config/session.php` |
| Same-Site Cookie | lax | `config/session.php` |

### データ暗号化

| 項目 | 実装内容 | 根拠ファイル |
| --- | --- | --- |
| 暗号化アルゴリズム | AES-256-CBC | `config/app.php` |
| パスワードハッシュ | hashed（自動） | `app/Models/User.php` |
| メール暗号化 | TLS対応 | `config/mail.php` |

### CSRF保護

| 項目 | 実装内容 | 根拠ファイル |
| --- | --- | --- |
| CSRFミドルウェア | VerifyCsrfToken | `AdminPanelProvider.php` |
| セッション認証 | AuthenticateSession | `AdminPanelProvider.php` |
| Cookie暗号化 | EncryptCookies | `AdminPanelProvider.php` |

---

## 拡張性要件

### モジュラーアーキテクチャ

| 項目 | 実装内容 | 根拠ファイル |
| --- | --- | --- |
| プラグインシステム | 対応 | `plugins/webkul/plugin-manager/` |
| プラグイン管理 | CLI/GUI | `php artisan <plugin>:install` |
| 依存関係管理 | 自動検出 | プラグイン間依存性を管理 |

### コアプラグイン（システム標準）

| プラグイン名 | 説明 |
| --- | --- |
| Analytics | ビジネスインテリジェンス・レポーティング |
| Chatter | 社内コミュニケーション |
| Fields | カスタムフィールド管理 |
| Security | ロールベースアクセス制御・認証 |
| Support | コアサポート機能 |
| Table Views | データ表示カスタマイズ |

### インストール可能プラグイン

| プラグイン名 | 説明 |
| --- | --- |
| Accounts | 会計・財務レポート |
| Blogs | ブログ管理 |
| Contacts | 顧客・ベンダー連絡先管理 |
| Employees | 従業員管理 |
| Inventories | 在庫・倉庫管理 |
| Invoices | 請求書管理 |
| Partners | パートナー関係管理 |
| Payments | 支払い処理・追跡 |
| Products | 製品カタログ管理 |
| Projects | プロジェクト管理 |
| Purchases | 調達・発注管理 |
| Recruitments | 採用管理 |
| Sales | 営業パイプライン管理 |
| Time-off | 休暇管理 |
| Timesheets | 勤怠管理 |
| Website | 顧客向けWebサイト |

### データベース対応

| データベース | 対応状況 | 備考 |
| --- | --- | --- |
| SQLite | 対応（デフォルト） | 開発・小規模向け |
| MySQL 8.0+ | 対応 | SSL接続対応 |
| MariaDB | 対応 | MySQL互換 |
| PostgreSQL | 対応 | スキーマ対応 |
| SQL Server | 対応 | エンタープライズ向け |

### スケーリング対応

| 項目 | 対応状況 | 備考 |
| --- | --- | --- |
| 水平スケーリング | 対応 | Redis/Memcached セッション・キャッシュ |
| Redisクラスタ | 対応 | `config/database.php` |
| AWS統合 | 対応 | S3, SQS, DynamoDB |

---

## 保守性要件

### ログ管理

| 項目 | 設定 | 根拠ファイル |
| --- | --- | --- |
| ログドライバ | stack（single） | `config/logging.php` |
| ログレベル | debug（デフォルト） | `config/logging.php` |
| 日次ログ保持期間 | 14日 | `config/logging.php` |
| 非推奨警告ログ | null | `config/logging.php` |

**対応ログチャンネル:**
- single, daily, slack, papertrail, stderr, syslog, errorlog, null, emergency

### デバッグ機能

| 項目 | 設定 | 根拠ファイル |
| --- | --- | --- |
| デバッグバー | 対応（開発時） | `config/debugbar.php` |
| Laravel Pail | 対応 | `composer.json` |
| Telescope | 環境変数で制御 | `phpunit.xml` |

### テスト環境

| 項目 | 設定 | 根拠ファイル |
| --- | --- | --- |
| テストフレームワーク | PHPUnit 11.x | `composer.json` |
| テストスイート | Unit, Feature | `phpunit.xml` |
| テストキャッシュ | array | `phpunit.xml` |
| テストキュー | sync | `phpunit.xml` |

### コード品質

| 項目 | ツール | 根拠ファイル |
| --- | --- | --- |
| コードスタイル | Laravel Pint | `pint.json` |
| 静的解析 | - | - |
| ファクトリー | Faker | `composer.json` |

---

## 運用・監視要件

### 監視項目

| 項目 | 推奨設定 | 備考 |
| --- | --- | --- |
| アプリケーションログ | 日次ローテーション | storage/logs/ |
| エラー通知 | Slack連携対応 | `config/logging.php` |
| 失敗ジョブ監視 | データベース記録 | `config/queue.php` |
| パフォーマンス監視 | Pulse対応 | `phpunit.xml` |

### バックアップ

| 項目 | 推奨設定 | 備考 |
| --- | --- | --- |
| データベースバックアップ | 日次 | mysqldump等 |
| ファイルバックアップ | 日次 | storage/app/ |
| 設定バックアップ | 変更時 | .env ファイル |

### ファイルストレージ

| ディスク | 用途 | 根拠ファイル |
| --- | --- | --- |
| local | プライベートファイル | `config/filesystems.php` |
| public | 公開ファイル | `config/filesystems.php` |
| s3 | クラウドストレージ | `config/filesystems.php` |

### メール配信

| 項目 | 対応ドライバ | 根拠ファイル |
| --- | --- | --- |
| メール送信 | SMTP, SES, Postmark, Resend, Log | `config/mail.php` |
| フェイルオーバー | 対応 | `config/mail.php` |
| ラウンドロビン | 対応 | `config/mail.php` |

---

## 互換性要件

### ブラウザ対応

| ブラウザ | 対応状況 |
| --- | --- |
| Google Chrome | 対応（最新版） |
| Mozilla Firefox | 対応（最新版） |
| Microsoft Edge | 対応（最新版） |
| Safari | 対応（最新版） |

### サーバー要件

| 項目 | 要件 |
| --- | --- |
| PHP | 8.2以上 |
| Webサーバー | Apache / Nginx |
| PHP拡張 | OpenSSL, PDO, Mbstring, Tokenizer, XML, Ctype, JSON |
| Node.js | 最新安定版 |
| Composer | 最新版 |

### 国際化対応

| 項目 | 設定 | 根拠ファイル |
| --- | --- | --- |
| デフォルトロケール | en | `config/app.php` |
| フォールバックロケール | en | `config/app.php` |
| タイムゾーン | UTC | `config/app.php` |
| 通貨 | USD | `config/app.php` |

---

## 備考

### 環境変数による設定

本システムは環境変数（`.env`ファイル）による柔軟な設定変更に対応しています。本番環境では以下の設定を推奨します：

- `APP_ENV=production`
- `APP_DEBUG=false`
- `CACHE_STORE=redis`
- `SESSION_DRIVER=redis`
- `QUEUE_CONNECTION=redis`

### パフォーマンス最適化

- Composerオートローダーの最適化：`composer install --optimize-autoloader --no-dev`
- 設定キャッシュ：`php artisan config:cache`
- ルートキャッシュ：`php artisan route:cache`
- ビューキャッシュ：`php artisan view:cache`
- Filamentコンポーネントキャッシュ：`php artisan filament:cache-components`

### セキュリティ推奨事項

- 本番環境では`APP_DEBUG=false`を設定
- HTTPSの使用を推奨（`SESSION_SECURE_COOKIE=true`）
- 強力なパスワードポリシーの適用
- 定期的なセキュリティアップデートの適用
