---
generated_at: 2026-01-27 18:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **RequestContextプール数（2,048）**：コード内のコメントベースの記述
  2. **バックプレッシャー戻り値（-1）**：WebSocket実装の詳細確認が必要
  3. **デフォルトreusePort挙動**：環境変数による条件分岐の完全な検証
  4. **最大ペイロードサイズのデフォルト値**：明示的な定義箇所の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/api/server.zig` - HTTPサーバーコア実装
- E-02: `src/bun.js/api/server/ServerConfig.zig` - サーバー設定構造体
- E-03: `src/bun.js/api/server.classes.ts` - JSクラス定義
- E-04: `src/bun.js/api/server/ServerWebSocket.zig` - WebSocket実装
- E-05: `src/bun.js/api/server/RequestContext.zig` - リクエストコンテキスト
- E-06: `src/bun.js/api/BunObject.zig` - Bunグローバルオブジェクト定義
- E-07: `src/js/node/http.ts` - Node.js互換HTTP実装
- E-08: `src/http.zig` - HTTPクライアント実装
- E-09: `src/js/internal/http.ts` - HTTP内部ユーティリティ
- E-10: `docs/code-to-docs/機能設計書/55-Bun.serve.md` - 既存機能設計書

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Bun.serveはuWebSocketsベースで実装 | E-01, E-10 | ○ |
| C-02 | デフォルトポートは3000 | E-02 (line 395) | ○ |
| C-03 | idleTimeoutのデフォルトは10秒 | E-02 (line 26) | ○ |
| C-04 | idleTimeoutの範囲は0-255 | E-02, E-01 (line 681-682) | ○ |
| C-05 | maxRequestBodySizeのデフォルトは128MB | E-02 (line 34) | ○ |
| C-06 | fetchオプションは必須 | E-02 (line 379) | ○ |
| C-07 | server.stop()メソッドが存在 | E-03 (line 38-39), E-01 (line 568) | ○ |
| C-08 | server.fetch()メソッドが存在 | E-03 (line 8-10), E-01 (line 578) | ○ |
| C-09 | server.upgrade()メソッドが存在 | E-03 (line 11-14), E-01 (line 572) | ○ |
| C-10 | server.publish()メソッドが存在 | E-03 (line 15-18), E-01 (line 574) | ○ |
| C-11 | server.reload()メソッドが存在 | E-03 (line 23-26), E-01 (line 576) | ○ |
| C-12 | server.timeout()メソッドが存在 | E-03 (line 44-47), E-01 (line 582) | ○ |
| C-13 | server.portプロパティが存在 | E-03 (line 48-50) | ○ |
| C-14 | server.hostnameプロパティが存在 | E-03 (line 67-70) | ○ |
| C-15 | server.urlプロパティが存在 | E-03 (line 75-78) | ○ |
| C-16 | server.pendingRequestsプロパティが存在 | E-03 (line 55-57) | ○ |
| C-17 | WebSocket.send()メソッドが存在 | E-03 (line 214-216), E-04 | ○ |
| C-18 | WebSocket.subscribe()メソッドが存在 | E-03 (line 303-306), E-04 | ○ |
| C-19 | WebSocket.unsubscribe()メソッドが存在 | E-03 (line 307-310), E-04 | ○ |
| C-20 | WebSocket.close()メソッドが存在 | E-03 (line 268-272), E-04 | ○ |
| C-21 | WebSocket.terminate()メソッドが存在 | E-03 (line 273-277), E-04 | ○ |
| C-22 | WebSocket.ping()/pong()メソッドが存在 | E-03 (line 260-267), E-04 | ○ |
| C-23 | WebSocket.dataプロパティが存在 | E-03 (line 295-299), E-04 | ○ |
| C-24 | WebSocket.readyStateプロパティが存在 | E-03 (line 300-302), E-04 | ○ |
| C-25 | WebSocket.remoteAddressプロパティが存在 | E-03 (line 318-321), E-04 | ○ |
| C-26 | WebSocket.binaryTypeプロパティが存在 | E-03 (line 287-290), E-04 | ○ |
| C-27 | http.createServer()が存在 | E-07 (line 13-15) | ○ |
| C-28 | http.request()が存在 | E-07 (line 24-26) | ○ |
| C-29 | http.get()が存在 | E-07 (line 35-39) | ○ |
| C-30 | ルートパラメータ名は数字で始められない | E-02 (line 341-346) | ○ |
| C-31 | 重複ルートパラメータ名は未サポート | E-02 (line 349-355) | ○ |
| C-32 | routes/staticオプションでルート定義可能 | E-02 (line 364-375) | ○ |
| C-33 | HTTPメソッド別ハンドラー定義可能 | E-02 (line 572-599) | ○ |
| C-34 | サポートHTTPメソッド（GET,POST,PUT等） | E-02 (line 572-582) | ○ |
| C-35 | 環境変数BUN_PORT/PORT/NODE_PORTでポート設定 | E-02 (line 424-440) | ○ |
| C-36 | NODE_ENV=productionで本番モード | E-02 (line 416-418) | ○ |
| C-37 | NODE_UNIQUE_IDでreusePort自動有効化 | E-02 (line 405-406) | ○ |
| C-38 | RequestContextプール数は2,048 | E-05 (line 31) | △ |
| C-39 | send()のバックプレッシャー戻り値は-1 | **根拠なし** | △ |
| C-40 | WebSocket最大ペイロードサイズのデフォルト | **根拠なし** | △ |
| C-41 | perMessageDeflateオプション | E-03, E-04 | ○ |
| C-42 | development.hmrtrue/falseの挙動 | E-02 (line 66-77) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-38**: RequestContextプール数2,048はコード内コメントに記載あり（E-05 line 29-31）だが、実際の動作確認が必要
  - 候補：実行時テスト / メモリプロファイリング / 開発者確認
- **C-39**: WebSocket send()のバックプレッシャー時の戻り値-1は一般的なWebSocket実装の慣習だが、Bun固有の実装確認が必要
  - 候補：uWebSocketsドキュメント / 実装詳細確認
- **C-40**: WebSocket最大ペイロードサイズのデフォルト値の明示的な定義箇所が未特定
  - 候補：uWebSocketsのデフォルト値 / ServerWebSocket.zigの詳細調査
- **C-41**: perMessageDeflateの詳細オプション構造はuWebSocketsの仕様に依存
  - 候補：uWebSocketsドキュメント参照

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的なAPI仕様（メソッド名、プロパティ名、パラメータ名）- コード定義から直接確認可能
- **1 (中リスク)**: デフォルト値・制限値 - コードから確認可能だが変更される可能性あり
- **2 (高リスク)**: なし

## 6) レビュアーチェックリスト（最小）
- [ ] WebSocket send()のバックプレッシャー戻り値の実際の挙動を確認
- [ ] RequestContextプール数2,048の実際のメモリ使用量を確認
- [ ] 本番環境でのデフォルト設定値（特にreusePort）の妥当性を確認
- [ ] uWebSocketsの最新バージョンとの互換性を確認
- [ ] TLS設定オプションの完全性を確認（証明書形式、暗号スイート等）
