# Bun

## 概要

Bunは、速度に最適化されたオールインワンのJavaScript/TypeScriptランタイム及びツールキットです。バンドラー、テストランナー、Node.js互換のパッケージマネージャーを単一の実行ファイル`bun`として提供します。主にZig言語で記述され、C++によるJavaScriptCore統合を行い、WebKitのJavaScriptCoreエンジンを基盤としています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| JavaScriptランタイム | Node.jsの高速な代替として機能し、TypeScript/JSXをネイティブサポート |
| パッケージマネージャー | npm互換の高速パッケージマネージャー（bun install, bun add等） |
| バンドラー | 高度なTree-shaking、CSS/HTML処理を備えたJavaScriptバンドラー |
| テストランナー | Jest互換のテストフレームワーク（bun test） |
| HTTPサーバー | 高性能なHTTPサーバー実装（Bun.serve） |
| WebSocket | WebSocketサーバー/クライアントの完全サポート |
| SQLite | 組み込みSQLiteデータベースサポート（bun:sqlite） |
| PostgreSQL/Redis | データベース接続サポート（Bun.sql, Bun.redis） |
| S3クライアント | AWS S3互換ストレージクライアント（Bun.s3） |
| FFI | 外部関数インターフェース（bun:ffi） |
| シェル | クロスプラットフォームシェル実装（$ Shell） |

## 技術スタック

### コア

- 言語: Zig (コアランタイム)、C++ (JavaScriptCoreバインディング)、TypeScript (組み込みモジュール)
- JavaScriptエンジン: WebKit JavaScriptCore
- ビルドシステム: CMake、Ninja
- パッケージマネージャー: Bun自身

### 主要ライブラリ

- JavaScriptCore (WebKit) - JavaScriptエンジン
- LLVM 19 - コンパイラツールチェーン
- BoringSSL - 暗号化ライブラリ
- zlib/brotli - 圧縮ライブラリ
- libarchive - アーカイブ処理
- libuv - 非同期I/O（Windows互換レイヤー）

## ディレクトリ構成

```
bun-main/
├── src/                    # ソースコード
│   ├── bun.zig            # メインエントリーポイント
│   ├── cli.zig            # CLIコマンド処理
│   ├── js_parser.zig      # JavaScriptパーサー
│   ├── js_lexer.zig       # JavaScriptレキサー
│   ├── js_printer.zig     # JavaScriptプリンター
│   ├── transpiler.zig     # トランスパイラー
│   ├── bun.js/            # JavaScriptランタイム
│   │   ├── api/           # Bun固有API（server, FFI, crypto等）
│   │   ├── bindings/      # JavaScriptCoreバインディング（C++）
│   │   ├── node/          # Node.js互換レイヤー
│   │   ├── webcore/       # Web API実装（fetch, streams等）
│   │   └── event_loop/    # イベントループ管理
│   ├── js/                # 組み込みJavaScriptモジュール
│   │   ├── node/          # Node.js互換モジュール（node:fs等）
│   │   ├── bun/           # Bun固有モジュール（bun:ffi等）
│   │   ├── thirdparty/    # サードパーティモジュール置換（ws等）
│   │   ├── internal/      # 内部モジュール
│   │   └── builtins/      # コアビルトイン（streams, console等）
│   ├── bundler/           # JavaScriptバンドラー
│   ├── install/           # パッケージマネージャー
│   ├── shell/             # クロスプラットフォームシェル
│   ├── css/               # CSSパーサー/プロセッサ
│   ├── http/              # HTTPクライアント/WebSocket
│   ├── sql/               # SQLデータベース統合
│   ├── resolver/          # モジュール解決システム
│   ├── allocators/        # カスタムメモリアロケータ
│   ├── codegen/           # コード生成スクリプト
│   └── bake/              # サーバーサイドレンダリングフレームワーク
├── test/                   # テストスイート
│   ├── js/bun/            # Bun固有APIテスト
│   ├── js/node/           # Node.js互換テスト
│   ├── js/web/            # Web APIテスト
│   ├── cli/               # CLIコマンドテスト
│   ├── bundler/           # バンドラーテスト
│   ├── integration/       # 統合テスト
│   ├── napi/              # N-API互換テスト
│   └── v8/                # V8 C++ API互換テスト
├── packages/              # パッケージ（bun-types等）
├── scripts/               # ビルド/ユーティリティスクリプト
├── cmake/                 # CMake設定
├── bench/                 # ベンチマーク
├── docs/                  # ドキュメント
├── vendor/                # サードパーティ依存関係
├── build.zig              # Zigビルド設定
├── CMakeLists.txt         # CMakeルート設定
├── package.json           # npm設定
└── bun.lock               # Bunロックファイル
```

## セットアップ

### 必要条件

- 約10GBの空きディスク容量
- LLVM 19（Clang含む）
- Bun（リリースビルド）- ビルドスクリプト実行用
- Go言語
- Rust
- Ruby
- CMake
- Ninja

### OS別依存関係インストール

**macOS (Homebrew):**
```bash
brew install automake ccache cmake coreutils gnu-sed go icu4c libiconv libtool ninja pkg-config rust ruby
brew install llvm@19
```

**Ubuntu/Debian:**
```bash
sudo apt install curl wget lsb-release software-properties-common cargo cmake git golang libtool ninja-build pkg-config rustc ruby-full xz-utils
wget https://apt.llvm.org/llvm.sh -O - | sudo bash -s -- 19 all
```

**Nix:**
```bash
nix develop
export CMAKE_SYSTEM_PROCESSOR=$(uname -m)
```

### ビルド手順

```bash
# リポジトリをクローン
git clone https://github.com/oven-sh/bun.git
cd bun

# デバッグビルド
bun run build

# バイナリ確認
./build/debug/bun-debug --version

# リリースビルド
bun run build:release
```

## 開発

### ビルドコマンド

| コマンド | 説明 |
| --- | --- |
| `bun bd` | デバッグビルドをコンパイルして実行 |
| `bun bd test <file>` | デバッグビルドでテスト実行 |
| `bun run build:release` | リリースビルド |
| `bun run build:asan` | AddressSanitizer有効ビルド |

### テスト実行

```bash
# 単一テストファイル
bun bd test test/js/bun/http/serve.test.ts

# フィルター付き
bun bd test test/js/bun/http/serve.test.ts -t "should handle"
```

### コードフォーマット

```bash
# Prettier（JavaScript/TypeScript）
bun run fmt

# clang-format（C++）
bun run fmt:cpp

# zig fmt
bun run fmt:zig
```

### Linter

```bash
# OxLint
bun run lint
bun run lint:fix
```

### 型チェック

```bash
bun run typecheck
```

### クロスプラットフォームチェック

```bash
# 全プラットフォームでのZigコンパイルチェック
bun run zig:check-all
```

### デバッグ

- デバッグログ無効化: `BUN_DEBUG_QUIET_LOGS=1 bun-debug ...`
- 特定スコープのログ有効化: `BUN_DEBUG_<scope>=1 bun-debug ...`
- 例外検証: `BUN_JSC_validateExceptionChecks=1 BUN_JSC_dumpSimulatedThrows=1 bun bd <command>`
