---
generated_at: 2026-01-27 19:10:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **JSCエンジンの詳細動作**：WebKit内部実装のため直接確認困難
  2. **$プレフィックス関数の完全リスト**：ビルド時変換のため網羅困難
  3. **全コマンドの詳細フロー**：一部コマンドは未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.zig:1-200` - Bunメインモジュール
- E-02: `src/cli.zig:1-200` - CLIエントリーポイント
- E-03: `src/js_parser.zig:1-100` - JavaScriptパーサー
- E-04: `src/resolver/resolver.zig:1-80` - モジュールリゾルバー
- E-05: `src/bun.js/api/server.zig:1-80` - HTTPサーバー実装
- E-06: `src/bun.js/api/crypto.zig:1-29` - 暗号化API
- E-07: `src/bun.js/bindings/ZigGlobalObject.cpp:1-100` - JSCバインディング
- E-08: `src/js/node/fs.ts:1-80` - Node.js fsモジュール
- E-09: `src/js/builtins/ReadableStreamInternals.ts:1-100` - Streamビルトイン
- E-10: `src/install/PackageManager.zig:1-80` - パッケージマネージャ
- E-11: `src/codegen/generate-classes.ts:1-80` - クラス生成スクリプト
- E-12: `package.json:1-99` - プロジェクト設定
- E-13: `CLAUDE.md` - 開発ガイドライン
- E-14: `test/harness.ts:1-100` - テストハーネス
- E-15: `src/js/CLAUDE.md` - ビルトイン開発ガイド
- E-16: `test/CLAUDE.md` - テスト記述ガイド
- E-17: `src/CLAUDE.md` - Zig開発ガイド
- E-18: Globパターン検索結果（*.zig, *.cpp, *.ts ファイル一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BunはZig、C++、TypeScriptで構成されている | E-01, E-07, E-08 | ○ |
| C-02 | JavaScriptCoreエンジンを使用している | E-07, E-13 | ○ |
| C-03 | `@This()` はモジュール自身を参照する | E-01:7 | ○ |
| C-04 | `pub const` は公開定数を宣言する | E-01:9-11 | ○ |
| C-05 | `@import` は他のZigファイルを読み込む | E-01:9-11, E-06 | ○ |
| C-06 | `threadlocal` はスレッドローカル変数を宣言する | E-04:45-46 | ○ |
| C-07 | ビルトインでは `require()` を使用する | E-08:3-6, E-15 | ○ |
| C-08 | `$` プレフィックスでプライベートAPIにアクセス | E-09:30-34, E-15 | ○ |
| C-09 | `.$call` と `.$apply` を使用すべき | E-15 | ○ |
| C-10 | `.classes.ts` からバインディングが自動生成される | E-11, E-13 | ○ |
| C-11 | `src/bun.zig` がZigモジュールルート | E-01:1-7 | ○ |
| C-12 | `src/cli.zig` がCLIエントリーポイント | E-02:11-25 | ○ |
| C-13 | `src/bun.js/api/server.zig` がHTTPサーバー実装 | E-05:1-20 | ○ |
| C-14 | `src/install/PackageManager.zig` がパッケージマネージャ | E-10:1-30 | ○ |
| C-15 | テストは `bun bd test` で実行する | E-13, E-16 | ○ |
| C-16 | ディレクトリ構造の説明 | E-18 | ○ |
| C-17 | `JSError` 型でエラーハンドリング | E-01:156-175 | ○ |
| C-18 | `comptime` でコンパイル時計算 | E-04, E-11 | ○ |
| C-19 | Node.js互換レイヤーが存在する | E-08, E-13 | ○ |
| C-20 | バンドラーが `src/bundler/` にある | E-18 | ○ |
| C-21 | `src/js/node/` にNode.jsビルトインがある | E-08, E-18 | ○ |
| C-22 | `src/js/bun/` にBunビルトインがある | E-18 | ○ |
| C-23 | `src/codegen/` にコード生成スクリプトがある | E-11, E-18 | ○ |
| C-24 | テストは `test/` ディレクトリにある | E-14, E-18 | ○ |
| C-25 | 回帰テストは `test/regression/issue/` にある | E-13, E-16 | ○ |
| C-26 | `bunExe` と `bunEnv` をテストで使用する | E-14, E-16 | ○ |
| C-27 | `tempDir` でテスト用一時ディレクトリを作成 | E-14, E-16 | ○ |
| C-28 | JSCの`$`関数はビルド時に`@`に変換される | E-15 | ○ |
| C-29 | `generate-classes.ts` がクラス生成を担当 | E-11:1-30 | ○ |
| C-30 | `bundle-modules.ts` がモジュールバンドルを担当 | E-13 | ○ |
| C-31 | パーサー変更時はバージョンインクリメントが必要 | E-03:1-5 | ○ |
| C-32 | `WebSocketServerContext` がWebSocket処理 | E-05:4 | ○ |
| C-33 | `HTTPStatusText` がステータステキスト管理 | E-05:5 | ○ |
| C-34 | `HTMLBundle` がHTML処理 | E-05:6 | ○ |
| C-35 | `AnyRoute` が複数ルートタイプを統合 | E-05:23-38 | ○ |
| C-36 | `memoryCost` でメモリコスト計算 | E-05:40-47 | ○ |
| C-37 | `FSWatcher` クラスがファイル監視を提供 | E-08:41-66 | ○ |
| C-38 | `$isCallable` で関数チェック | E-08:23-24, E-09 | ○ |
| C-39 | `$putByIdDirectPrivate` でプライベートプロパティ設定 | E-09:30-31 | ○ |
| C-40 | `$getByIdDirectPrivate` でプライベートプロパティ取得 | E-09:32-34 | ○ |
| C-41 | CryptoHasherが暗号化ハッシュを提供 | E-06:8-16 | ○ |
| C-42 | HMACがHMAC実装を提供 | E-06:17 | ○ |
| C-43 | JSCの詳細内部動作 | **根拠なし** | △ |
| C-44 | `$`プレフィックス関数の完全リスト | **根拠なし** | △ |
| C-45 | 全CLIコマンドの詳細フロー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **JSCエンジンの詳細動作**: WebKit内部実装のため、Bunリポジトリ内では直接確認困難。WebKitソースコードの参照が必要
  - 候補：WebKit JavaScriptCore ソースコード / Apple公式ドキュメント / JSC Wiki
- **`$`プレフィックス関数の完全リスト**: ビルド時に変換されるため、全関数の網羅的なリストはコード生成ログまたはビルド成果物から確認が必要
  - 候補：ビルドログ / 生成されたC++ヘッダー / JSC内部API
- **全CLIコマンドの詳細フロー**: 一部のコマンド（audit, why等）は詳細なフロー追跡を実施していない
  - 候補：`src/cli/*.zig` の各コマンド実装

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ディレクトリ構造、命名規則、基本的なZig構文説明
  - ソースコードから直接確認可能
- **0（低リスク）**: テスト実行方法、開発ガイドライン
  - CLAUDE.mdから直接引用
- **1（中リスク）**: アーキテクチャ図、データフロー説明
  - ソースコードから推論した内容を含む
- **2（高リスク）**: JSC内部動作、`$`関数の完全性
  - 外部依存のため完全な検証が困難

## 6) レビュアーチェックリスト（最小）
- [ ] ディレクトリ構造が現在のリポジトリと一致しているか確認
- [ ] Zigコード例が最新のソースと整合しているか確認
- [ ] `$`プレフィックス関数の説明が正確か確認
- [ ] テスト実行コマンドが動作するか確認
- [ ] 参照している外部ドキュメント（Zig、JSC）のリンクが有効か確認
- [ ] アーキテクチャ図がプロジェクトの実態を反映しているか確認
