---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **VPC構成の詳細**：AWS VPC設定ファイルが未確認
  2. **バックアップ保持期間**：明示的な設定ファイルなし
  3. **Sentry監視詳細**：環境変数のみで詳細設定未確認
  4. **テスト並列数の根拠**：コード上の設定のみ、理由が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/bun-main/test/docker/docker-compose.yml`
- E-02: `/Users/tomoka.baba/Work/bun-main/.buildkite/Dockerfile`
- E-03: `/Users/tomoka.baba/Work/bun-main/.buildkite/ci.mjs`
- E-04: `/Users/tomoka.baba/Work/bun-main/.github/workflows/release.yml`
- E-05: `/Users/tomoka.baba/Work/bun-main/dockerhub/alpine/Dockerfile`
- E-06: `/Users/tomoka.baba/Work/bun-main/dockerhub/debian/Dockerfile`
- E-07: `/Users/tomoka.baba/Work/bun-main/dockerhub/debian-slim/Dockerfile`
- E-08: `/Users/tomoka.baba/Work/bun-main/dockerhub/distroless/Dockerfile`
- E-09: `/Users/tomoka.baba/Work/bun-main/.buildkite/bootstrap.yml`
- E-10: `/Users/tomoka.baba/Work/bun-main/package.json`
- E-11: `/Users/tomoka.baba/Work/bun-main/test/js/valkey/docker-unified/Dockerfile`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BunはZigとC++で実装されている | E-02, E-10 | ○ |
| C-02 | CI/CDはBuildkiteとGitHub Actionsを使用 | E-03, E-04 | ○ |
| C-03 | ビルドサーバーにc8g.4xlargeを使用（ARM64） | E-03 | ○ |
| C-04 | ビルドサーバーにc7i.4xlargeを使用（x64） | E-03 | ○ |
| C-05 | Zigビルドにr8g.largeを使用 | E-03 | ○ |
| C-06 | リンク処理にr8g.xlarge/r7i.xlargeを使用 | E-03 | ○ |
| C-07 | テストサーバーにc8g.xlarge/c7i.xlargeを使用 | E-03 | ○ |
| C-08 | Linux ARM64でAmazon Linux 2023を使用 | E-03 | ○ |
| C-09 | Linux x64でAmazon Linux 2023を使用 | E-03 | ○ |
| C-10 | Alpine 3.22でmuslビルドを実行 | E-03, E-05 | ○ |
| C-11 | macOS 14でARM64/x64ビルドを実行 | E-03 | ○ |
| C-12 | Windows 2019でビルドを実行 | E-03 | ○ |
| C-13 | LLVMバージョン19を使用 | E-02 | ○ |
| C-14 | GCCバージョン13を使用 | E-02 | ○ |
| C-15 | CMakeバージョン3.30.5を使用 | E-02 | ○ |
| C-16 | PostgreSQL 15をテストで使用 | E-01 | ○ |
| C-17 | MySQL 8.0/8.4をテストで使用 | E-01 | ○ |
| C-18 | Redis 7-alpineをテストで使用 | E-01 | ○ |
| C-19 | MinIOをS3互換テストで使用 | E-01 | ○ |
| C-20 | Squidをプロキシテストで使用 | E-01 | ○ |
| C-21 | AlpineベースのDockerイメージを提供 | E-05 | ○ |
| C-22 | DebianベースのDockerイメージを提供 | E-06 | ○ |
| C-23 | Debian SlimのDockerイメージを提供 | E-07 | ○ |
| C-24 | DistrolessのDockerイメージを提供 | E-08 | ○ |
| C-25 | GPGキーF3DCC08A8572C0749B3E18888EAB4D40A7B22B59で署名 | E-05, E-06, E-07, E-08 | ○ |
| C-26 | GitHub Releasesで配布 | E-04 | ○ |
| C-27 | DockerHubでイメージ配布 | E-04 | ○ |
| C-28 | npmでパッケージ配布 | E-04 | ○ |
| C-29 | AWS S3/R2でバイナリ配布 | E-04 | ○ |
| C-30 | Homebrewで配布 | E-04 | ○ |
| C-31 | Sentryでリリース通知 | E-04 | ○ |
| C-32 | macOSテストは2並列 | E-03 | ○ |
| C-33 | Linux/Windowsテストは20並列 | E-03 | ○ |
| C-34 | VPC構成でプライベートサブネットを使用 | **根拠なし** | △ |
| C-35 | バックアップ保持期間は無期限 | **根拠なし** | △ |
| C-36 | mainブランチの優先度は2 | E-03 | ○ |
| C-37 | フォークの優先度は-1 | E-03 | ○ |
| C-38 | 手動リトライが可能 | E-03 | ○ |
| C-39 | bunユーザー（UID 1000）で実行 | E-05, E-06, E-07 | ○ |
| C-40 | BUN_RUNTIME_TRANSPILER_CACHE_PATH=0がデフォルト | E-05, E-06, E-07, E-08 | ○ |
| C-41 | Sentry監視の詳細設定 | **根拠なし** | △ |
| C-42 | テスト並列数の設計根拠 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **VPC構成の詳細**：AWS VPCの設定ファイル（Terraform、CloudFormation等）が見つからなかった。CIコードからEC2インスタンスの使用は確認できるが、ネットワーク構成の詳細は不明。
  - 候補：Terraformファイル / CloudFormationテンプレート / AWS CDK設定
- **バックアップ保持期間**：GitHub ReleasesやDockerHubの保持ポリシーは外部サービス依存であり、明示的な設定は存在しない。
  - 候補：バックアップポリシードキュメント / サービス利用規約
- **Sentry監視詳細**：release.ymlでSentryへの通知は確認できるが、監視ルールやアラート設定は不明。
  - 候補：Sentry設定ファイル / 監視ダッシュボード設定
- **テスト並列数の設計根拠**：ci.mjsで並列数の設定は確認できるが、その数値の根拠（リソース制約、最適化根拠等）は不明。
  - 候補：設計ドキュメント / パフォーマンスチューニング記録

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: Dockerイメージ構成、GPG署名、テスト環境構成
- **1 (中リスク)**: EC2インスタンスタイプ（コスト影響）、テスト並列数（パフォーマンス影響）
- **2 (高リスク)**: VPC構成（セキュリティ影響）、シークレット管理（認証情報漏洩リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] VPC構成がセキュリティ要件を満たしているか確認
- [ ] EC2インスタンスタイプがコスト・パフォーマンス要件に適合しているか確認
- [ ] シークレット管理がセキュリティベストプラクティスに従っているか確認
- [ ] テスト並列数が実際のリソース制約と整合しているか確認
- [ ] バックアップ/復旧手順が存在し、テスト済みか確認
- [ ] Sentry監視設定が適切なアラートを発報するか確認
- [ ] GPG署名キーのローテーション計画があるか確認
