# インフラ構成図

## 全体システム構成図

```mermaid
flowchart TB
    subgraph Developer["開発者環境"]
        DEV[開発者]
        LOCAL[ローカル開発環境]
    end

    subgraph GitHub["GitHub"]
        REPO[bun リポジトリ]
        GHA[GitHub Actions]
        RELEASES[GitHub Releases]
    end

    subgraph Buildkite["Buildkite CI/CD"]
        BK_AGENT[Buildkite Agent]
        BK_PIPELINE[CI Pipeline]
    end

    subgraph AWS["AWS Cloud"]
        subgraph EC2_BUILD["ビルドサーバー"]
            BUILD_ARM[ARM64 ビルド<br/>c8g.4xlarge]
            BUILD_X64[x64 ビルド<br/>c7i.4xlarge]
            BUILD_ZIG[Zig ビルド<br/>r8g.large]
        end
        subgraph EC2_LINK["リンクサーバー"]
            LINK_ARM[ARM64 リンク<br/>r8g.xlarge]
            LINK_X64[x64 リンク<br/>r7i.xlarge]
            LINK_WIN[Windows リンク<br/>r7i.large]
        end
        subgraph EC2_TEST["テストサーバー"]
            TEST_ARM[ARM64 テスト<br/>c8g.xlarge]
            TEST_X64[x64 テスト<br/>c7i.xlarge]
            TEST_WIN[Windows テスト<br/>c7i.2xlarge]
        end
        S3[S3/R2<br/>バイナリストレージ]
    end

    subgraph MacOS["macOS ランナー"]
        MAC_BUILD[macOS ビルド]
        MAC_TEST[macOS テスト]
    end

    subgraph Distribution["配布先"]
        DOCKERHUB[DockerHub]
        NPM[npm Registry]
        HOMEBREW[Homebrew]
    end

    subgraph Monitoring["監視"]
        SENTRY[Sentry]
    end

    DEV --> LOCAL
    DEV --> REPO
    REPO --> GHA
    REPO --> BK_AGENT

    BK_AGENT --> BK_PIPELINE
    BK_PIPELINE --> BUILD_ARM
    BK_PIPELINE --> BUILD_X64
    BK_PIPELINE --> BUILD_ZIG
    BK_PIPELINE --> MAC_BUILD

    BUILD_ARM --> LINK_ARM
    BUILD_X64 --> LINK_X64
    BUILD_X64 --> LINK_WIN
    BUILD_ZIG --> LINK_ARM
    BUILD_ZIG --> LINK_X64
    BUILD_ZIG --> LINK_WIN

    LINK_ARM --> TEST_ARM
    LINK_X64 --> TEST_X64
    LINK_WIN --> TEST_WIN
    MAC_BUILD --> MAC_TEST

    LINK_ARM --> RELEASES
    LINK_X64 --> RELEASES
    LINK_WIN --> RELEASES
    MAC_BUILD --> RELEASES

    GHA --> RELEASES
    GHA --> DOCKERHUB
    GHA --> NPM
    GHA --> HOMEBREW
    GHA --> S3
    GHA --> SENTRY

    RELEASES --> S3
```

## CI/CDパイプライン構成図

```mermaid
flowchart LR
    subgraph Trigger["トリガー"]
        PR[Pull Request]
        PUSH[Push to main]
        SCHEDULE[スケジュール<br/>毎日6:00 PST]
        MANUAL[手動実行]
    end

    subgraph Build["ビルドフェーズ"]
        direction TB
        CPP[C++ ビルド]
        ZIG[Zig ビルド]
        LINK[リンク処理]
        CPP --> LINK
        ZIG --> LINK
    end

    subgraph Test["テストフェーズ"]
        direction TB
        TEST_LINUX[Linux テスト<br/>20並列]
        TEST_MAC[macOS テスト<br/>2並列]
        TEST_WIN[Windows テスト<br/>20並列]
    end

    subgraph Release["リリースフェーズ"]
        direction TB
        SIGN[GPG署名]
        UPLOAD_GH[GitHub Releases]
        UPLOAD_S3[S3アップロード]
        DOCKER[Docker Push]
        NPM_PUB[npm Publish]
        BREW[Homebrew更新]
        SENTRY_NOTIFY[Sentry通知]
    end

    PR --> Build
    PUSH --> Build
    SCHEDULE --> Build
    MANUAL --> Build

    Build --> Test
    Build --> Release

    SIGN --> UPLOAD_GH
    SIGN --> UPLOAD_S3
    SIGN --> DOCKER
    SIGN --> NPM_PUB
    SIGN --> BREW
    UPLOAD_S3 --> SENTRY_NOTIFY
```

## ビルドプラットフォーム構成図

```mermaid
flowchart TB
    subgraph Linux_glibc["Linux (glibc)"]
        AL_ARM[Amazon Linux 2023<br/>ARM64]
        AL_X64[Amazon Linux 2023<br/>x64]
        AL_X64_BASE[Amazon Linux 2023<br/>x64-baseline]
    end

    subgraph Linux_musl["Linux (musl)"]
        ALP_ARM[Alpine 3.22<br/>ARM64]
        ALP_X64[Alpine 3.22<br/>x64]
        ALP_X64_BASE[Alpine 3.22<br/>x64-baseline]
    end

    subgraph MacOS_Build["macOS"]
        MAC_ARM[macOS 14<br/>ARM64]
        MAC_X64[macOS 14<br/>x64]
    end

    subgraph Windows_Build["Windows"]
        WIN_X64[Windows 2019<br/>x64]
        WIN_X64_BASE[Windows 2019<br/>x64-baseline]
    end

    subgraph Artifacts["ビルド成果物"]
        BUN_LINUX_ARM[bun-linux-aarch64]
        BUN_LINUX_X64[bun-linux-x64]
        BUN_LINUX_X64_BASE[bun-linux-x64-baseline]
        BUN_LINUX_ARM_MUSL[bun-linux-aarch64-musl]
        BUN_LINUX_X64_MUSL[bun-linux-x64-musl]
        BUN_LINUX_X64_MUSL_BASE[bun-linux-x64-musl-baseline]
        BUN_MAC_ARM[bun-darwin-aarch64]
        BUN_MAC_X64[bun-darwin-x64]
        BUN_WIN_X64[bun-windows-x64]
        BUN_WIN_X64_BASE[bun-windows-x64-baseline]
    end

    AL_ARM --> BUN_LINUX_ARM
    AL_X64 --> BUN_LINUX_X64
    AL_X64_BASE --> BUN_LINUX_X64_BASE
    ALP_ARM --> BUN_LINUX_ARM_MUSL
    ALP_X64 --> BUN_LINUX_X64_MUSL
    ALP_X64_BASE --> BUN_LINUX_X64_MUSL_BASE
    MAC_ARM --> BUN_MAC_ARM
    MAC_X64 --> BUN_MAC_X64
    WIN_X64 --> BUN_WIN_X64
    WIN_X64_BASE --> BUN_WIN_X64_BASE
```

## テスト環境構成図（Docker Compose）

```mermaid
flowchart TB
    subgraph Docker_Network["Docker Network (bridge)"]
        subgraph PostgreSQL["PostgreSQL サービス"]
            PG_PLAIN[postgres_plain<br/>Port: 5432]
            PG_TLS[postgres_tls<br/>Port: 5432<br/>SSL有効]
            PG_AUTH[postgres_auth<br/>Port: 5432<br/>認証設定]
        end

        subgraph MySQL_Services["MySQL サービス"]
            MY_PLAIN[mysql_plain<br/>Port: 3306<br/>MySQL 8.4]
            MY_NATIVE[mysql_native_password<br/>Port: 3306<br/>MySQL 8.0]
            MY_TLS[mysql_tls<br/>Port: 3306<br/>TLS有効]
        end

        subgraph Redis_Services["Redis/Valkey サービス"]
            REDIS_PLAIN[redis_plain<br/>Port: 6379]
            REDIS_UNIFIED[redis_unified<br/>TCP: 6379<br/>TLS: 6380]
        end

        subgraph Other_Services["その他サービス"]
            MINIO[MinIO<br/>API: 9000<br/>Console: 9001]
            AUTOBAHN[Autobahn<br/>Port: 9002]
            SQUID[Squid Proxy<br/>Port: 3128]
        end
    end

    subgraph Volumes["ボリューム"]
        REDIS_UNIX[redis-unix]
        REDIS_DATA[redis-data]
    end

    REDIS_UNIFIED --> REDIS_UNIX
    REDIS_UNIFIED --> REDIS_DATA
```

## Dockerイメージ配布構成図

```mermaid
flowchart LR
    subgraph Source["ソースイメージ"]
        DEBIAN_BASE[debian:trixie]
        DEBIAN_SLIM[debian:trixie-slim]
        ALPINE_BASE[alpine:3.22]
        DISTROLESS[gcr.io/distroless<br/>/base-nossl-debian13]
    end

    subgraph Build_Stage["ビルドステージ"]
        BUILD_DEB[Debianビルド]
        BUILD_SLIM[Debian Slimビルド]
        BUILD_ALP[Alpineビルド]
        BUILD_DIST[Distrolessビルド]
    end

    subgraph Final_Images["公開イメージ"]
        IMG_LATEST[oven/bun:latest]
        IMG_DEBIAN[oven/bun:debian]
        IMG_SLIM[oven/bun:slim]
        IMG_ALPINE[oven/bun:alpine]
        IMG_DISTROLESS[oven/bun:distroless]
        IMG_VERSION[oven/bun:x.y.z]
    end

    subgraph Arch["アーキテクチャ"]
        AMD64[linux/amd64]
        ARM64[linux/arm64]
    end

    DEBIAN_BASE --> BUILD_DEB
    DEBIAN_SLIM --> BUILD_SLIM
    ALPINE_BASE --> BUILD_ALP
    DISTROLESS --> BUILD_DIST

    BUILD_DEB --> IMG_LATEST
    BUILD_DEB --> IMG_DEBIAN
    BUILD_SLIM --> IMG_SLIM
    BUILD_ALP --> IMG_ALPINE
    BUILD_DIST --> IMG_DISTROLESS

    IMG_LATEST --> AMD64
    IMG_LATEST --> ARM64
    IMG_DEBIAN --> AMD64
    IMG_DEBIAN --> ARM64
    IMG_SLIM --> AMD64
    IMG_SLIM --> ARM64
    IMG_ALPINE --> AMD64
    IMG_ALPINE --> ARM64
    IMG_DISTROLESS --> AMD64
    IMG_DISTROLESS --> ARM64
```

## セキュリティ構成図

```mermaid
flowchart TB
    subgraph Signing["署名プロセス"]
        GPG_KEY[GPG秘密鍵]
        SIGN_PROCESS[署名処理]
        SHASUMS[SHASUMS256.txt]
        SHASUMS_ASC[SHASUMS256.txt.asc]
    end

    subgraph Verification["検証プロセス"]
        KEYSERVER1[keys.openpgp.org]
        KEYSERVER2[keyserver.ubuntu.com]
        GPG_VERIFY[GPG検証]
        SHA_VERIFY[SHA256検証]
    end

    subgraph Secrets["シークレット管理"]
        GH_SECRETS[GitHub Secrets]
        GPG_PRIV[GPG_PRIVATE_KEY]
        GPG_PASS[GPG_PASSPHRASE]
        DOCKER_CRED[DOCKER_USERNAME<br/>DOCKER_PASSWORD]
        NPM_CRED[NPM_TOKEN]
        AWS_CRED[AWS_ACCESS_KEY_ID<br/>AWS_SECRET_ACCESS_KEY]
        SENTRY_CRED[SENTRY_AUTH_TOKEN]
    end

    subgraph Code_Signing["コード署名"]
        DIGICERT[DigiCert]
        WIN_SIGN[Windows署名]
    end

    GPG_KEY --> SIGN_PROCESS
    SIGN_PROCESS --> SHASUMS
    SIGN_PROCESS --> SHASUMS_ASC

    KEYSERVER1 --> GPG_VERIFY
    KEYSERVER2 --> GPG_VERIFY
    SHASUMS_ASC --> GPG_VERIFY
    SHASUMS --> SHA_VERIFY

    GH_SECRETS --> GPG_PRIV
    GH_SECRETS --> GPG_PASS
    GH_SECRETS --> DOCKER_CRED
    GH_SECRETS --> NPM_CRED
    GH_SECRETS --> AWS_CRED
    GH_SECRETS --> SENTRY_CRED

    DIGICERT --> WIN_SIGN
```

## AWS EC2インスタンス構成図

```mermaid
flowchart TB
    subgraph VPC["AWS VPC"]
        subgraph Compute_Optimized["コンピュート最適化 (Cシリーズ)"]
            C8G_4XL[c8g.4xlarge<br/>ARM64 C++ビルド<br/>16 vCPU, 32GB]
            C7I_4XL[c7i.4xlarge<br/>x64 C++ビルド<br/>16 vCPU, 32GB]
            C8G_2XL[c8g.2xlarge<br/>ARM64 ASANテスト<br/>8 vCPU, 16GB]
            C7I_2XL[c7i.2xlarge<br/>x64 ASANテスト<br/>8 vCPU, 16GB]
            C8G_XL[c8g.xlarge<br/>ARM64 テスト<br/>4 vCPU, 8GB]
            C7I_XL[c7i.xlarge<br/>x64 テスト<br/>4 vCPU, 8GB]
        end

        subgraph Memory_Optimized["メモリ最適化 (Rシリーズ)"]
            R8G_XL[r8g.xlarge<br/>ARM64 リンク<br/>4 vCPU, 32GB]
            R7I_XL[r7i.xlarge<br/>x64 リンク<br/>4 vCPU, 32GB]
            R8G_L[r8g.large<br/>Zigビルド<br/>2 vCPU, 16GB]
            R7I_L[r7i.large<br/>Windowsリンク<br/>2 vCPU, 16GB]
        end
    end

    subgraph Agent_Config["エージェント設定"]
        ROBOBUN[robobun: true]
        PREEMPTIBLE[preemptible: false]
        CPU_CONFIG[cpu-count / threads-per-core]
    end

    Compute_Optimized --> Agent_Config
    Memory_Optimized --> Agent_Config
```
