# インフラ設計書

## 概要

本ドキュメントは、Bunプロジェクトのインフラストラクチャ構成を記述した設計書です。BunはJavaScriptランタイム、バンドラー、テストランナー、パッケージマネージャーを統合したオールインワンツールキットであり、主にZigとC++で実装されています。本プロジェクトでは、開発・テスト・CI/CD・本番配布の各フェーズに対応したインフラを構築しています。

## システム構成

### 全体構成

Bunプロジェクトのインフラは以下の主要コンポーネントで構成されています。

1. **CI/CDパイプライン**: BuildkiteおよびGitHub Actionsによる自動ビルド・テスト・リリース
2. **開発用Dockerイメージ**: 開発環境の標準化
3. **テスト用Docker Compose環境**: データベース、キャッシュ、各種サービスのテスト環境
4. **本番配布用Dockerイメージ**: DockerHubへの公式イメージ配布
5. **クラウドインフラ**: AWS EC2による動的ビルド・テスト環境

### サーバー構成

#### ビルドサーバー（EC2）

| サーバー種別 | 役割 | スペック | アーキテクチャ |
| --- | --- | --- | --- |
| C++ビルド (ARM64) | C++コンパイル | c8g.4xlarge | aarch64 |
| C++ビルド (x64) | C++コンパイル | c7i.4xlarge | x86_64 |
| Zigビルド | Zigコンパイル | r8g.large | aarch64 |
| リンク (ARM64) | バイナリリンク | r8g.xlarge | aarch64 |
| リンク (x64) | バイナリリンク | r7i.xlarge | x86_64 |
| リンク (Windows) | バイナリリンク | r7i.large | x86_64 |

#### テストサーバー（EC2）

| サーバー種別 | 役割 | スペック | アーキテクチャ |
| --- | --- | --- | --- |
| テスト (ARM64) | テスト実行 | c8g.xlarge | aarch64 |
| テスト (x64) | テスト実行 | c7i.xlarge | x86_64 |
| テスト (ASAN ARM64) | メモリ検証テスト | c8g.2xlarge | aarch64 |
| テスト (ASAN x64) | メモリ検証テスト | c7i.2xlarge | x86_64 |
| テスト (Windows) | Windowsテスト | c7i.2xlarge | x86_64 |

#### ビルドプラットフォーム

| OS | アーキテクチャ | ABI | ディストロ | バージョン |
| --- | --- | --- | --- | --- |
| Linux | aarch64 | glibc | Amazon Linux | 2023 |
| Linux | x64 | glibc | Amazon Linux | 2023 |
| Linux | x64 (baseline) | glibc | Amazon Linux | 2023 |
| Linux | aarch64 | musl | Alpine | 3.22 |
| Linux | x64 | musl | Alpine | 3.22 |
| Linux | x64 (baseline) | musl | Alpine | 3.22 |
| macOS | aarch64 | - | - | 14 |
| macOS | x64 | - | - | 14 |
| Windows | x64 | - | - | 2019 |
| Windows | x64 (baseline) | - | - | 2019 |

### ネットワーク構成

#### CI/CD環境

- **BuildkiteエージェントネットワーK**: AWS VPC内のプライベートサブネットで実行
- **GitHub Actions**: GitHubホステッドランナーを使用
- **イメージレジストリ**: DockerHubへのプッシュはHTTPS経由

#### テスト環境（Docker Compose）

```
+-------------------+
|  Docker Network   |
|    (bridge)       |
+-------------------+
        |
   +----+----+----+----+----+----+----+
   |    |    |    |    |    |    |    |
 postgres postgres postgres mysql mysql mysql redis
 _plain   _tls    _auth  _plain _native _tls  _*
   |    |    |    |    |    |    |    |
   5432  5432  5432  3306  3306  3306 6379/6380
```

## ミドルウェア

### 開発・ビルド環境

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| LLVM/Clang | 19.1.7 | C++コンパイラ |
| GCC | 13 | C++コンパイラ（バックアップ） |
| CMake | 3.30.5 | ビルドシステム |
| Ninja | - | ビルドツール |
| Rust (nightly) | nightly | 一部コンポーネントのビルド |
| Bun | 1.1.38+ | ビルドスクリプト実行 |

### テスト用サービス

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| PostgreSQL | 15 | データベーステスト |
| MySQL | 8.0/8.4 | データベーステスト |
| Redis | 7-alpine | キャッシュテスト |
| MinIO | latest | S3互換ストレージテスト |
| Squid | 5.2-22.04_beta | プロキシテスト |
| Autobahn | latest | WebSocketテスト |

### 本番配布用ベースイメージ

| ベースイメージ | バージョン | 用途 |
| --- | --- | --- |
| Alpine | 3.22 | 軽量Dockerイメージ |
| Debian (trixie) | trixie | 標準Dockerイメージ |
| Debian Slim | trixie-slim | 軽量Debianイメージ |
| Distroless | base-nossl-debian13 | 最小構成イメージ |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソースコード管理、リリース配布 | HTTPS/API |
| DockerHub | Dockerイメージ配布 | HTTPS |
| npm Registry | パッケージ配布 | HTTPS |
| AWS S3/R2 | バイナリ配布 | HTTPS |
| Buildkite | CI/CD | HTTPS/エージェント |
| Homebrew | macOSパッケージ配布 | Git |
| Sentry | エラー監視・リリース通知 | HTTPS |
| OpenPGP/Ubuntu Keyserver | GPG署名検証 | HKP |
| DefinitelyTyped | TypeScript型定義PR | GitHub API |

## スケーリング設計

### CI/CDスケーリング

1. **水平スケーリング**: EC2インスタンスはBuildkiteエージェントの需要に応じて動的に起動
2. **並列ビルド**:
   - C++ビルドとZigビルドは並列実行
   - 各プラットフォームのビルドは独立して並列実行
3. **テスト並列化**:
   - macOS: 2並列
   - Linux/Windows: 20並列

### インスタンスタイプ選定基準

| 用途 | CPU最適化 | メモリ最適化 | 備考 |
| --- | --- | --- | --- |
| C++コンパイル | c7i/c8g系 | - | CPU集約型 |
| リンク処理 | - | r7i/r8g系 | メモリ集約型 |
| テスト実行 | c7i/c8g系 | - | CPU集約型 |

## 可用性設計

### ビルドパイプライン

1. **手動リトライ**: 全ステップで手動リトライが可能
2. **自動リトライ**: 無効化（ビルドの確実性を優先）
3. **ビルドキャンセル**: マージキュー時はビルド失敗で後続をキャンセル
4. **フォールバック**: ビルドスキップ時は最後の成功ビルドのアーティファクトを使用

### 優先度制御

| 条件 | 優先度 |
| --- | --- |
| mainブランチ | 2（最高） |
| マージキュー | 1 |
| 通常PR | 0 |
| フォーク | -1（最低） |

### Dockerイメージ

- **マルチアーキテクチャ対応**: linux/amd64, linux/arm64の両方をサポート
- **GPG署名検証**: リリースアセットの整合性確認
- **フォールバックキーサーバー**: keys.openpgp.org と keyserver.ubuntu.com の両方を使用

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Git（GitHub） | リアルタイム | 無期限 |
| ビルドアーティファクト | Buildkite Artifacts | ビルド毎 | ビルド履歴に依存 |
| リリースバイナリ | GitHub Releases | リリース毎 | 無期限 |
| リリースバイナリ（コピー） | AWS S3/R2 | リリース毎 | 無期限 |
| Dockerイメージ | DockerHub | リリース毎 | 無期限 |

## 監視設計

### Sentryによるモニタリング

- **リリース通知**: 新バージョンリリース時にSentryへ通知
- **環境**: production
- **バージョントラッキング**: リリースタグをSentryリリースとして登録

### CI/CD監視

- **Buildkite Dashboard**: ビルド状況の可視化
- **GitHub Actions**: ワークフロー実行状況の監視
- **ヘルスチェック**: Docker Composeサービスに対するヘルスチェック設定

### テスト環境ヘルスチェック

| サービス | チェックコマンド | タイムアウト | リトライ |
| --- | --- | --- | --- |
| PostgreSQL | `pg_isready -U postgres` | 5s | 30回 |
| MySQL | `mysqladmin ping -h localhost` | 5s | 30回 |
| MinIO | `mc ready local` | 5s | 30回 |
| Squid | `pgrep squid > /dev/null` | 5s | 30回 |

## セキュリティ設計

### 署名と検証

1. **GPG署名**: リリースアセットはGPG署名で保護
   - キーID: F3DCC08A8572C0749B3E18888EAB4D40A7B22B59
2. **SHA256チェックサム**: SHASUMS256.txt.asc で整合性検証
3. **Windowsコード署名**: DigiCertによるコード署名（リリースビルドのみ）

### シークレット管理

| シークレット | 用途 | 管理場所 |
| --- | --- | --- |
| GPG_PRIVATE_KEY | リリース署名 | GitHub Secrets |
| DOCKER_USERNAME/PASSWORD | DockerHubプッシュ | GitHub Secrets |
| NPM_TOKEN | npmパッケージ公開 | GitHub Secrets |
| AWS_ACCESS_KEY_ID | S3アップロード | GitHub Secrets |
| SENTRY_AUTH_TOKEN | Sentry連携 | GitHub Secrets |
| GITHUB_TOKEN | GitHub API | 自動提供 |

### コンテナセキュリティ

- **非rootユーザー**: 本番Dockerイメージはbunユーザー（UID 1000）で実行
- **最小権限**: distrolessイメージで不要なバイナリを排除
- **ランタイムキャッシュ無効化**: `BUN_RUNTIME_TRANSPILER_CACHE_PATH=0` でエフェメラルコンテナでのキャッシュを無効化

## 環境変数

### ビルド環境変数

| 変数名 | 説明 | デフォルト値 |
| --- | --- | --- |
| ENABLE_BASELINE | ベースラインビルドの有効化 | OFF |
| ENABLE_CANARY | カナリービルドの有効化 | ON |
| CANARY_REVISION | カナリーリビジョン番号 | 1 |
| ABI | ABIタイプ（musl/glibc） | - |
| CMAKE_VERBOSE_MAKEFILE | CMake詳細ログ | ON |

### ランタイム環境変数

| 変数名 | 説明 | デフォルト値 |
| --- | --- | --- |
| BUN_RUNTIME_TRANSPILER_CACHE_PATH | トランスパイラキャッシュパス | 0（無効） |
| BUN_INSTALL_BIN | グローバルインストール先 | /usr/local/bin |
| ASAN_OPTIONS | Address Sanitizerオプション | (テスト用設定) |

## 備考

### プラットフォーム固有の考慮事項

1. **macOS**: Xcode CLTとHomebrewを使用、専用ビルドキューで実行
2. **Windows**: COMSPEC環境変数の設定が必要、DigiCert署名はリリースビルドのみ
3. **Alpine Linux**: muslビルドはbaselineオプションとの組み合わせが可能
4. **ARM64**: Apple Silicon (M1/M2/M3/M4) とAWS Gravitonの両方をサポート

### 依存関係の更新

GitHub Actionsワークフローで以下の依存関係の自動更新が設定されています。

- root-certs（ルート証明書）
- zstd（圧縮ライブラリ）
- libarchive（アーカイブライブラリ）
- lol-html（HTMLパーサー）
- hdrhistogram（ヒストグラムライブラリ）
- lshpack（HPACKライブラリ）
- sqlite3（データベース）
- libdeflate（圧縮ライブラリ）
- highway（SIMDライブラリ）
- c-ares（DNS解決ライブラリ）

### テスト用データベース設定

- **PostgreSQL**: `trust`認証（開発環境専用）
- **MySQL**: 空パスワードまたは`bun`パスワード
- **Redis/Valkey**: TCP、TLS、Unixソケット、認証の各モードをサポート
