---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **XSS/CSRF対策**：ランタイムレベルでの対策有無の確認が必要
  2. **SQLインジェクション対策**：bun:sqliteのプリペアドステートメント実装の詳細確認
  3. **監査ログの保持期間**：実行時のみの保持は推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/api/crypto/PasswordObject.zig` - パスワードハッシュ実装
- E-02: `src/bun.js/api/crypto/HMAC.zig` - HMAC実装
- E-03: `src/bun.js/api/crypto/EVP.zig` - ハッシュアルゴリズム実装
- E-04: `src/bun.js/api/crypto/CryptoHasher.zig` - 暗号ハッシャー実装
- E-05: `src/bun.js/api/server/SSLConfig.zig` - SSL/TLS設定
- E-06: `src/bun.js/bindings/NodeTLS.cpp` - TLS証明書管理
- E-07: `src/bun.js/bindings/NodeValidator.cpp` - 入力検証
- E-08: `src/bun.js/bindings/JSSecrets.cpp` - シークレット管理
- E-09: `src/bun.js/webcore/Crypto.zig` - WebCrypto API実装
- E-10: `src/bun.js/api/bun/socket/tls_socket_functions.zig` - TLSソケット機能
- E-11: `src/install/PackageManager/security_scanner.zig` - セキュリティスキャナー
- E-12: `src/http/FetchRequestMode.zig` - Fetch リクエストモード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パスワードハッシュでArgon2id/Argon2i/Argon2d/bcryptをサポート | E-01 | ○ |
| C-02 | bcryptのコストパラメータは4-31の範囲 | E-01 | ○ |
| C-03 | Argon2のデフォルトはinteractive_2idパラメータ | E-01 | ○ |
| C-04 | HMACはBoringSSL HMAC_CTXを使用 | E-02 | ○ |
| C-05 | 対応ハッシュアルゴリズム一覧(MD5, SHA系, BLAKE2等) | E-03 | ○ |
| C-06 | SSLConfigでkey_file_name, cert_file_name等を管理 | E-05 | ○ |
| C-07 | reject_unauthorizedとrequest_certのデフォルト値は0 | E-05 | ○ |
| C-08 | freeSensitiveによるセキュアなメモリ解放 | E-05 | ○ |
| C-09 | バンドル/システム/追加CA証明書の取得機能 | E-06 | ○ |
| C-10 | デフォルト暗号スイートの取得/設定機能 | E-06 | ○ |
| C-11 | validateInteger, validateNumber, validateString関数の存在 | E-07 | ○ |
| C-12 | ERR_INVALID_ARG_TYPE, ERR_OUT_OF_RANGEエラーコード | E-07 | ○ |
| C-13 | シークレット管理でmacOSキーチェーンAPI使用 | E-08 | ○ |
| C-14 | シークレットエラーコード(ACCESS_DENIED, AUTH_FAILED等) | E-08 | ○ |
| C-15 | メモリ上のシークレットは使用後にゼロクリア | E-08 | ○ |
| C-16 | crypto.getRandomValues()の存在 | E-09 | ○ |
| C-17 | crypto.randomUUID()とrandomUUIDv7()の存在 | E-09 | ○ |
| C-18 | 512バイト以下はキャッシュから乱数取得 | E-09 | ○ |
| C-19 | timingSafeEqual()による定数時間比較 | E-09 | ○ |
| C-20 | getServername/setServernameの存在 | E-10 | ○ |
| C-21 | getPeerCertificate/getX509Certificateの存在 | E-10 | ○ |
| C-22 | getTLSVersion関数の存在 | E-10 | ○ |
| C-23 | setMaxSendFragment (1-16384バイト範囲) | E-10 | ○ |
| C-24 | getSharedSigalgs関数の存在 | E-10 | ○ |
| C-25 | SecurityAdvisoryLevelにfatalとwarnが存在 | E-11 | ○ |
| C-26 | SecurityScanResultsにアドバイザリ情報を含む | E-11 | ○ |
| C-27 | FetchRequestModeにsame-origin, no-cors, cors, navigate | E-12 | ○ |
| C-28 | BoringSSLを使用している | E-06, E-02, E-03 | ○ |
| C-29 | TLS 1.2/1.3をサポート | E-06 | ○ |
| C-30 | sha3-224, sha3-256, sha3-384, sha3-512をサポート | E-03 | ○ |
| C-31 | shake128, shake256をサポート | E-03 | ○ |
| C-32 | TLSFinishedメッセージ取得機能 | E-10 | ○ |
| C-33 | SSNIサーバー名設定時にisInitFinishedチェック | E-10 | ○ |
| C-34 | RSA, RSA-PSS署名アルゴリズムサポート | E-10 | ○ |
| C-35 | セキュリティスキャンの部分インストール機能 | E-11 | ○ |
| C-36 | asUSocketsForClientVerification関数の存在 | E-05 | ○ |
| C-37 | SSLConfig.isSame関数での設定比較機能 | E-05 | ○ |
| C-38 | 低メモリモード設定オプションの存在 | E-05 | ○ |
| C-39 | XSS対策はアプリケーション層での対策が必要 | **根拠なし** | △ |
| C-40 | CSRF対策はアプリケーション層での対策が必要 | **根拠なし** | △ |
| C-41 | bun:sqliteでプリペアドステートメントをサポート | **根拠なし** | △ |
| C-42 | 監査ログは実行時のみ保持 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **XSS/CSRF対策 (C-39, C-40)**：Bunランタイムレベルでの対策実装が見当たらず、アプリケーション層での対策が必要と推測
  - 候補：`src/bun.js/webcore/` / `src/bun.js/bindings/webcore/` / HTTPヘッダー処理関連

- **SQLインジェクション対策 (C-41)**：bun:sqliteのプリペアドステートメント実装の詳細コード確認が必要
  - 候補：`src/bun.js/bindings/sqlite/` / `src/bun.js/api/sql.classes.ts`

- **監査ログ保持期間 (C-42)**：ログの永続化機能の有無について確認が必要
  - 候補：ロギング設定ファイル / 外部ログ連携機能

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 暗号化関連の記述 - BoringSSLベースの実装は成熟しており、コード上での根拠も明確
- **0 (低リスク)**: パスワードハッシュ - Argon2/bcryptの実装は標準的なパラメータを使用
- **1 (中リスク)**: TLS設定 - reject_unauthorizedデフォルト0は本番環境では要注意
- **1 (中リスク)**: XSS/CSRF対策 - ランタイムレベルでの保護がないことを明記
- **1 (中リスク)**: 入力検証 - NodeValidatorは存在するが、網羅的なサニタイゼーション機能は限定的

## 6) レビュアーチェックリスト（最小）
- [ ] BoringSSLのバージョンと既知の脆弱性の確認
- [ ] TLS設定のデフォルト値が本番環境で適切かの確認
- [ ] パスワードハッシュのデフォルトパラメータが現在のベストプラクティスに合致しているかの確認
- [ ] シークレット管理のプラットフォーム別実装状況の確認 (現在macOSのみ確認)
- [ ] bun:sqliteのSQLインジェクション対策の実装詳細確認
- [ ] WebCrypto API互換性の範囲確認
