---
generated_at: 2026-01-27 16:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **カバレッジ目標の数値**：明確な目標値がコードに記載されていない
  2. **QA担当の定義**：プロジェクト固有のQAプロセスの詳細が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/bun-main/CLAUDE.md` - プロジェクト概要、ビルド手順、テスト実行方法
- E-02: `/Users/tomoka.baba/Work/bun-main/test/CLAUDE.md` - テストスタイルガイド、ベストプラクティス
- E-03: `/Users/tomoka.baba/Work/bun-main/test/harness.ts` - テストヘルパー、ユーティリティ関数
- E-04: `/Users/tomoka.baba/Work/bun-main/test/package.json` - テスト依存関係
- E-05: `/Users/tomoka.baba/Work/bun-main/package.json` - プロジェクト設定、スクリプト定義
- E-06: `/Users/tomoka.baba/Work/bun-main/test/expectations.txt` - テスト期待値管理
- E-07: `/Users/tomoka.baba/Work/bun-main/scripts/runner.node.mjs` - テストランナースクリプト
- E-08: `/Users/tomoka.baba/Work/bun-main/.github/workflows/lint.yml` - リンティングワークフロー
- E-09: `/Users/tomoka.baba/Work/bun-main/.github/workflows/packages-ci.yml` - パッケージCIワークフロー
- E-10: `/Users/tomoka.baba/Work/bun-main/test/` ディレクトリ構成 - テストファイル配置
- E-11: テストファイル数カウント結果（1,196ファイル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BunはZigとC++で記述されたオールインワンJavaScriptランタイム | E-01 | ○ |
| C-02 | bun:testはJest互換テストランナー | E-01, E-02 | ○ |
| C-03 | テスト実行は`bun bd test`コマンドを使用 | E-01, E-02 | ○ |
| C-04 | テストファイルは約1,196ファイル | E-11 | ○ |
| C-05 | テストタイムアウトは通常3分、統合テスト5分 | E-07 | ○ |
| C-06 | harness.tsがテストヘルパーを提供 | E-03 | ○ |
| C-07 | bunEnvは環境変数セットを提供 | E-03 | ○ |
| C-08 | tempDir関数でテンポラリディレクトリ作成 | E-02, E-03 | ○ |
| C-09 | port: 0でランダムポート割り当て | E-01, E-02 | ○ |
| C-10 | expectations.txtでテスト期待値を管理 | E-06 | ○ |
| C-11 | 回帰テストはtest/regression/issue/に配置 | E-01, E-10 | ○ |
| C-12 | GitHub Actionsでlint.ymlワークフローを使用 | E-08 | ○ |
| C-13 | oxlintでJavaScriptリンティング | E-05, E-08 | ○ |
| C-14 | Prettierバージョン3.6.2+ | E-05 | ○ |
| C-15 | TypeScriptバージョン5.9.2 | E-05 | ○ |
| C-16 | clang-formatバージョン19を使用 | E-08 | ○ |
| C-17 | テストディレクトリ構成（js/bun, js/node, js/web等） | E-10 | ○ |
| C-18 | ASANビルドでメモリ安全性検証 | E-06, E-03 | ○ |
| C-19 | BuildKite CIで複数プラットフォームテスト | E-01 | ○ |
| C-20 | buildkite-failures.tsでCI失敗分析 | E-01, E-05 | ○ |
| C-21 | using/await usingでリソース自動クリーンアップ | E-02 | ○ |
| C-22 | ブランチ名はclaude/プレフィックス必須 | E-01 | ○ |
| C-23 | zig:check-allで全プラットフォームチェック | E-05 | ○ |
| C-24 | フィクスチャファイルは*-fixture.ts命名規則 | E-02 | ○ |
| C-25 | 動的importはテスト対象以外では禁止 | E-02 | ○ |
| C-26 | テストにタイムアウト設定は禁止 | E-02 | ○ |
| C-27 | カバレッジ目標の具体的数値（行/分岐） | **根拠なし** | △ |
| C-28 | QA担当者の具体的役割定義 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標の具体的数値**
  - プロジェクトコード内に行カバレッジ・分岐カバレッジの具体的な目標値が明記されていない
  - 候補：プロジェクト運用ドキュメント / チーム内規約 / CI設定

- **QA担当者の役割定義**
  - QAプロセスの詳細が明確に文書化されていない
  - 候補：チーム運用ドキュメント / 開発プロセス文書

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テストツール、テストディレクトリ構成、コマンド実行方法
- **0（低リスク）**: テストスタイルガイドライン、ベストプラクティス
- **1（中リスク）**: カバレッジ目標 - 具体的な数値目標が不明確
- **0（低リスク）**: CI/CD連携 - ワークフローファイルから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標値がプロジェクトの実際の方針と一致しているか確認
- [ ] QA担当者の役割がチームの実態と一致しているか確認
- [ ] テストタイムアウト値（3分/5分）が現状のCI設定と一致しているか確認
- [ ] テストファイル数（約1,196）が最新の状態を反映しているか確認
- [ ] BuildKite CI以外のCIツール利用がないか確認
