# テスト方針書

## 概要

本ドキュメントは、Bunプロジェクトのテスト方針を定義したものです。Bunは、バンドラー、テストランナー、Node.js互換パッケージマネージャーを含むオールインワンJavaScriptランタイムであり、主にZigとC++で記述されています。本書では、テスト戦略、テスト環境、使用ツール、カバレッジ目標、CI/CD連携について記載します。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々の関数、モジュール、APIの動作検証。JavaScript/TypeScriptコードおよびZigコードの機能確認 | 開発者 |
| 結合テスト | 複数コンポーネント間の連携検証。Node.js互換性、Web API互換性の確認 | 開発者 |
| システムテスト | Bunランタイム全体の動作検証。バンドラー、テストランナー、パッケージマネージャーの統合テスト | 開発者/QA |
| 受入テスト | サードパーティライブラリとの互換性検証（Next.js、Svelte、Express等） | 開発者/QA |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | Bun API、Node.js互換API、Web APIの機能検証 | 開発中、PR作成時 |
| 性能テスト | メモリリーク検出、リソース使用量監視 | 継続的（ASAN/LSANビルド） |
| セキュリティテスト | パッケージマネージャーのセキュリティスキャン、依存関係監査 | パッケージ操作時 |
| 回帰テスト | GitHub Issue起因のバグ修正確認 | バグ修正時 |
| 互換性テスト | Deno互換性、Node.js互換性、esbuild互換性テスト | 継続的 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者によるテスト実行 | macOS/Linux/Windows、Bun Debug Build（`bun bd`） |
| CI環境（BuildKite） | 自動テスト実行 | Linux (Ubuntu/Debian/Alpine/Amazon Linux)、macOS、Windows、FreeBSD |
| Docker環境 | Linux環境でのビルド・テスト | `ghcr.io/oven-sh/bun-development-docker-image` |
| ASAN/LSAN環境 | メモリ関連バグ検出 | Address Sanitizer、Leak Sanitizer有効ビルド |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| bun:test | Bun組み込みテストランナー（Jest互換） | Bun組み込み |
| harness.ts | テストヘルパー、ユーティリティ提供 | 内製 |
| Node.js（runner.node.mjs） | テストオーケストレーション（クラッシュ検出用） | Node.js環境 |
| oxlint | JavaScriptリンター | 0.15+ |
| Prettier | コードフォーマッター | 3.6.2+ |
| clang-format | C++コードフォーマッター | 19 |
| TypeScript | 型チェック | 5.9.2 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| テストファイル数 | 約1,196ファイル以上 |
| テスト実行タイムアウト | 通常: 3分、統合テスト: 5分 |
| 並列実行 | 利用可能なCPUコア数に応じた並列実行 |

## テストデータ

### テストファイル管理方針

- **単一ファイルテスト**: `bunExe()` + `-e` オプションを使用（`tempDir`不要）
- **複数ファイルテスト**: `tempDir("prefix", { files })` でテンポラリディレクトリを作成
- **フィクスチャファイル**: `*-fixture.ts` の命名規則を使用
- **ポート番号**: 常に `port: 0` を使用（ランダムポート割り当て）

### テストデータ生成

- `tempDir` 関数（harness.ts）を使用したテンポラリディレクトリ作成
- `bunEnv` 環境変数セットの使用（デバッグログ抑制、一貫した環境）
- `using` / `await using` によるリソース自動クリーンアップ

## 不具合管理

### テスト期待値管理

- `test/expectations.txt`: テスト期待値の管理ファイル
  - `[ FAIL ]`: 既知の失敗テスト
  - `[ FLAKY ]`: 不安定なテスト
  - `[ SKIP ]`: スキップするテスト
  - `[ CRASH ]`: クラッシュするテスト（ASAN環境等）
  - `[ TIMEOUT ]`: タイムアウトするテスト
  - `[ LEAK ]`: メモリリークを起こすテスト

### 回帰テスト管理

- GitHub Issue対応のテストは `test/regression/issue/${issueNumber}.test.ts` に配置
- Issue番号は実在するものを使用すること

### 不安定テストの扱い

- `isFlaky` / `isBroken` フラグ（CI環境でのみ有効）
- `test.todoIf(isFlaky && condition)` によるテスト条件付きスキップ

## CI/CD連携

### ビルド・テスト実行フロー

1. **ビルド**: `bun bd`（デバッグビルド、2.5分程度）
2. **テスト実行**: `bun bd test <test-file>`
3. **リリースビルド**: `bun build:release`

### GitHub Actions ワークフロー

| ワークフロー | 用途 |
| --- | --- |
| `lint.yml` | JavaScript/TypeScriptリンティング |
| `format.yml` | Prettier、clang-format、Zig fmtによるフォーマットチェック |
| `packages-ci.yml` | パッケージ（bun-plugin-svelte等）のCI |

### BuildKite CI

- 複数プラットフォーム（Linux、macOS、Windows、FreeBSD）での並列テスト実行
- ASANビルドによるメモリ安全性検証
- `scripts/buildkite-failures.ts` によるCI失敗分析

### テスト実行コマンド

```bash
# 単一テストファイル実行
bun bd test test/js/bun/http/serve.test.ts

# ファジーマッチによるテスト実行
bun bd test http/serve.test.ts

# フィルター付きテスト実行
bun bd test test/js/bun/http/serve.test.ts -t "should handle"

# デバッグログ有効化
BUN_DEBUG_QUIET_LOGS=0 bun bd test <file>

# 例外スコープ検証付き実行
BUN_JSC_validateExceptionChecks=1 BUN_JSC_dumpSimulatedThrows=1 bun bd <command>
```

### テスト作成ガイドライン

1. **テストランナー**: `bun:test`を使用（Jest互換API）
2. **インポート**: `harness`から`bunExe`、`bunEnv`、`tempDir`をインポート
3. **プロセス生成**: `Bun.spawn`を使用し、`bunEnv`環境変数を渡す
4. **リソース管理**: `using` / `await using`で自動クリーンアップ
5. **アサーション順序**: `stdout`/`stderr`を先にチェック、`exitCode`は最後
6. **タイムアウト禁止**: テストにタイムアウトを設定しない（Bun組み込みタイムアウトを使用）
7. **動的import禁止**: テスト対象以外では静的importを使用

## 備考

### テストディレクトリ構成

```
test/
├── js/
│   ├── bun/       # Bun固有APIテスト（http, crypto, ffi, shell等）
│   ├── node/      # Node.js互換性テスト
│   ├── web/       # Web APIテスト（fetch, WebSocket, streams等）
│   ├── deno/      # Deno互換性テスト
│   └── third_party/  # サードパーティライブラリテスト
├── cli/           # CLIコマンドテスト（install, run, test等）
├── bundler/       # バンドラー・トランスパイラテスト
├── integration/   # エンドツーエンド統合テスト
├── napi/          # N-API互換性テスト
├── v8/            # V8 C++ API互換性テスト
├── regression/    # GitHub Issue回帰テスト
│   └── issue/     # Issue番号別テストファイル
├── internal/      # 内部テスト
└── harness.ts     # テストヘルパー・ユーティリティ
```

### 重要な注意事項

- **`bun test`は使用禁止**: 開発中の変更をテストするには必ず`bun bd test`を使用
- **変更検証必須**: `USE_SYSTEM_BUN=1 bun test <file>`で失敗し、`bun bd test <file>`で成功することを確認
- **ブランチ命名**: CIのために`claude/`プレフィックスを使用
- **クロスプラットフォーム**: プラットフォーム固有の変更は`bun run zig:check-all`で全プラットフォームをチェック
