# ER図

## 概要

Bunプロジェクトはデータベースクライアント機能を提供するJavaScriptランタイムであり、アプリケーション固有の永続化テーブル（エンティティ）を持ちません。

本ドキュメントでは、Bunが提供するデータベースクライアントの内部構造とデータ型マッピングの関係を図示します。

## データベースクライアントアーキテクチャ

```mermaid
graph TB
    subgraph "Bun Runtime"
        JS[JavaScript/TypeScript コード]

        subgraph "Database Clients"
            SQLite[bun:sqlite]
            PG[PostgreSQL Client]
            MySQL[MySQL Client]
            Valkey[Valkey/Redis Client]
        end
    end

    subgraph "External Databases"
        SQLiteDB[(SQLite DB)]
        PGDB[(PostgreSQL)]
        MySQLDB[(MySQL)]
        ValkeyDB[(Valkey/Redis)]
    end

    JS --> SQLite
    JS --> PG
    JS --> MySQL
    JS --> Valkey

    SQLite --> SQLiteDB
    PG --> PGDB
    MySQL --> MySQLDB
    Valkey --> ValkeyDB
```

## PostgreSQLクライアント内部構造

```mermaid
erDiagram
    PostgresSQLConnection {
        Socket socket
        Status status
        string database
        string user
        string password
        SSLMode ssl_mode
        TLSStatus tls_status
    }

    PostgresSQLStatement {
        Signature signature
        Status status
        ErrorResponse error_response
    }

    PostgresSQLQuery {
        JSValue js_callback
        QueryState state
    }

    PostgresRequest {
        RequestType type
        PostgresSQLQuery query
    }

    DataCell {
        Tag tag
        bytes data
    }

    FieldDescription {
        string name
        int table_oid
        int column_attr
        int type_oid
        int type_len
    }

    PostgresSQLConnection ||--o{ PostgresRequest : "manages"
    PostgresSQLConnection ||--o{ PostgresSQLStatement : "caches"
    PostgresRequest ||--|| PostgresSQLQuery : "contains"
    PostgresSQLStatement ||--o{ FieldDescription : "describes"
    PostgresSQLQuery ||--o{ DataCell : "returns"
```

## MySQLクライアント内部構造

```mermaid
erDiagram
    MySQLConnection {
        Socket socket
        ConnectionState status
        Capabilities capabilities
        CharacterSet character_set
        string database
        string user
        string password
    }

    MySQLStatement {
        int statement_id
        Status status
        Signature signature
    }

    MySQLQuery {
        JSValue js_callback
        QueryState state
    }

    ColumnDefinition41 {
        string catalog
        string schema
        string table
        string name
        FieldType column_type
        ColumnFlags flags
    }

    Param {
        FieldType type
        ColumnFlags flags
    }

    MySQLConnection ||--o{ MySQLQuery : "executes"
    MySQLConnection ||--o{ MySQLStatement : "caches"
    MySQLStatement ||--o{ ColumnDefinition41 : "describes"
    MySQLStatement ||--o{ Param : "binds"
```

## SQLiteクライアント内部構造

```mermaid
erDiagram
    Database {
        handle db_handle
        string filename
        int internal_flags
        bool has_closed
    }

    Statement {
        handle raw
        bool is_finalized
    }

    TransactionController {
        Statement begin
        Statement commit
        Statement rollback
        Statement savepoint
        Statement release
    }

    Database ||--o{ Statement : "prepares"
    Database ||--|| TransactionController : "controls"
```

## データ型マッピング関係

```mermaid
graph LR
    subgraph "JavaScript Types"
        JS_String[string]
        JS_Number[number]
        JS_BigInt[bigint]
        JS_Boolean[boolean]
        JS_Date[Date]
        JS_Uint8Array[Uint8Array]
        JS_Object[object]
        JS_Null[null]
    end

    subgraph "PostgreSQL Types"
        PG_Text[text/varchar]
        PG_Int4[int4]
        PG_Int8[int8]
        PG_Bool[bool]
        PG_Timestamp[timestamp/timestamptz]
        PG_Bytea[bytea]
        PG_JSON[json/jsonb]
        PG_Float[float4/float8]
    end

    subgraph "MySQL Types"
        MY_String[VARCHAR/STRING]
        MY_Long[LONG]
        MY_LongLong[LONGLONG]
        MY_Tiny[TINY]
        MY_DateTime[DATETIME]
        MY_Blob[BLOB]
        MY_JSON[JSON]
        MY_Double[DOUBLE]
    end

    JS_String --> PG_Text
    JS_String --> MY_String
    JS_Number --> PG_Int4
    JS_Number --> PG_Float
    JS_Number --> MY_Long
    JS_Number --> MY_Double
    JS_BigInt --> PG_Int8
    JS_BigInt --> MY_LongLong
    JS_Boolean --> PG_Bool
    JS_Boolean --> MY_Tiny
    JS_Date --> PG_Timestamp
    JS_Date --> MY_DateTime
    JS_Uint8Array --> PG_Bytea
    JS_Uint8Array --> MY_Blob
    JS_Object --> PG_JSON
    JS_Object --> MY_JSON
```

## Valkey/Redisクライアント内部構造

```mermaid
erDiagram
    ValkeyContext {
        Status status
        Protocol protocol
        TLS tls_config
        ConnectionFlags flags
    }

    Command {
        string name
        args arguments
    }

    ConnectionFlags {
        bool is_authenticated
        bool is_manually_closed
        bool enable_offline_queue
        bool enable_auto_reconnect
        bool enable_auto_pipelining
    }

    ValkeyContext ||--o{ Command : "executes"
    ValkeyContext ||--|| ConnectionFlags : "has"
```

## 接続プロトコル状態遷移

```mermaid
stateDiagram-v2
    [*] --> Disconnected
    Disconnected --> Connecting : connect()
    Connecting --> Connected : handshake complete
    Connecting --> Failed : error
    Connected --> Disconnected : close()
    Connected --> Failed : connection lost
    Failed --> Connecting : reconnect
    Failed --> Disconnected : manual close
```

## 備考

- Bunは各データベースのプロトコルをZig言語でネイティブ実装しています
- エンティティ間の関係は内部データ構造を表しており、永続化されるデータベーススキーマではありません
- 実際のアプリケーションスキーマはユーザーが定義し、Bunクライアントを通じてアクセスします
