# データベース設計書

## 概要

本ドキュメントは、Bunプロジェクトにおけるデータベース関連機能の設計を記載したものです。

Bunは JavaScript/TypeScript ランタイムであり、アプリケーション固有のデータベーススキーマ（永続化テーブル）を持ちません。代わりに、以下のデータベースクライアント機能を提供しています:

- **SQLite** (`bun:sqlite`): 組み込みSQLiteクライアント
- **PostgreSQL** (`Bun.sql`): PostgreSQLネイティブクライアント
- **MySQL** (`Bun.sql`): MySQLネイティブクライアント
- **Valkey/Redis** (`Bun.redis`): Redis互換クライアント

本設計書では、これらのクライアント機能で扱われるデータ型とプロトコル構造について記載します。

## テーブル一覧

Bunプロジェクトはデータベースクライアント機能を提供するランタイムであり、アプリケーション固有の永続化テーブル定義は存在しません。

以下は、各データベースクライアントがサポートするデータ型マッピングの一覧です。

| データベース | 対応モジュール | 説明 |
| --- | --- | --- |
| SQLite | `bun:sqlite` | 組み込みSQLiteデータベースエンジン |
| PostgreSQL | `Bun.sql` (postgres) | PostgreSQLネイティブプロトコル実装 |
| MySQL | `Bun.sql` (mysql) | MySQLネイティブプロトコル実装 |
| Valkey/Redis | `Bun.redis` | RESP3プロトコル実装 |

## 各テーブル定義

### 1. SQLite データ型サポート

SQLiteクライアント (`bun:sqlite`) がサポートするデータ型マッピングです。

| JavaScript型 | SQLite型 | NULL | 説明 |
| --- | --- | --- | --- |
| string | TEXT | YES | 文字列データ |
| number | REAL/INTEGER | YES | 数値データ（浮動小数点または整数） |
| bigint | INTEGER | YES | 64ビット整数（safeIntegersオプション有効時） |
| boolean | INTEGER | YES | 真偽値（0または1） |
| Uint8Array/Buffer | BLOB | YES | バイナリデータ |
| null | NULL | YES | NULL値 |

**定数（src/js/bun/sqlite.ts）:**

| 定数名 | 値 | 説明 |
| --- | --- | --- |
| SQLITE_OPEN_READONLY | 0x00000001 | 読み取り専用モード |
| SQLITE_OPEN_READWRITE | 0x00000002 | 読み書きモード |
| SQLITE_OPEN_CREATE | 0x00000004 | 存在しない場合は作成 |
| SQLITE_OPEN_MEMORY | 0x00000080 | インメモリデータベース |
| SQLITE_OPEN_URI | 0x00000040 | URIファイル名を許可 |
| SQLITE_PREPARE_PERSISTENT | 0x01 | 永続的プリペアドステートメント |

### 2. PostgreSQL データ型サポート

PostgreSQLクライアント (`src/sql/postgres/`) がサポートするデータ型マッピングです（src/sql/postgres/types/Tag.zig より）。

| PostgreSQL型 | OID | JavaScript型 | 説明 |
| --- | --- | --- | --- |
| bool | 16 | boolean | 真偽値 |
| bytea | 17 | Uint8Array | バイナリデータ |
| char | 18 | string | 単一文字 |
| name | 19 | string | 識別子名 |
| int8 | 20 | bigint | 64ビット整数 |
| int2 | 21 | number | 16ビット整数 |
| int4 | 23 | number | 32ビット整数 |
| text | 25 | string | 可変長文字列 |
| json | 114 | object | JSONデータ |
| jsonb | 3802 | object | バイナリJSON |
| float4 | 700 | number | 単精度浮動小数点 |
| float8 | 701 | number | 倍精度浮動小数点 |
| varchar | 1043 | string | 可変長文字列 |
| date | 1082 | Date | 日付 |
| time | 1083 | string | 時刻 |
| timestamp | 1114 | Date | タイムスタンプ |
| timestamptz | 1184 | Date | タイムゾーン付きタイムスタンプ |
| numeric | 1700 | number | 任意精度数値 |
| uuid | 2950 | string | UUID |

**配列型:** 上記の各型には対応する配列型が存在します（例: int4_array, text_array）。

### 3. MySQL データ型サポート

MySQLクライアント (`src/sql/mysql/`) がサポートするデータ型マッピングです（src/sql/mysql/MySQLTypes.zig より）。

| MySQL型 | 型コード | JavaScript型 | 説明 |
| --- | --- | --- | --- |
| MYSQL_TYPE_DECIMAL | 0x00 | string | 固定小数点 |
| MYSQL_TYPE_TINY | 0x01 | boolean/number | 8ビット整数 |
| MYSQL_TYPE_SHORT | 0x02 | number | 16ビット整数 |
| MYSQL_TYPE_LONG | 0x03 | number | 32ビット整数 |
| MYSQL_TYPE_FLOAT | 0x04 | number | 単精度浮動小数点 |
| MYSQL_TYPE_DOUBLE | 0x05 | number | 倍精度浮動小数点 |
| MYSQL_TYPE_NULL | 0x06 | null | NULL値 |
| MYSQL_TYPE_TIMESTAMP | 0x07 | Date | タイムスタンプ |
| MYSQL_TYPE_LONGLONG | 0x08 | bigint | 64ビット整数 |
| MYSQL_TYPE_INT24 | 0x09 | number | 24ビット整数（MEDIUMINT） |
| MYSQL_TYPE_DATE | 0x0a | Date | 日付 |
| MYSQL_TYPE_TIME | 0x0b | number | 時刻（ミリ秒） |
| MYSQL_TYPE_DATETIME | 0x0c | Date | 日時 |
| MYSQL_TYPE_YEAR | 0x0d | number | 年 |
| MYSQL_TYPE_VARCHAR | 0x0f | string | 可変長文字列 |
| MYSQL_TYPE_BIT | 0x10 | number | ビットフィールド |
| MYSQL_TYPE_JSON | 0xf5 | object | JSONデータ |
| MYSQL_TYPE_BLOB | 0xfc | Uint8Array | バイナリラージオブジェクト |
| MYSQL_TYPE_STRING | 0xfe | string | 固定長文字列 |

**カラムフラグ（ColumnDefinition41.ColumnFlags）:**

| フラグ名 | 説明 |
| --- | --- |
| NOT_NULL | NULL禁止 |
| PRI_KEY | プライマリキー |
| UNIQUE_KEY | ユニークキー |
| MULTIPLE_KEY | 複合キーの一部 |
| BLOB | BLOBカラム |
| UNSIGNED | 符号なし |
| ZEROFILL | ゼロ埋め |
| BINARY | バイナリ |
| ENUM | 列挙型 |
| AUTO_INCREMENT | 自動増分 |
| TIMESTAMP | タイムスタンプ |
| SET | SET型 |

### 4. Valkey/Redis データ型サポート

Valkeyクライアント (`src/valkey/`) がサポートするプロトコル情報です。

| プロトコル | 説明 |
| --- | --- |
| valkey/redis | 標準TCP接続 |
| valkeys/rediss | TLS暗号化接続 |
| valkey+unix/redis+unix | Unixソケット接続 |
| valkey+tls+unix/redis+tls+unix | TLS + Unixソケット |

**接続状態:**

| 状態 | 説明 |
| --- | --- |
| disconnected | 切断状態 |
| connecting | 接続中 |
| connected | 接続完了 |

## 備考

### アーキテクチャ上の特徴

1. **クライアントライブラリとしての設計**: Bunはデータベースサーバーではなく、各種データベースへの接続クライアント機能を提供します。実際のスキーマ定義はユーザーアプリケーション側で行います。

2. **ネイティブプロトコル実装**: PostgreSQLおよびMySQLクライアントは、libpqやmysql-clientのようなCライブラリに依存せず、Zig言語で直接プロトコルを実装しています。

3. **型安全なバインディング**: JavaScriptの値からデータベース固有の型への変換は、厳密な型チェックとバリデーションを伴って行われます。

4. **コネクション管理**: 各データベースクライアントは、接続プーリング、自動再接続、TLS/SSL対応などの機能を備えています。

### ファイル構成

| ディレクトリ/ファイル | 説明 |
| --- | --- |
| `src/js/bun/sqlite.ts` | SQLite JavaScript API |
| `src/sql/postgres/` | PostgreSQLプロトコル実装 |
| `src/sql/mysql/` | MySQLプロトコル実装 |
| `src/sql/shared/` | 共通データ構造 |
| `src/valkey/` | Valkey/Redisクライアント実装 |

### テスト用データベース設定

開発・テスト用のPostgreSQL初期化スクリプト（`test/docker/init-scripts/postgres/01-init.sql`）が含まれています:

- ユーザー: `bun_sql_test`, `bun_sql_test_md5`, `bun_sql_test_scram`
- データベース: `bun_sql_test`
- 認証方式: trust, MD5, SCRAM-SHA-256
