---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目で根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/auto-close-duplicates.ts`
- E-02: `scripts/label-issue.ts`
- E-03: `scripts/handle-crash-patterns.ts`
- E-04: `scripts/buildkite-failures.ts`
- E-05: `scripts/buildkite-slow-tests.js`
- E-06: `scripts/sort-imports.ts`
- E-07: `scripts/sync-webkit-source.ts`
- E-08: `scripts/fetch-node-test.ts`
- E-09: `scripts/github-metrics.ts`
- E-10: `scripts/build-jsc.ts`
- E-11: `scripts/read-issue.ts`
- E-12: `scripts/associate-issue-with-sentry.ts`
- E-13: `scripts/debug-coredump.ts`
- E-14: `scripts/cleartrace.ts`
- E-15: `src/css/properties/generate_properties.ts`
- E-16: `src/bun.js/bindings/libuv/generate_uv_posix_stubs.ts`
- E-17: `scripts/nav2readme.ts`
- E-18: `scripts/bump.ts`
- E-19: `scripts/pack-codegen-for-zig-team.ts`
- E-20: `scripts/is-outdated.ts`
- E-21: `package.json`（npm scripts定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | auto-close-duplicates.tsは重複Issueを自動クローズする | E-01 | ○ |
| C-02 | label-issue.tsはClaude AIを使用してラベルを自動付与する | E-02 | ○ |
| C-03 | handle-crash-patterns.tsは既知のクラッシュパターンを検出する | E-03 | ○ |
| C-04 | buildkite-failures.tsはBuildKiteビルド失敗を分析する | E-04 | ○ |
| C-05 | buildkite-slow-tests.jsは遅いテストを分析する | E-05 | ○ |
| C-06 | sort-imports.tsはimport文をソートする | E-06 | ○ |
| C-07 | sync-webkit-source.tsはWebKitソースを同期する | E-07 | ○ |
| C-08 | fetch-node-test.tsはNode.jsテストファイルを取得する | E-08 | ○ |
| C-09 | github-metrics.tsはGitHubメトリクスを収集する | E-09 | ○ |
| C-10 | build-jsc.tsはJavaScriptCoreをビルドする | E-10, E-21 | ○ |
| C-11 | read-issue.tsはGitHub Issueを読み込む | E-11 | ○ |
| C-12 | associate-issue-with-sentry.tsはSentryとIssueを紐付ける | E-12 | ○ |
| C-13 | debug-coredump.tsはコアダンプを解析する | E-13 | ○ |
| C-14 | cleartrace.tsはスタックトレースをクリーニングする | E-14 | ○ |
| C-15 | generate_properties.tsはCSSプロパティ定義を生成する | E-15, E-21 | ○ |
| C-16 | generate_uv_posix_stubs.tsはlibuvのPOSIXスタブを生成する | E-16, E-21 | ○ |
| C-17 | nav2readme.tsはナビゲーションからREADMEを生成する | E-17 | ○ |
| C-18 | bump.tsはバージョンをバンプする | E-18, E-21 | ○ |
| C-19 | pack-codegen-for-zig-team.tsはZigチーム向けにパッケージ化する | E-19 | ○ |
| C-20 | is-outdated.tsは依存関係の陳腐化をチェックする | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのバッチ処理についてソースコードの実在を確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての項目がソースコードに基づいて記述されており、信頼性が高い

**注意事項:**
- 本プロジェクト（Bun）はJavaScriptランタイムであり、伝統的な業務システムの「バッチ処理」（定期実行ジョブ、夜間バッチなど）とは性質が異なる
- scriptsディレクトリ内のツールは、CI/CDパイプラインやGitHub Actionsから呼び出される自動化スクリプトとして機能する
- 一部のスクリプト（auto-close-duplicates.ts、label-issue.ts等）はGitHub Actionsワークフローで定期実行されるため、バッチ処理として分類した

## 6) レビュアーチェックリスト（最小）
- [ ] バッチ名がソースファイル名と一致しているか確認
- [ ] 説明がソースコードの実際の処理内容と一致しているか確認
- [ ] 備考に記載された環境変数やnpm scripts名が正確か確認
- [ ] カテゴリの分類が適切か確認
