# バッチ設計書 1-auto-close-duplicates

## 概要

本ドキュメントは、GitHub Issueの重複自動クローズ処理バッチ「auto-close-duplicates.ts」の設計仕様を記載する。

### 本バッチの処理概要

重複と判定されたGitHub Issueを自動的にクローズする処理を行う。dedupe-botによる重複検出コメントを基に、一定期間経過後に人間による反対意見がない場合にIssueを自動クローズする。

**業務上の目的・背景**：GitHub Issueリポジトリでは、同一の問題が複数のIssueとして報告されることがある。重複Issueが放置されると、開発チームの作業負荷が増加し、Issue管理が煩雑になる。本バッチは、dedupe-botが検出した重複Issueを自動的にクローズすることで、Issue管理の効率化とリポジトリの整理を実現する。

**バッチの実行タイミング**：GitHub Actionsワークフローによる定期実行（スケジュール設定による）。

**主要な処理内容**：
1. GITHUB_TOKEN環境変数を使用してGitHub APIへの認証を行う
2. リポジトリ内のオープン状態のIssue一覧を取得（3日以上前に作成されたもの）
3. 各Issueのコメントを確認し、dedupe-botによる重複検出マーカーを探す
4. 重複コメントが3日以上経過しており、かつ人間による反対意見（コメントやthumbsdownリアクション）がない場合、Issueをクローズ対象とする
5. Issueが過去に再オープンされた履歴がないことを確認する
6. 条件を満たすIssueを「duplicate」としてクローズし、説明コメントを追加する

**前後の処理との関連**：dedupe-botによる重複検出処理が先行して実行されている必要がある。本バッチはその検出結果を利用して自動クローズを行う。

**影響範囲**：oven-sh/bunリポジトリ内のGitHub Issueのステータス（オープン→クローズ）に影響する。

## バッチ種別

データ連携 / 自動運用

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（GitHub Actionsスケジュール） |
| 実行時刻 | ワークフロー設定による |
| 実行曜日 | 毎日 |
| 実行日 | - |
| トリガー | cron（GitHub Actions） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GITHUB_TOKEN | GitHub API認証用トークンが環境変数として設定されていること |
| dedupe-bot | 重複検出botが事前に稼働し、重複Issueにコメントを付与していること |
| リポジトリアクセス | GITHUB_REPOSITORYが正しく設定されていること（デフォルト: oven-sh/bun） |

### 実行可否判定

- GITHUB_TOKENが未設定の場合はエラー終了
- GITHUB_REPOSITORYの形式が「owner/repo」でない場合はエラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GITHUB_TOKEN | string | Yes | - | GitHub API認証トークン |
| GITHUB_REPOSITORY | string | No | oven-sh/bun | 対象リポジトリ（owner/repo形式） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub Issues API | REST API | オープン状態のIssue一覧 |
| GitHub Comments API | REST API | Issue毎のコメント一覧 |
| GitHub Reactions API | REST API | コメントへのリアクション一覧 |
| GitHub Events API | REST API | Issueのイベント履歴（再オープン確認用） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Issues API | REST API | Issueのステータス更新（クローズ） |
| GitHub Comments API | REST API | クローズ時のコメント追加 |
| 標準出力 | テキスト | 処理ログ |

### 出力ファイル仕様

ファイル出力なし（API経由でGitHubに直接書き込み）

## 処理フロー

### 処理シーケンス

```
1. 環境変数チェック
   └─ GITHUB_TOKEN、GITHUB_REPOSITORYの検証

2. オープンIssue取得
   └─ 3日以上前に作成されたIssueをページネーション取得（最大20ページ）

3. Issue毎のループ処理
   └─ Pull Requestを除外し、各Issueを処理

4. コメント取得・分析
   └─ dedupe-botの重複検出コメント（<!-- dedupe-bot:marker -->）を探す

5. 重複コメントの経過日数確認
   └─ 最新の重複コメントが3日以上経過しているか確認

6. 人間活動の確認
   └─ 重複コメント以降の人間によるコメントがないか確認

7. リアクション確認
   └─ 重複コメントへのthumbsdownリアクションがないか確認

8. 再オープン履歴確認
   └─ Issueが過去に再オープンされていないか確認

9. 重複Issue番号の抽出
   └─ コメント本文から重複先Issue番号を抽出

10. Issueクローズ
    └─ state=closed, state_reason=duplicateでPATCH + コメント追加
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数チェック]
    B --> C[オープンIssue取得]
    C --> D{Issue残あり?}
    D -->|あり| E[コメント取得]
    E --> F{dedupe-botコメントあり?}
    F -->|なし| D
    F -->|あり| G{3日以上経過?}
    G -->|いいえ| D
    G -->|はい| H{人間コメントあり?}
    H -->|あり| D
    H -->|なし| I{thumbsdownあり?}
    I -->|あり| D
    I -->|なし| J{再オープン履歴あり?}
    J -->|あり| D
    J -->|なし| K[Issueクローズ]
    K --> D
    D -->|なし| L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用せず、GitHub APIを介してデータを操作する。

| 処理 | 対象API | 操作種別 | 概要 |
|-----|---------|---------|------|
| Issue取得 | /repos/{owner}/{repo}/issues | GET | オープンIssue一覧取得 |
| コメント取得 | /repos/{owner}/{repo}/issues/{number}/comments | GET | Issue毎のコメント取得 |
| リアクション取得 | /repos/{owner}/{repo}/issues/comments/{id}/reactions | GET | コメントリアクション取得 |
| イベント取得 | /repos/{owner}/{repo}/issues/{number}/events | GET | Issue再オープン履歴確認 |
| Issueクローズ | /repos/{owner}/{repo}/issues/{number} | PATCH | Issueステータス更新 |
| コメント追加 | /repos/{owner}/{repo}/issues/{number}/comments | POST | クローズコメント追加 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | GITHUB_TOKEN未設定 | エラーメッセージ出力後終了 |
| 429/403 | レート制限 | GitHub APIレート制限超過 | 指数バックオフでリトライ |
| - | API失敗 | GitHub APIリクエスト失敗 | エラーログ出力、処理継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 3回 |
| リトライ間隔 | 指数バックオフ（1秒、2秒、4秒...最大32秒） |
| リトライ対象エラー | 429（レート制限）、403（アクセス制限） |

### 障害時対応

- 個別Issueのクローズ失敗時はエラーログを出力し、次のIssueの処理を継続
- 致命的エラー（認証失敗等）の場合はバッチ終了

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | Issue単位（各Issueのクローズは独立） |
| コミットタイミング | 各Issue処理完了時（即時） |
| ロールバック条件 | なし（GitHub API側で管理） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大2000件（100件/ページ x 20ページ） |
| 目標処理時間 | 特に制限なし（GitHub APIレート制限に依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定していない。GitHub Actionsのワークフロー設定で単一実行を保証。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Starting auto-close duplicates script" |
| 進捗ログ | Issue処理中 | Issue番号、タイトル、処理状況 |
| 成功ログ | Issueクローズ成功時 | "Successfully closed issue #X as duplicate of #Y" |
| エラーログ | エラー発生時 | エラー詳細 |
| 終了ログ | バッチ終了時 | 処理件数、クローズ候補件数 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | - | GitHub Actions UI |
| エラー件数 | - | GitHub Actions UI |

## 備考

- GitHub APIのレート制限（残り100リクエスト未満）で警告ログを出力
- 残り10リクエスト未満の場合はリセット時刻まで待機
- Issue取得のページネーションは安全のため最大20ページに制限
- コメント・リアクション取得も同様に最大20ページ制限
