# バッチ設計書 10-build-jsc

## 概要

本ドキュメントは、JavaScriptCoreのビルド処理バッチ「build-jsc.ts」の設計仕様を記載する。

### 本バッチの処理概要

WebKitのJavaScriptCoreエンジンをrelease、debug、ltoの各モードでビルドする。Bunの実行エンジンとなるJavaScriptCoreをソースからコンパイルする。

**業務上の目的・背景**：BunはWebKitのJavaScriptCoreエンジンを使用しており、カスタマイズされたバージョンをビルドする必要がある。本バッチはクロスプラットフォーム（macOS、Linux、Windows）に対応し、各プラットフォーム固有の設定を自動的に適用してJavaScriptCoreをビルドする。これにより開発者は簡単にJSCをビルドできる。

**バッチの実行タイミング**：開発者が手動で実行（随時）。npm scriptsでjsc:build、jsc:build:debug、jsc:build:ltoとして定義。

**主要な処理内容**：
1. コマンドライン引数からビルド設定（debug/release/lto）を取得
2. プラットフォーム（macOS/Linux/Windows）とアーキテクチャ（x64/ARM64）を検出
3. ccacheの有無を確認し、利用可能であれば使用
4. CMakeフラグを設定（プラットフォーム固有設定を含む）
5. CMakeでconfigure実行
6. CMakeでビルド実行

**前後の処理との関連**：sync-webkit-source.tsで同期されたWebKitソースを使用してビルドする。

**影響範囲**：vendor/WebKit/WebKitBuild/配下にビルド成果物を生成する。

## バッチ種別

ビルドツール / コンパイル

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 / npm scripts |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| vendor/WebKit | WebKitソースディレクトリが存在すること |
| CMake | CMakeがインストールされていること |
| Ninja | Ninjaビルドシステムがインストールされていること |
| Clang | clang/clang++コンパイラがインストールされていること |
| ICU（Windows） | vcpkg経由でICUがインストールされていること |

### 実行可否判定

- 不正なビルド設定（debug/release/lto以外）が指定された場合はエラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| config | string | No | debug | ビルド設定（debug/release/lto） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| vendor/WebKit | ディレクトリ | WebKitソースコード |
| cmake/tools/SetupWebKit.cmake | テキスト | ビルド設定参照 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| vendor/WebKit/WebKitBuild/{Config}/ | バイナリ | ビルド成果物 |
| 標準出力 | テキスト | ビルドログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ディレクトリ | Debug / Release / ReleaseLTO |
| 主要成果物 | JSC実行ファイル、ライブラリ |

## 処理フロー

### 処理シーケンス

```
1. ビルド設定パース
   └─ コマンドライン引数からdebug/release/ltoを取得

2. プラットフォーム検出
   └─ OS（macOS/Linux/Windows）とアーキテクチャ（x64/ARM64）を検出

3. ツール検出
   └─ ccache、clang、lld-link等の存在確認

4. パス設定
   └─ WebKitディレクトリ、ビルドディレクトリ、ICUパス（Windows）を設定

5. CMakeフラグ構築
   └─ 共通フラグ + プラットフォーム固有フラグ + ビルド設定フラグ

6. ディレクトリ作成
   └─ ビルドディレクトリが存在しない場合は作成

7. CMake configure
   └─ cmake コマンドでプロジェクト設定

8. CMake build
   └─ cmake --build コマンドでjscターゲットをビルド

9. 完了メッセージ
   └─ ビルド成功メッセージとパスを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{ビルド設定有効?}
    B -->|いいえ| C[エラー終了]
    B -->|はい| D[プラットフォーム検出]
    D --> E[ツール検出]
    E --> F[パス設定]
    F --> G[CMakeフラグ構築]
    G --> H{ビルドディレクトリ存在?}
    H -->|いいえ| I[ディレクトリ作成]
    H -->|はい| J[CMake configure]
    I --> J
    J --> K{成功?}
    K -->|いいえ| L[エラー終了]
    K -->|はい| M[CMake build]
    M --> N{成功?}
    N -->|いいえ| L
    N -->|はい| O[完了メッセージ]
    O --> P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 設定エラー | 不正なビルド設定 | 有効な設定リストを表示して終了 |
| - | コマンド失敗 | CMake実行失敗 | エラーメッセージ表示、exit code伝播 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- CMake configure/build失敗時はexit codeを伝播して終了

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド |
| 目標処理時間 | 数分〜数十分（環境依存） |
| メモリ使用量上限 | ビルドに必要なメモリ（数GB） |

## 排他制御

同一ビルドディレクトリへの同時ビルドは想定しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 設定ログ | 処理開始時 | ビルド設定、ビルドディレクトリ |
| ccacheログ | ツール検出時 | ccache使用有無 |
| CMakeログ | CMake実行時 | CMakeコマンド（spawnSyncのstdio: inherit） |
| 完了ログ | ビルド成功時 | "JSC build completed successfully!" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

## 備考

### ビルド設定別ディレクトリ

| 設定 | ディレクトリ | CMake BUILD_TYPE |
|-----|------------|------------------|
| debug | WebKitBuild/Debug | Debug |
| release | WebKitBuild/Release | RelWithDebInfo |
| lto | WebKitBuild/ReleaseLTO | Release |

### プラットフォーム固有設定

#### macOS
- ENABLE_SINGLE_THREADED_VM_ENTRY_SCOPE=ON
- BUN_FAST_TLS=ON
- PTHREAD_JIT_PERMISSIONS_API=1
- ENABLE_REMOTE_INSPECTOR=ON
- ICU_INCLUDE_DIRS: Homebrew ICU

#### Linux
- JSEXPORT_PRIVATE=WTF_EXPORT_DECLARATION
- USE_VISIBILITY_ATTRIBUTE=1
- ENABLE_REMOTE_INSPECTOR=ON

#### Windows
- USE_SYSTEM_MALLOC=ON
- lld-linkをリンカーとして使用
- vcpkg ICUを使用（静的リンク）
- U_STATIC_IMPLEMENTATION定義

### debug設定の追加オプション

- ENABLE_BUN_SKIP_FAILING_ASSERTIONS=ON
- CMAKE_EXPORT_COMPILE_COMMANDS=ON（IDEサポート）
- ENABLE_SANITIZERS=address（macOS/Linux）

### lto設定の追加オプション

- -flto=fullフラグ追加

### ccache対応

ccacheが検出された場合、CMAKE_C_COMPILER_LAUNCHERとCMAKE_CXX_COMPILER_LAUNCHERに設定してビルド高速化。

### 共通CMakeフラグ

- PORT=JSCOnly
- ENABLE_STATIC_JSC=ON
- ALLOW_LINE_AND_COLUMN_NUMBER_IN_BUILTINS=ON
- USE_THIN_ARCHIVES=OFF
- USE_BUN_JSC_ADDITIONS=ON
- USE_BUN_EVENT_LOOP=ON
- ENABLE_FTL_JIT=ON
- Generator: Ninja
