# バッチ設計書 11-read-issue.ts

## 概要

本ドキュメントは、GitHub Issueの本文を解析してラベルを自動付与するためのバッチ処理「read-issue.ts」の設計書です。

### 本バッチの処理概要

GitHub Issueの本文（GITHUB_ISSUE_BODY環境変数）を解析し、Issue内容に基づいて適切なラベルを自動的に判定・出力するバッチ処理です。

**業務上の目的・背景**：Bunプロジェクトには多数のIssueが報告されるため、手動でのラベル付けは非効率です。このバッチは、Issue本文のパターンマッチングにより、コマンド種別（jest/bundler/npm等）やプラットフォーム（macos/linux/windows）、機能カテゴリ（runtime/shell等）を自動判定し、適切なラベルを提案することで、Issue管理の効率化を実現します。

**バッチの実行タイミング**：GitHub Actionsワークフローにおいて、新規Issue作成時またはIssue更新時にトリガーされます。イベント駆動型の実行です。

**主要な処理内容**：
1. 環境変数GITHUB_ISSUE_BODYからIssue本文を取得
2. Issue本文内の特定パターン（[TestCommand]、[BuildCommand]等）を検出してコマンド種別を判定
3. Features行を解析してJSC、Shell等の機能カテゴリを抽出
4. バージョン情報行からプラットフォーム（macOS/Linux/Windows）を検出
5. 検出されたラベルをカンマ区切りで標準出力に出力

**前後の処理との関連**：GitHub Actionsワークフローの一部として動作し、出力されたラベルはgh CLIやGitHub APIを通じてIssueに付与されます。label-issue.tsと連携して動作する場合があります。

**影響範囲**：GitHub IssueのラベルのみがIssue本文に記載されている場合のみに影響します。Issue本文やコメントの変更は行いません。

## バッチ種別

データ解析 / ラベル判定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（Issue作成/更新時） |
| 実行時刻 | 随時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | GitHub Actions（Issue作成/更新イベント） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GITHUB_ISSUE_BODY | 環境変数にIssue本文が設定されていること |

### 実行可否判定

GITHUB_ISSUE_BODY環境変数が設定されていない場合、エラーをスローして終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GITHUB_ISSUE_BODY | string | Yes | なし | GitHub Issue本文（環境変数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 | 文字列 | GitHub Issue本文テキスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | カンマ区切りのラベル一覧 |

### 出力ファイル仕様

ファイル出力はありません。標準出力にラベルを出力します。

| 項目 | 内容 |
|-----|------|
| 出力形式 | カンマ区切り文字列 + 改行 |
| 出力例 | `runtime,macos` |

## 処理フロー

### 処理シーケンス

```
1. 環境変数取得
   └─ GITHUB_ISSUE_BODYを取得、未設定時はエラー

2. コマンド種別判定
   └─ [TestCommand]、[BuildCommand]、[InstallCommand]等のパターンを検出

3. 機能カテゴリ抽出
   └─ "Features: "行からjsc、shell等を抽出

4. プラットフォーム判定
   └─ "Bun v... on ..."形式の行からOS種別を検出

5. 結果出力
   └─ 検出されたラベルをカンマ区切りで出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{GITHUB_ISSUE_BODY存在?}
    B -->|なし| C[エラー終了]
    B -->|あり| D[コマンド種別判定]
    D --> E[Features行解析]
    E --> F[プラットフォーム判定]
    F --> G{ラベルあり?}
    G -->|あり| H[ラベル出力]
    G -->|なし| I[何も出力しない]
    H --> J[バッチ終了]
    I --> J
```

## データベース操作仕様

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | GITHUB_ISSUE_BODY未設定 | 環境変数を設定して再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

環境変数が正しく設定されているか確認し、GitHub Actionsワークフローの設定を見直してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件/実行 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行可能です。排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | ラベル検出時 | カンマ区切りラベル一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特になし | - | - |

## 備考

- このバッチはlabel-issue.tsとは異なり、Claude AIを使用しません
- パターンマッチングベースの軽量なラベル判定処理です
- バッチ一覧.csvの説明文に記載されている「GitHub Issueの読み込み処理」は、実際のコードの動作とは異なり、ラベル判定処理が主目的です
