# バッチ設計書 12-associate-issue-with-sentry.ts

## 概要

本ドキュメントは、GitHub IssueとSentryのクラッシュレポートを紐付けるバッチ処理「associate-issue-with-sentry.ts」の設計書です。

### 本バッチの処理概要

GitHub Issue本文からSentry IDを抽出し、Sentry APIを通じて該当するクラッシュレポートの情報を取得して、IssueとSentryを関連付けるための情報をファイルに出力するバッチ処理です。

**業務上の目的・背景**：Bunのクラッシュレポートは自動的にSentryに送信されます。ユーザーがクラッシュを報告するGitHub Issueには、Sentry IDが埋め込まれている場合があります。このバッチは、IssueとSentryのクラッシュレポートを紐付けることで、開発者がクラッシュの詳細情報（スタックトレース、環境情報等）に素早くアクセスできるようにし、バグ修正の効率化を図ります。

**バッチの実行タイミング**：GitHub Actionsワークフローにおいて、クラッシュレポートを含むIssueが作成または更新された際にトリガーされます。

**主要な処理内容**：
1. 環境変数からGitHub Issue本文とSentry認証トークンを取得
2. Issue本文から`<!-- sentry_id: xxx -->`形式のコメントを検出してSentry IDを抽出
3. Sentry APIを呼び出してイベントIDからグループIDを取得
4. グループIDからIssue詳細（shortId、permalink）を取得
5. 取得した情報をsentry-id.txtとsentry-link.txtに出力

**前後の処理との関連**：出力されたファイル（sentry-id.txt、sentry-link.txt）は、後続のGitHub Actionsステップでコメント追加やラベル付与に使用されます。

**影響範囲**：ローカルファイルシステムへの出力のみで、GitHub IssueやSentryの状態は変更しません。

## バッチ種別

データ連携 / API呼び出し

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（Issue作成/更新時） |
| 実行時刻 | 随時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | GitHub Actions（Issue作成/更新イベント） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GITHUB_ISSUE_BODY | 環境変数にIssue本文が設定されていること |
| SENTRY_AUTH_TOKEN | 環境変数にSentry認証トークンが設定されていること |
| Issue本文にSentry ID | `<!-- sentry_id: xxx -->`形式のコメントが含まれていること |

### 実行可否判定

- GITHUB_ISSUE_BODYまたはSENTRY_AUTH_TOKENが未設定の場合、エラーをスローして終了
- Issue本文にsentry_idコメントが含まれない場合、エラーをスローして終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GITHUB_ISSUE_BODY | string | Yes | なし | GitHub Issue本文（環境変数） |
| SENTRY_AUTH_TOKEN | string | Yes | なし | Sentry API認証トークン（環境変数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 | 文字列 | GitHub Issue本文とSentry認証情報 |
| Sentry API | JSON | イベント情報とIssue情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| sentry-id.txt | テキスト | SentryのshortId |
| sentry-link.txt | テキスト | Sentryへのパーマリンク |
| 標準出力 | テキスト | 処理結果のログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sentry-id.txt, sentry-link.txt |
| 出力先 | カレントディレクトリ |
| 文字コード | UTF-8 |
| 内容 | 単一行のテキスト |

## 処理フロー

### 処理シーケンス

```
1. 環境変数取得
   └─ GITHUB_ISSUE_BODY, SENTRY_AUTH_TOKENを取得

2. 入力検証
   └─ 環境変数未設定時はエラー終了

3. Sentry ID抽出
   └─ Issue本文から<!-- sentry_id: xxx -->を検出

4. Sentry イベントAPI呼び出し
   └─ /api/0/organizations/{org}/eventids/{eventId}/

5. グループID取得
   └─ レスポンスからgroupIdを抽出

6. Sentry Issue API呼び出し
   └─ /api/0/issues/{groupId}/

7. 結果取得・出力
   └─ shortIdとpermalinkをファイル出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{環境変数チェック}
    B -->|未設定| C[エラー終了]
    B -->|OK| D[Sentry ID抽出]
    D --> E{ID存在?}
    E -->|なし| F[エラー終了]
    E -->|あり| G[Sentry Event API呼出]
    G --> H{API成功?}
    H -->|失敗| I[エラー終了]
    H -->|成功| J[Sentry Issue API呼出]
    J --> K{API成功?}
    K -->|失敗| L[エラー終了]
    K -->|成功| M[ファイル出力]
    M --> N[バッチ終了]
```

## データベース操作仕様

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | 環境変数未設定 | 環境変数を設定して再実行 |
| - | Error | sentry_id未検出 | Issue本文にSentry IDを含めて再実行 |
| - | Error | Sentry Event API失敗 | Sentry認証トークンとIDを確認 |
| - | Error | Sentry Issue API失敗 | groupIdの有効性を確認 |
| - | Error | shortId/permalink未取得 | Sentry側のデータを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 環境変数の設定状況を確認
2. Sentry認証トークンの有効性を確認
3. Issue本文のsentry_idフォーマットを確認
4. Sentry APIの稼働状況を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件/実行 |
| 目標処理時間 | 5秒以内（API応答時間に依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行可能です。排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | Sentry ID取得後 | `Sentry ID: {shortId}` |
| 標準出力 | permalink取得後 | `Sentry permalink: {permalink}` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| API応答時間 | 10秒 | GitHub Actions通知 |
| APIエラー | 発生時 | GitHub Actions通知 |

## 備考

- Sentry組織ID `4507155222364160` はハードコードされています
- 認証にはBearer tokenを使用します
- 出力ファイルは後続のGitHub Actionsステップで参照されることを想定しています
