# バッチ設計書 13-debug-coredump.ts

## 概要

本ドキュメントは、BuildKite CIでのクラッシュ時に生成されたコアダンプファイルを解析するためのバッチ処理「debug-coredump.ts」の設計書です。

### 本バッチの処理概要

BuildKite CIビルドで発生したクラッシュのコアダンプファイルをダウンロード・復号化し、lldb等のデバッガを起動してデバッグ情報を解析するためのバッチ処理です。

**業務上の目的・背景**：Bunのテスト実行中にクラッシュが発生した場合、原因究明のためにコアダンプの解析が必要です。BuildKite CIでは、クラッシュ時のコアダンプがageで暗号化されてアーティファクトとして保存されます。このバッチは、そのコアダンプをダウンロード・復号化し、デバッガを起動することで、開発者がローカル環境でクラッシュの原因を調査できるようにします。

**バッチの実行タイミング**：BuildKite CIでクラッシュが発生した後、開発者が手動で実行します。

**主要な処理内容**：
1. コマンドライン引数からPID、ビルドURL、コアダンプURLを取得
2. bun-profile.zip（デバッグシンボル付きバイナリ）をダウンロード・展開
3. bun-cores.tar.gz.age（暗号化されたコアダンプ）をダウンロード・復号化・展開
4. 指定されたPIDに対応するコアダンプファイルを特定
5. lldb（またはカスタムデバッガ）を起動してデバッグセッションを開始

**前後の処理との関連**：BuildKiteビルド失敗後に手動実行される独立したツールです。buildkite-failures.tsでビルド失敗の詳細を確認した後に使用することが多いです。

**影響範囲**：ローカルの一時ディレクトリにファイルをダウンロード・展開するのみで、リモートシステムへの影響はありません。

## バッチ種別

デバッグ支援 / ファイル処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| AGE_CORES_IDENTITY | 環境変数にageの秘密鍵が設定されていること（AGE-SECRET-KEY-で始まる） |
| unzip | システムにunzipコマンドがインストールされていること |
| age | システムにageコマンドがインストールされていること |
| tar | システムにtarコマンドがインストールされていること |
| lldb (または指定デバッガ) | システムにデバッガがインストールされていること |

### 実行可否判定

- PID、build-url、cores-urlのいずれかが未指定の場合、エラーをスローして終了
- AGE_CORES_IDENTITYが未設定または無効な形式の場合、エラーをスローして終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -p, --pid | string | Yes | なし | クラッシュしたテストのPID |
| -b, --build-url | string | Yes | なし | bun-profile.zipアーティファクトのURL |
| -c, --cores-url | string | Yes | なし | bun-cores.tar.gz.ageアーティファクトのURL |
| -d, --debugger | string | No | lldb | 使用するデバッガのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| BuildKite Artifacts | ZIP/TAR.GZ.AGE | デバッグバイナリとコアダンプ |
| 環境変数 | 文字列 | AGE_CORES_IDENTITY（復号化キー） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 一時ディレクトリ | ファイル | 展開されたバイナリとコアダンプ |
| 標準出力 | テキスト | 処理状況のログ |
| デバッガ | インタラクティブ | lldbセッション |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 一時ディレクトリ | `/tmp/debug-coredump-{hash}.tmp` |
| bun-profile | 展開されたデバッグバイナリ |
| bun-{PID}.core | 展開されたコアダンプファイル |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ pid, build-url, cores-url, debuggerを取得

2. 入力検証
   └─ 必須パラメータとAGE_CORES_IDENTITYの検証

3. 一時ディレクトリ作成
   └─ URLのハッシュを使用して一意のディレクトリを生成

4. キャッシュ確認
   └─ 既にダウンロード済みの場合はスキップ

5. bun-profile.zipダウンロード
   └─ fetchでダウンロード、unzipで展開

6. コアダンプダウンロード
   └─ fetchでダウンロード、ageで復号化、tarで展開

7. コアファイル移動
   └─ ネストされたディレクトリからコアファイルを移動

8. デバッガ起動
   └─ lldb --core {core} {binary}
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{パラメータ検証}
    C -->|失敗| D[エラー終了]
    C -->|成功| E{キャッシュ存在?}
    E -->|あり| F[キャッシュ使用]
    E -->|なし| G[bun-profile.zipダウンロード]
    G --> H[ZIP展開]
    H --> I[コアダンプダウンロード]
    I --> J[age復号化]
    J --> K[tar展開]
    K --> L[コアファイル移動]
    F --> M[コアファイル特定]
    L --> M
    M --> N[デバッガ起動]
    N --> O[バッチ終了]
```

## データベース操作仕様

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | PID未指定 | -pオプションでPIDを指定 |
| - | Error | build-url未指定 | -bオプションでURLを指定 |
| - | Error | cores-url未指定 | -cオプションでURLを指定 |
| - | Error | AGE_CORES_IDENTITY無効 | 正しい秘密鍵を設定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 引数とURLの正確性を確認
2. AGE_CORES_IDENTITY環境変数を確認
3. ネットワーク接続を確認
4. 外部コマンド（unzip、age、tar、lldb）のインストールを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件/実行 |
| 目標処理時間 | ダウンロードサイズに依存（数分程度） |
| メモリ使用量上限 | コアダンプサイズに依存 |

## 排他制御

同一URLハッシュに対しては一時ディレクトリが共有されます。同時実行時は競合の可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | ダウンロード開始時 | `downloading bun-profile.zip` |
| 標準出力 | コアダウンロード開始時 | `downloading cores` |
| 標準出力 | ファイル移動時 | `moving cores out of nested directory` |
| 標準出力 | キャッシュ使用時 | `already downloaded in {dir}` |
| 標準出力 | デバッガ起動時 | `launching debugger:` + コマンド |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特になし | - | - |

## 備考

- コアダンプはageで暗号化されており、復号化にはAGE_CORES_IDENTITY環境変数が必要です
- ダウンロードしたファイルは/tmp配下にキャッシュされ、同じURLへの再アクセス時は再利用されます
- デバッガの終了コードがバッチの終了コードとして使用されます
- BuildKiteのビルド失敗時に表示されるPIDとURLを使用します
