# バッチ設計書 14-cleartrace.ts

## 概要

本ドキュメントは、スタックトレースのクリーニング処理を行うバッチ処理「cleartrace.ts」の設計書です。

### 本バッチの処理概要

ビルド出力やテスト実行時のスタックトレースをリアルタイムで解析し、不要な内部フレームを除去・強調表示することで可読性を向上させるストリーム処理バッチです。

**業務上の目的・背景**：Bunの開発中、ビルドやテストの出力には大量のスタックトレースが含まれることがあります。これらのスタックトレースには、多くの内部実装詳細（printエラー処理、logger、標準ライブラリのフレーム等）が含まれており、実際の問題箇所を特定する際の妨げになります。このバッチは、そのような冗長な情報を視覚的に抑制（グレーアウト）し、エラーメッセージや重要な情報を強調表示することで、開発者のデバッグ効率を向上させます。

**バッチの実行タイミング**：開発者が手動で、`bun run watch 2>&1 | bun scripts/cleartrace`のようにパイプで接続して使用します。

**主要な処理内容**：
1. 標準入力からテキストストリームを行単位で受信
2. 100msのデバウンス処理で入力をバッファリング
3. cleartrace-impl.jsを子プロセスとして起動し、バッファされた内容を処理
4. cleartrace-impl.jsが行ごとにパターンマッチングを実行
5. エラー行は赤色、ノート行はシアン、無視対象行はグレーで出力

**前後の処理との関連**：任意のコマンド出力をパイプで受け取る独立したフィルターツールです。bun run watchやbun testなどと組み合わせて使用します。

**影響範囲**：標準出力への出力のみで、ファイルシステムや他のシステムへの影響はありません。

## バッチ種別

ストリーム処理 / テキストフィルタリング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行（パイプ入力） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 標準入力 | テキストストリームが供給されること |
| cleartrace-impl.js | scripts/cleartrace-impl.jsが存在すること |

### 実行可否判定

特別な実行可否判定はありません。標準入力が閉じられるまで処理を継続します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| 標準入力 | stream | Yes | なし | 処理対象のテキストストリーム |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 標準入力 | テキストストリーム | コマンド出力のパイプ入力 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | ANSI色付きテキスト | フィルタリング・色付けされた出力 |

### 出力ファイル仕様

ファイル出力はありません。

| 項目 | 内容 |
|-----|------|
| 出力形式 | ANSIエスケープシーケンス付きテキスト |
| エラー行 | 赤色（\x1b[31m） |
| ノート行 | シアン（\x1b[36m） |
| 無視対象行 | グレー（\x1b[2m） |

## 処理フロー

### 処理シーケンス

```
1. readline初期化
   └─ 標準入力からのストリーム読み込みを設定

2. 行受信ループ
   └─ 行をchunk配列にバッファリング

3. デバウンス処理（100ms）
   └─ 100ms間入力がない場合に処理を実行

4. 子プロセス起動
   └─ cleartrace-impl.jsにバッファ内容を送信

5. フィルタリング（cleartrace-impl.js）
   └─ パターンマッチングで行を分類・色付け

6. 出力
   └─ 色付けされた行を標準出力に出力

7. ストリーム終了
   └─ 入力終了時にプロセスを終了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[readline初期化]
    B --> C[行受信待機]
    C --> D[行をバッファに追加]
    D --> E{100ms経過?}
    E -->|いいえ| C
    E -->|はい| F[cleartrace-impl.js起動]
    F --> G[バッファ送信]
    G --> H[フィルタリング処理]
    H --> I[色付き出力]
    I --> J{ストリーム終了?}
    J -->|いいえ| C
    J -->|はい| K[終了]
```

## フィルタリングルール（cleartrace-impl.js）

### 無視対象パターン（グレー表示）

以下のパターンを含む行はグレー（薄暗く）表示されます：

- `print__anon_`
- `printError__anon_`
- `printErrorln__anon_`
- `prettyWithPrinter__anon_`
- `prettyErrorLn__anon_`
- `err [inlined]`
- `createErrorInstance__anon_`
- `allocPrint__anon_`
- `createFormat__anon_`
- `fmt__anon_`
- `toInvalidArguments__anon_`
- `throwInvalidArguments__anon_`
- `printStringPretty__anon_`
- `throwErrInvalidArgType`
- `validateObject__`
- `allocPrint `
- `addWarningFmt_`
- `logger.zig`
- `output.zig`
- `vendor/zig/lib/std`
- `ErrorCode.zig`

### 強調表示パターン

- `: error: ` を含む行 → 赤色表示
- `: note: ` を含む行 → シアン表示
- `@compileError("` を含む行 → 次の行をスキップ

## データベース操作仕様

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 特になし | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

cleartrace-impl.jsの存在を確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 無制限（ストリーム処理） |
| 目標処理時間 | リアルタイム（100msデバウンス） |
| メモリ使用量上限 | バッファサイズに依存 |

## 排他制御

排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 常時 | フィルタリング済み出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特になし | - | - |

## 備考

- fishシェルでの使用例：`fish -c "bun run watch 2>&1 | bun scripts/cleartrace"`
- 100msのデバウンスにより、高速な出力でも効率的にバッチ処理されます
- cleartrace.tsはラッパーで、実際のフィルタリングロジックはcleartrace-impl.jsに実装されています
