# バッチ設計書 15-css-properties（generate_properties.ts）

## 概要

本ドキュメントは、CSSプロパティ定義からZigコードを自動生成するバッチ処理「generate_properties.ts」の設計書です。

### 本バッチの処理概要

CSSプロパティの定義オブジェクトを入力として、BunのCSSパーサーで使用するZigソースコード（Property、PropertyId、PropertyIdTag等）を自動生成するコード生成バッチです。

**業務上の目的・背景**：BunはCSSパーサー機能を内蔵しており、数百種類のCSSプロパティをサポートしています。各プロパティに対して、パース処理、シリアライズ処理、ベンダープレフィックス対応、論理グループ管理などの定型コードが必要です。これらを手動で記述するとミスが発生しやすく、保守も困難です。このバッチは、TypeScriptで定義されたプロパティメタデータから、これらのZigコードを自動生成することで、一貫性のある高品質なコードを効率的に生成します。

**バッチの実行タイミング**：CSSプロパティの追加・変更時に手動で実行します。npm scriptsでは`css-properties`として定義されています。

**主要な処理内容**：
1. TypeScriptで定義されたプロパティ定義オブジェクトを処理
2. Property union型（プロパティ値を保持）のZigコードを生成
3. PropertyId union型（プロパティ識別子）のZigコードを生成
4. PropertyIdTag enum型（プロパティタグ）のZigコードを生成
5. parse、toCss、deepClone、eql等のメソッドを自動生成
6. 生成したコードを`src/css/properties/properties_generated.zig`に出力
7. zig fmtでフォーマット

**前後の処理との関連**：生成されたZigコードはBunのCSSパーサーモジュールで使用されます。Bun本体のビルド前に実行する必要があります。

**影響範囲**：`src/css/properties/properties_generated.zig`ファイルのみに影響します。

## バッチ種別

コード生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CSSプロパティ変更時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 / npm scripts |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bun | Bunランタイムがインストールされていること |
| vendor/zig/zig.exe | Zigコンパイラが存在すること（フォーマット用） |

### 実行可否判定

特別な実行可否判定はありません。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| property_defs | Record<string, PropertyDef> | Yes | ハードコード | プロパティ定義オブジェクト |

### プロパティ定義構造（PropertyDef）

```typescript
type PropertyDef = {
  ty: string;                    // Zigの型名
  shorthand?: boolean;           // ショートハンドプロパティか
  valid_prefixes?: VendorPrefixes[]; // 有効なベンダープレフィックス
  logical_group?: {              // 論理グループ情報
    ty: LogicalGroup;
    category: PropertyCategory;
  };
  unprefixed?: boolean;          // プレフィックスなしをサポートするか
  conditional?: {                // 条件付きプロパティ
    css_modules: boolean;
  };
  eval_branch_quota?: number;    // Zig評価分岐クォータ
  parse_dont_make_unparsed?: boolean; // 失敗時にUnparsedPropertyを作らない
};
```

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースコード内定義 | TypeScriptオブジェクト | プロパティ定義（525行目以降） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| src/css/properties/properties_generated.zig | Zigソースコード | 生成されたプロパティコード |
| completed.md | Markdown | 完了したプロパティリスト（オプション） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | properties_generated.zig |
| 出力先 | src/css/properties/ |
| 文字コード | UTF-8 |
| フォーマット | zig fmt適用 |

## 処理フロー

### 処理シーケンス

```
1. prelude生成
   └─ import文と型定義を含むヘッダー部分を生成

2. Property union生成
   └─ 各プロパティのフィールドとメソッドを生成

3. PropertyId union生成
   └─ プロパティ識別子の定義とメソッドを生成

4. PropertyIdTag enum生成
   └─ プロパティタグと補助関数を生成

5. ファイル出力
   └─ 生成コードを順次ファイルに追記

6. フォーマット
   └─ zig fmtで整形
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[completed.md生成]
    B --> C[prelude生成・出力]
    C --> D[Property union生成・出力]
    D --> E[PropertyId union生成・出力]
    E --> F[PropertyIdTag enum生成・出力]
    F --> G[zig fmt実行]
    G --> H[バッチ終了]
```

## 生成されるZig構造

### Property union

プロパティ値を保持するunion型：
- 各CSSプロパティのフィールド
- parse、toCss、deepClone、eql等のメソッド
- propertyId、valueToCss、longhand等の補助メソッド

### PropertyId union

プロパティ識別子を表すunion型：
- ベンダープレフィックス付きプロパティはVendorPrefixを保持
- name、prefix、fromNameAndPrefix等のメソッド

### PropertyIdTag enum

プロパティを識別するenum型：
- hasVendorPrefix補助関数
- valueType補助関数

## データベース操作仕様

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ShellError | zig fmt失敗 | Zigコンパイラのインストールを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. vendor/zig/zig.exeの存在を確認
2. 生成されたZigコードの構文エラーを確認
3. プロパティ定義の型名が正しいか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約200プロパティ |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | Bun.$実行時 | echoコマンドの出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特になし | - | - |

## 備考

- サポートされるCSSプロパティ：background系、border系、flex系、margin/padding系、transform系、font系など約200種類
- 一部のプロパティ（animation系、filter系等）はコメントアウトされており、将来的な追加が予定されています
- 生成コードにはcomptime検証が含まれ、必要なメソッド（deepClone、parse、toCss、eql）の存在を確認します
