# バッチ設計書 16-uv-posix-stubs（generate_uv_posix_stubs.ts）

## 概要

本ドキュメントは、libuvのPOSIXスタブコードを自動生成するバッチ処理「generate_uv_posix_stubs.ts」の設計書です。

### 本バッチの処理概要

libuvヘッダーファイルからシンボル宣言を解析し、Linux/macOS向けのスタブ関数（未実装関数）を自動生成するコード生成バッチです。同時にテスト用のN-APIプラグインコードも生成します。

**業務上の目的・背景**：Bunはlibuv APIの一部をサポートしていますが、全てのAPIを実装しているわけではありません。Node.jsのN-APIモジュールがlibuv関数を呼び出した際に、未実装の関数に対しては明確なエラーメッセージを表示する必要があります。このバッチは、libuvヘッダーから関数宣言を解析し、`__bun_throw_not_implemented`を呼び出すスタブ関数を自動生成することで、未実装APIの呼び出しを適切にハンドリングします。

**バッチの実行タイミング**：libuv APIサポートの追加・変更時に手動で実行します。npm scriptsでは`uv-posix-stubs`として定義されています。

**主要な処理内容**：
1. generate_uv_posix_stubs_constants.tsからシンボルリストを読み込み
2. ripgrepでlibuvヘッダーファイルから各シンボルの宣言を検索
3. tree-sitter-cで関数宣言を解析し、パラメータ情報を抽出
4. スタブ関数のCコード（uv-posix-stubs.c）を生成
5. テスト用N-APIプラグイン（plugin.c）を生成
6. clang-formatでフォーマット

**前後の処理との関連**：生成されたCコードはBun本体のビルド時にコンパイルされ、libuv互換レイヤーとして組み込まれます。

**影響範囲**：
- `src/bun.js/bindings/uv-posix-stubs.c`
- `test/napi/uv-stub-stuff/plugin.c`

## バッチ種別

コード生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（libuv API変更時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 / npm scripts |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bun | Bunランタイムがインストールされていること |
| ripgrep (rg) | ripgrepがインストールされていること |
| tree-sitter | tree-sitterパッケージがインストールされていること |
| tree-sitter-c | tree-sitter-cパッケージがインストールされていること |
| clang-format (オプション) | コード整形用 |

### 実行可否判定

ripgrepが見つからない場合、エラーを出力して終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| symbols | string[] | Yes | 定数ファイルから | 生成対象のlibuv関数名リスト |
| test_skipped | string[] | Yes | 定数ファイルから | テスト生成をスキップする関数リスト |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| generate_uv_posix_stubs_constants.ts | TypeScript | シンボルリストとスキップリスト |
| libuv headers (*.h) | Cヘッダー | 関数宣言の解析元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| src/bun.js/bindings/uv-posix-stubs.c | Cソースコード | スタブ関数 |
| test/napi/uv-stub-stuff/plugin.c | Cソースコード | テスト用N-APIプラグイン |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| スタブファイル | uv-posix-stubs.c |
| テストプラグイン | test/napi/uv-stub-stuff/plugin.c |
| 文字コード | UTF-8 |
| フォーマット | clang-format適用 |

## 処理フロー

### 処理シーケンス

```
1. 依存チェック
   └─ ripgrepの存在を確認

2. シンボル検索
   └─ 各シンボルをlibuvヘッダーからripgrepで検索

3. 宣言解析
   └─ tree-sitter-cで関数宣言をパース

4. パラメータ抽出
   └─ 関数のパラメータ型と名前を抽出

5. スタブ生成
   └─ __bun_throw_not_implementedを呼ぶスタブを生成

6. テストプラグイン生成
   └─ N-API経由で各関数を呼び出すテストコードを生成

7. フォーマット
   └─ clang-formatで整形
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{ripgrep存在?}
    B -->|なし| C[エラー終了]
    B -->|あり| D[シンボルリスト読込]
    D --> E[各シンボルを検索]
    E --> F[宣言をtree-sitterでパース]
    F --> G[パラメータ抽出]
    G --> H[スタブコード生成]
    H --> I[テストプラグイン生成]
    I --> J{clang-format存在?}
    J -->|あり| K[フォーマット実行]
    J -->|なし| L[スキップ]
    K --> M[バッチ終了]
    L --> M
```

## 生成されるコード構造

### uv-posix-stubs.c

```c
// GENERATED CODE - DO NOT MODIFY BY HAND
#include "uv-posix-polyfills.h"

#if OS(LINUX) || OS(DARWIN)
UV_EXTERN int uv_async_init(uv_loop_t* loop, uv_async_t* async, uv_async_cb async_cb) {
  __bun_throw_not_implemented("uv_async_init");
  __builtin_unreachable();
}
// ... 他のスタブ関数
#endif
```

### テストプラグイン（plugin.c）

N-API経由でJavaScriptから各libuv関数を呼び出し、スタブが正しく動作するかテストするためのコードです。

## パラメータ解析の特殊ケース

以下の関数は特殊なパラメータ構造を持つため、overridesオブジェクトで手動定義されています：

- `uv_setup_args`: argc/argv形式
- `uv_udp_try_send2`: 複雑なポインタ引数

## データベース操作仕様

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | ripgrep未インストール | ripgrepをインストール |
| - | Error | シンボル未検出 | libuvヘッダーを確認 |
| - | Error | 複数マッチ | シンボル名の一意性を確認 |
| - | AssertionError | パース失敗 | tree-sitter解析を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ripgrepのインストールを確認
2. libuvヘッダーファイルの存在を確認
3. tree-sitterの依存関係を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜百シンボル程度 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | シンボル検索時 | `Looking for {symbol}` |
| 標準出力 | 複数行宣言検出時 | `Found multi-liner!` |
| 標準出力 | パラメータ解析時 | パラメータ詳細 |
| 標準エラー | エラー時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特になし | - | - |

## 備考

- 生成されたスタブは`__bun_throw_not_implemented`を呼び出し、その後`__builtin_unreachable()`でコンパイラに到達不能を通知します
- Linux/DarwinのみでコンパイルされるようOS条件分岐が含まれます
- テストプラグインのスキップリストにより、テストできない関数（argv依存等）は除外されます
