# バッチ設計書 17-nav2readme.ts

## 概要

本ドキュメントは、ドキュメントのナビゲーション構造からREADMEファイルの目次を再生成するバッチ処理「nav2readme.ts」の設計書です。

### 本バッチの処理概要

docs/nav.tsで定義されたドキュメントナビゲーション構造とdocs/guides/配下のガイドファイルを解析し、README.mdの目次セクション（Quick links、Guides）を自動再生成するバッチ処理です。

**業務上の目的・背景**：Bunプロジェクトには多数のドキュメントとガイドが存在し、これらはnav.tsで一元管理されています。README.mdの目次を手動で更新すると、nav.tsとの不整合が発生したり、新しいガイドの追加漏れが起こる可能性があります。このバッチは、ナビゲーション定義とガイドファイルから目次を自動生成することで、README.mdとドキュメント構造の同期を維持します。

**バッチの実行タイミング**：ドキュメントの追加・変更後に手動で実行します。

**主要な処理内容**：
1. docs/nav.tsからナビゲーション項目を読み込み
2. Quick linksセクション（ドキュメントへのリンク）を生成
3. docs/guides/配下のMarkdownファイルを再帰的にスキャン
4. 各ガイドのfront matterからname属性を抽出
5. カテゴリ別にソートしてGuidesセクションを生成
6. README.mdの該当セクションを置換して保存

**前後の処理との関連**：独立したドキュメント管理ツールです。docs/nav.tsの更新後に実行することが推奨されます。

**影響範囲**：README.mdファイルのみに影響します。

## バッチ種別

ドキュメント生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ドキュメント更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| docs/nav.ts | ナビゲーション定義ファイルが存在すること |
| docs/guides/ | ガイドディレクトリが存在すること |
| README.md | プロジェクトルートにREADME.mdが存在すること |

### 実行可否判定

README.mdに`## Quick links`と`## Contributing`マーカーが存在しない場合、エラーをスローして終了します。

## 入力仕様

### 入力パラメータ

コマンドライン引数はありません。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| docs/nav.ts | TypeScript | ナビゲーション定義 |
| docs/guides/*.md | Markdown | ガイドファイル群 |
| README.md | Markdown | 既存のREADME |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| README.md | Markdown | 更新されたREADME |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | README.md |
| 出力先 | プロジェクトルート |
| 文字コード | UTF-8 |
| 更新範囲 | ## Quick links から ## Contributing の間 |

## 処理フロー

### 処理シーケンス

```
1. ナビゲーション読込
   └─ docs/nav.tsのitemsを処理

2. Quick links生成
   └─ divider項目とリンク項目をMarkdown形式で生成

3. ガイドスキャン
   └─ docs/guides/配下のMDファイルを再帰取得

4. メタデータ抽出
   └─ 各ガイドのfront matterからnameを取得

5. ソート
   └─ カテゴリ（ディレクトリ）別、名前順でソート

6. Guides生成
   └─ カテゴリ別にリンクリストを生成

7. README更新
   └─ Quick linksからContributingの間を置換
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[nav.ts読込]
    B --> C[Quick links生成]
    C --> D[ガイドファイルスキャン]
    D --> E[メタデータ抽出]
    E --> F[カテゴリ別ソート]
    F --> G[Guides生成]
    G --> H[README.md読込]
    H --> I{マーカー検出?}
    I -->|なし| J[エラー終了]
    I -->|あり| K[セクション置換]
    K --> L[README.md保存]
    L --> M[バッチ終了]
```

## 生成される目次構造

### Quick linksセクション

```markdown
## Quick links

- Category Name
  - [Document Title](https://bun.com/docs/slug)
  - [Another Document](https://bun.com/docs/another-slug)
```

### Guidesセクション

```markdown
## Guides

- Category name
  - [Guide Title](https://bun.com/guides/category/guide-slug)
```

## カテゴリ名の正規化

normalizeSectionName関数により以下の変換が行われます：
- ハイフン区切り → スペース区切り（先頭のみ大文字）
- `Https` → `HTTPS`
- `Http` → `HTTP`
- `Websocket` → `WebSocket`

## データベース操作仕様

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | ## Quick linksマーカー未検出 | README.mdにマーカーを追加 |
| - | Error | ## Contributingマーカー未検出 | README.mdにマーカーを追加 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. README.mdに必要なマーカーが含まれているか確認
2. docs/nav.tsが正しくエクスポートされているか確認
3. docs/guides/配下のファイル構造を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百ファイル |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | - |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特になし | - | - |

## 備考

- nav.tsのitems配列はdivider（カテゴリ区切り）とリンク項目で構成されます
- ガイドファイルのfront matterでname属性が定義されている必要があります
- リンクURLはhttps://bun.com/docs/およびhttps://bun.com/guides/を使用します
- 既存のREADME内容（Contributing以降）は保持されます
