# バッチ設計書 19-pack-codegen-for-zig-team.ts

## 概要

本ドキュメントは、Zigチームへのバグ報告用にコード生成結果をパッケージ化するバッチ処理「pack-codegen-for-zig-team.ts」の設計書です。

### 本バッチの処理概要

Zigコンパイラのバグを報告する際に、Bunのコード生成結果と関連ファイルを最小限の再現ケースとしてパッケージ化するバッチ処理です。

**業務上の目的・背景**：BunはZig言語で実装されており、Zigコンパイラの内部エラー（ICE: Internal Compiler Error）に遭遇することがあります。Zigチームにバグを報告する際には、最小限の再現ケースを提供する必要があります。このバッチは、クラッシュしたZigコマンドから依存ファイルを抽出し、Zigチーム向けの再現パッケージを自動生成することで、バグ報告の効率化を図ります。

**バッチの実行タイミング**：Zigコンパイラエラーが発生した際に手動で実行します。

**主要な処理内容**：
1. Git作業ディレクトリの状態をチェック（ローカル変更がないことを確認）
2. コマンドライン引数からZigビルドコマンドを解析
3. 引数からZigファイルパスを抽出
4. 各Zigファイル内の@import/@embedFileを再帰的に解析して依存ファイルを収集
5. zig fmtで--upstreamフラグ付きでフォーマット（公式Zigコンパイラ互換に変換）
6. 引数リストをbuild/all.argsに出力
7. tarでcodegen-for-zig-team.tar.gzにパッケージ化
8. 作業ディレクトリの変更を元に戻す

**前後の処理との関連**：Zigコンパイラエラー発生後に単独で実行される独立したツールです。

**影響範囲**：
- build/all.args（引数ファイル）
- codegen-for-zig-team.tar.gz（出力パッケージ）
- srcディレクトリ（一時的にzig fmt実行、終了時に元に戻す）

## バッチ種別

デバッグ支援 / パッケージ作成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（Zigバグ報告時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 作業ディレクトリ | ローカル変更がない（git statusがクリーン） |
| vendor/zig/zig | Zigコンパイラが存在すること |
| tar | tarコマンドが利用可能 |

### 実行可否判定

- Gitの作業ディレクトリに未コミットの変更がある場合、エラーを出力して終了
- 引数がない場合、使用方法を出力して終了
- 最初の引数がzigコマンドでない場合、エラーを出力して終了
- build-objではなくbuildが指定された場合、エラーを出力して終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| 引数 | string[] | Yes | なし | クラッシュしたzigコマンドの完全な引数リスト |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | 文字列配列 | zigビルドコマンド全体 |
| Zigソースファイル | Zigソースコード | @import/@embedFileの解析対象 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| build/all.args | テキスト | zig引数ファイル |
| codegen-for-zig-team.tar.gz | tar.gz | 再現パッケージ |
| 標準出力 | テキスト | 再現手順 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| パッケージ名 | codegen-for-zig-team.tar.gz |
| 出力先 | プロジェクトルート |
| 内容 | all.args + 依存Zigファイル |

## 処理フロー

### 処理シーケンス

```
1. Git状態チェック
   └─ ローカル変更がないことを確認

2. 引数解析
   └─ --listen=-, --zig-lib-dirを除去

3. 引数検証
   └─ zigコマンドかつbuild-objであることを確認

4. ファイルパス抽出
   └─ 引数から=を含むファイルパスを抽出

5. 依存解析
   └─ @import/@embedFileを再帰的に解析

6. zig fmt実行
   └─ --upstreamフラグでフォーマット

7. 引数ファイル生成
   └─ -fsanitize-addressを除去してall.argsに出力

8. パッケージ作成
   └─ tarで圧縮

9. クリーンアップ
   └─ git restore --worktreeで変更を元に戻す

10. 再現手順出力
    └─ 標準出力に手順を表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{Git作業ディレクトリクリーン?}
    B -->|いいえ| C[エラー終了]
    B -->|はい| D[引数解析]
    D --> E{引数検証OK?}
    E -->|いいえ| F[使用方法表示・終了]
    E -->|はい| G[ファイルパス抽出]
    G --> H[依存ファイル解析]
    H --> I[zig fmt --upstream]
    I --> J{fmt成功?}
    J -->|いいえ| K[クリーンアップ・終了]
    J -->|はい| L[引数ファイル生成]
    L --> M[tar圧縮]
    M --> N{tar成功?}
    N -->|いいえ| O[エラー終了]
    N -->|はい| P[再現手順出力]
    P --> Q[クリーンアップ]
    Q --> R[バッチ終了]
```

## 依存ファイル解析

### 解析対象パターン

```typescript
@import("path/to/file")
@embedFile("path/to/file")
```

### 解析除外条件

- スラッシュ（/）を含まないパス
- ピリオド（.）を含まないパス
- プロジェクトディレクトリ外のパス（相対パスで..で始まる）

## 引数フィルタリング

以下の引数は出力から除外されます：
- `--listen=-`
- `--zig-lib-dir` とその値
- `-fsanitize-address`（公式Zigでは利用不可）

## 出力される再現手順

```
pack-codegen-for-zig-team
Reminder: Test that the reproduction steps work with the official Zig binary before submitting the issue.

Output file: codegen-for-zig-team.tar.gz

Reproduction steps:

Download codegen-for-zig-team.tar.gz
```sh
cd /empty/folder
wget ....
tar -xvzf codegen-for-zig-team.tar.gz
zig build-obj @build/all.args
```
```

## データベース操作仕様

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | ローカル変更あり | 変更をコミットまたはstash |
| - | Error | 引数なし | クラッシュしたzigコマンド全体を引数に指定 |
| - | Error | zigコマンドでない | 正しいzigコマンドを指定 |
| - | Error | buildサブコマンド | build-objコマンドを使用 |
| - | Error | tar失敗 | 出力ディレクトリとファイルを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. git statusでローカル変更を確認
2. 引数として渡すzigコマンドを確認
3. vendor/zig/zigの存在を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | zig fmt失敗時、tar完了後にgit restoreで元に戻す |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百ファイル |
| 目標処理時間 | 数十秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

Gitの作業ディレクトリを変更するため、同時実行は不可です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | zig fmt失敗時 | `zig fmt failed.` |
| 標準出力 | tar失敗時 | `Failed to create zip: {exitCode}` |
| 標準出力 | 成功時 | 再現手順 |
| 標準出力 | 成功時 | `-> codegen-for-zig-team.tar.gz` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特になし | - | - |

## 備考

- 公式Zigコンパイラでの再現確認を行ってからバグ報告することが推奨されています
- zig fmt --upstreamフラグにより、BunのZigフォークから公式Zig互換の形式に変換されます
- 処理完了後、作業ディレクトリの変更は自動的に元に戻されます
- tarの--no-xattrsフラグにより、拡張属性は除外されます
